/* *##% Lima Swing
 * Copyright (C) 2008 - 2010 CodeLutin
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * ##%*/

package org.chorem.lima.ui.accountsreports;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Calendar;
import java.util.Date;
import static org.nuiton.i18n.I18n._;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.apache.commons.lang.time.DateUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.entity.FinancialPeriod;
import org.chorem.lima.entity.FiscalPeriod;
import org.chorem.lima.enums.ComboBoxDatesEnum;
import org.chorem.lima.ui.combobox.FinancialPeriodComboBoxModel;
import org.chorem.lima.ui.combobox.FinancialPeriodComboBoxRenderer;
import org.chorem.lima.ui.combobox.FiscalPeriodComboBoxModel;
import org.chorem.lima.ui.combobox.FiscalPeriodComboBoxRenderer;
import org.jdesktop.swingx.JXDatePicker;

public class AccountsReportsPeriodSearchPanel extends JPanel {
	
    private static final Log log =
        LogFactory.getLog(AccountsReportsPeriodSearchPanel.class);
	
	protected AccountsReportsViewHandler handler;
	
	public AccountsReportsPeriodSearchPanel(AccountsReportsViewHandler handler) {
		this.handler = handler;
		
		//init date
        refresh(ComboBoxDatesEnum.FISCAL_PERIOD);
	}
	
	static final long serialVersionUID = 1L;

	public void refresh(ComboBoxDatesEnum comboBoxPeriodEnum){
		
		switch (comboBoxPeriodEnum) {
		case PERIOD:
			// get begin date
		    Calendar calendarBegin = Calendar.getInstance();
		    // set begindate to JAN 1 - 0:00.000 of this years
		    Date beginDate = calendarBegin.getTime();
		    beginDate = DateUtils.truncate(beginDate, Calendar.YEAR);
		   //handler().setBeginDate(beginDate);
		    
		    // get end date
		    Calendar calendarEnd = Calendar.getInstance();
		    Date endDate = calendarEnd.getTime();
		    //handler().setEndDate(endDate);
		    JLabel beginDateLabel = new JLabel(_("lima.common.begindate"));
			final JXDatePicker beginDatePicker = new JXDatePicker(beginDate);
			ActionListener beginDateActionListener = new ActionListener() {		
				@Override
				public void actionPerformed(ActionEvent e) {
					handler.setBeginDate(beginDatePicker.getDate());
					handler.refresh();
				}
			};
	        handler.setBeginDate(beginDatePicker.getDate());
			beginDatePicker.addActionListener(beginDateActionListener);
			
			JLabel endDateLabel = new JLabel(_("lima.common.enddate"));
			final JXDatePicker endDatePicker = new JXDatePicker(endDate);
			ActionListener endDateActionListener = new ActionListener() {		
				@Override
				public void actionPerformed(ActionEvent e) {
					handler.setEndDate(endDatePicker.getDate());
					handler.refresh();
				}
			};
			handler.setEndDate(endDatePicker.getDate());
			endDatePicker.addActionListener(endDateActionListener);
			handler.refresh();
			
			this.removeAll();
			this.add(beginDateLabel);
			this.add(beginDatePicker);
			this.add(endDateLabel);
			this.add(endDatePicker);
			break;
			
		case FISCAL_PERIOD:
			FiscalPeriodComboBoxModel fiscalModel = new FiscalPeriodComboBoxModel();
			FiscalPeriodComboBoxRenderer fiscalRenderer = new FiscalPeriodComboBoxRenderer();
			final JComboBox fiscalPeriod = new JComboBox(fiscalModel);
			fiscalPeriod.setRenderer(fiscalRenderer);
			fiscalPeriod.setEditable(false);
			ActionListener fiscalPeriodActionListener = new ActionListener() {		
				@Override
				public void actionPerformed(ActionEvent e) {
					FiscalPeriod fPeriod = (FiscalPeriod) fiscalPeriod.getSelectedItem();
					if (fPeriod != null){
						handler.setBeginDate(fPeriod.getBeginDate());
						handler.setEndDate(fPeriod.getEndDate());
						handler.refresh();	
					}
				}
			};
			fiscalPeriod.addActionListener(fiscalPeriodActionListener);

			this.removeAll();
			this.add(fiscalPeriod);
			break;
			
		case FINANCIAL_PERIOD:
			FinancialPeriodComboBoxModel financialModel = new FinancialPeriodComboBoxModel();
			FinancialPeriodComboBoxRenderer financialRenderer = new FinancialPeriodComboBoxRenderer();
			final JComboBox financialPeriod = new JComboBox(financialModel);
			financialPeriod.setRenderer(financialRenderer);
			financialPeriod.setEditable(false);
			ActionListener financialPeriodActionListener = new ActionListener() {		
				@Override
				public void actionPerformed(ActionEvent e) {
					FinancialPeriod fPeriod = (FinancialPeriod) financialPeriod.getSelectedItem();
					if (fPeriod !=null){
						handler.setBeginDate(fPeriod.getBeginDate());
						handler.setEndDate(fPeriod.getEndDate());
						handler.refresh();	
					}
				}
			};
			financialPeriod.addActionListener(financialPeriodActionListener);
			this.removeAll();
			this.add(financialPeriod);
			break;
		}
		
	}
	
}
