/* *##% Lima Swing
 * Copyright (C) 2008 - 2010 CodeLutin
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * ##%*/

package org.chorem.lima.enums;

import static org.nuiton.i18n.I18n._;


public enum ComboBoxAccountsEnum {

	ALL(_("lima.enum.comboboxaccount.allaccount")),
	ACCOUNT(_("lima.enum.comboboxaccount.account")),
	ACCOUNT_LIST(_("lima.enum.comboboxaccount.accountlist"));
	
	private final String description;
	
	private ComboBoxAccountsEnum(String description) {
		this.description = description;
	}
	
	public String getDescription() {
	return this.description;
	}
	
	public static String[] descriptions(){
		int nbElts = ComboBoxAccountsEnum.values().length;
		String[] descriptions = new String[nbElts];
		ComboBoxAccountsEnum[] enums = ComboBoxAccountsEnum.values();
		for (int i = 0; i < nbElts; i++) {
			descriptions[i] = enums[i].getDescription();
		}
		return descriptions;
	}
	
	public static ComboBoxAccountsEnum valueOfDescription(String description){
		ComboBoxAccountsEnum value = null;
		
		for (ComboBoxAccountsEnum enums : ComboBoxAccountsEnum.values()) {
			if (description.equals(enums.description)){
				value = enums;
				break;
			}
		}
		return value;
	}
}
