/* *##% Lima Main
 * Copyright (C) 2008 - 2010 CodeLutin
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * ##%*/

package org.chorem.lima.actions;

import static org.nuiton.i18n.I18n._;

import org.chorem.lima.LimaConfig;
import org.chorem.lima.LimaMain;

/**
 * Les actions appellables via {@link LimaMain}.
 *
 * @author tony
 * @version $Revision: 3015 $
 * 
 * Last update : $Date: 2010-08-23 18:38:53 +0200 (Lun, 23 aoû 2010) $
 * By : $Author: jpepin $
 */
public class MiscAction {

    /** La configuration de l'application. */
    protected LimaConfig config;

    public MiscAction(LimaConfig config) {
        this.config = config;
    }

    public void help() {
        System.out.println(_("lima.message.help.usage"));
        for (LimaConfig.Option o : LimaConfig.Option.values()) {
            System.out.println("\t" + o.key + "(" + o.defaultValue + "):" + o.description);
        }

        System.out.println("Actions:");
        for (LimaConfig.Action a : LimaConfig.Action.values()) {
            System.out.println("\t" + java.util.Arrays.toString(a.aliases) + "(" + a.action + "):" + a.description);
        }
    }
}
