/*
 * #%L
 * Refcomp :: GWT client
 * 
 * $Id: UnitForm.java 238 2011-09-28 16:47:25Z jcouteau $
 * $HeadURL: svn+ssh://jcouteau@scm.mulcyber.toulouse.inra.fr/svnroot/refcomp/tags/refcomp-1.6/refcomp-client/src/main/java/fr/inra/refcomp/client/admin/units/UnitForm.java $
 * %%
 * Copyright (C) 2010 - 2011 Inra
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package fr.inra.refcomp.client.admin.units;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.uibinder.client.UiHandler;
import com.google.gwt.uibinder.client.UiTemplate;
import com.google.gwt.user.client.History;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HTMLPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.Panel;
import com.google.gwt.user.client.ui.TextBox;
import fr.inra.refcomp.client.constants.FormContent;
import fr.inra.refcomp.client.constants.Menu;
import fr.inra.refcomp.client.constants.RefcompCallBack;
import fr.inra.refcomp.client.constants.RefcompMessages;
import fr.inra.refcomp.client.services.StorageService;
import fr.inra.refcomp.client.services.StorageServiceAsync;
import fr.inra.refcomp.entities.Department;
import fr.inra.refcomp.entities.Unit;
import fr.inra.refcomp.services.AlreadyExistingException;
import fr.inra.refcomp.services.InvalidEntityException;
import java.util.ArrayList;
import java.util.List;
import org.nuiton.wikitty.entities.BusinessEntity;

/**
 * User: couteau
 * Date: 2 déc. 2010
 */
public class UnitForm extends Composite implements FormContent {

    private final StorageServiceAsync service = GWT
            .create(StorageService.class);

    @UiTemplate("UnitForm.ui.xml")
    interface MyUiBinder extends UiBinder<Panel, UnitForm> {
    }

    private static final MyUiBinder binder = GWT.create(MyUiBinder.class);

    private RefcompMessages messages = GWT.create(RefcompMessages.class);

    @UiField
    TextBox unitBox;

    @UiField
    TextBox fullNameUnitBox;

    @UiField
    TextBox addressBox;

    @UiField
    ListBox selectedDepartmentsBox;

    @UiField
    ListBox notSelectedDepartmentsBox;

    @UiField
    HTMLPanel errorPanel;

    @UiField
    Label errorLabel;

    Unit bean;

    @UiHandler("addUnitButton")
    public void manageAddUnit(ClickEvent event){
            int index = notSelectedDepartmentsBox.getSelectedIndex();
            addDepartment(index);
    }

    @UiHandler("removeUnitButton")
    public void manageRemoveUnit(ClickEvent event) {
            int index = selectedDepartmentsBox.getSelectedIndex();
            removeDepartment(index);
    }

    public UnitForm() {
        initWidget(binder.createAndBindUi(this));
        unitBox.setEnabled(false);
        fullNameUnitBox.setEnabled(false);
        addressBox.setEnabled(false);
    }

    @Override
    public void setContent(BusinessEntity bean) {
        if ((bean != null) && (bean instanceof Unit)) {
            this.bean = (Unit) bean;

            unitBox.setText(this.bean.getName());
            fullNameUnitBox.setText(this.bean.getFullName());
            addressBox.setText(this.bean.getAddress());
            unitBox.setEnabled(true);
            fullNameUnitBox.setEnabled(true);
            addressBox.setEnabled(true);
            errorPanel.setVisible(false);

            fillInDepartmentList();

            service.getDepartments(this.bean.getWikittyId(), new RefcompCallBack<List<Department>>(){
                @Override
                public void onSuccess(List<Department> result) {
                    for (Department department:result){
                        addDepartment(department);
                    }
                }
            });
        }
    }

    @Override
    public void clearContent() {
        bean = null;

        unitBox.setText("");
        fullNameUnitBox.setText("");
        addressBox.setText("");
        unitBox.setEnabled(false);
        fullNameUnitBox.setEnabled(false);
        addressBox.setEnabled(false);

        selectedDepartmentsBox.clear();
        notSelectedDepartmentsBox.clear();
        errorPanel.setVisible(false);
    }

    @Override
    public BusinessEntity getContent() {
        bean.setName(unitBox.getText());
        bean.setFullName(fullNameUnitBox.getText());
        bean.setAddress(addressBox.getText());
        return bean;
    }

    @Override
    public void saveContent(Boolean creation) {


        Boolean validate = Window.confirm(messages.sure());

        if (validate) {

            errorPanel.setVisible(false);

            service.saveUnit((Unit) getContent(), getSelectedDepartments(),
                    new RefcompCallBack<Unit>() {
                        @Override
                        public void onSuccess(Unit result) {
                            setContent(result);
                            AdminUnits.refresh();
                        }

                        @Override
                        public void onFailure(Throwable caught) {
                            if (caught instanceof InvalidEntityException) {
                                History.newItem("error");
                                errorPanel.setVisible(true);
                                errorLabel.setText(caught.getMessage());
                            } else {
                                Window.alert(messages.exception());
                            }
                        }
                    });
        }
    }

    @Override
    public void cancelContent(Boolean creation) {

        Boolean validate = Window.confirm(messages.sure());

        if (validate) {
            clearContent();
        }
    }

    @Override
    public void deleteContent() {
        Boolean validate = Window.confirm(messages.sure());

        if (validate) {

            service.deleteUnit((Unit) getContent(),
                    new RefcompCallBack<Void>() {
                        @Override
                        public void onSuccess(Void result) {
                            clearContent();
                            AdminUnits.refresh();
                        }
                    });
        }
    }

    /**
     * Fill in the departments list with all the departments.
     *
     * Must set the unit departments after that or you might get wrong data displayed.
     *
     */
    protected void fillInDepartmentList(){
        service.getDepartments(new RefcompCallBack<List<Department>>() {
            @Override
            public void onSuccess(List<Department> result) {
                notSelectedDepartmentsBox.clear();
                selectedDepartmentsBox.clear();

                for(Department department:result){
                    String text = department.getName();
                    String fullName = department.getFullName();
                    if (fullName != null && !fullName.isEmpty()) {
                        text += " - " + fullName;
                    }
                    notSelectedDepartmentsBox.addItem(text,
                            department.getWikittyId());
                }
            }
        });
    }

    protected void addDepartment(Department department){
        //not fan of this approach to run through all the list items,
        //but don't see another approach right now.
        int itemCount = notSelectedDepartmentsBox.getItemCount();

        for (int i=0;i<itemCount;i++){
            if(department.getWikittyId().equals(notSelectedDepartmentsBox.getValue(i))){
                addDepartment(i);
                return;
            }
        }
    }
    
    protected void addDepartment(int index){

        try {
            String value = notSelectedDepartmentsBox.getValue(index);
            String item = notSelectedDepartmentsBox.getItemText(index);

            List<String> selected = getSelectedDepartments();

            if (!selected.contains(value)){
                selectedDepartmentsBox.addItem(item, value);
            }

        } catch (IndexOutOfBoundsException eee){
            //Do nothing, nothing is selected in one of the lists, firing the exception
        }

    }

    protected void removeDepartment(int index) {

        try {
            selectedDepartmentsBox.removeItem(index);
        } catch (IndexOutOfBoundsException eee){
            //Do nothing, nothing is selected in one of the lists, firing the exception
        }

    }

    protected List<String> getSelectedDepartments(){

        List<String> departments = new ArrayList<String>();

        int itemCount = selectedDepartmentsBox.getItemCount();

        for (int i=0;i<itemCount;i++){
            String value = selectedDepartmentsBox.getValue(i);
            departments.add(value);
        }

        return departments;
    }
}
