/*
 * #%L
 * Wao :: Web Interface
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2011 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package fr.ifremer.wao.ui.components;

import fr.ifremer.wao.bean.ContactFilter;
import fr.ifremer.wao.bean.ContactFilterValues;
import fr.ifremer.wao.bean.ContactState;
import fr.ifremer.wao.entity.Contact;
import fr.ifremer.wao.service.ServiceContact;
import org.apache.tapestry5.SelectModel;
import org.apache.tapestry5.annotations.Parameter;
import org.apache.tapestry5.annotations.Persist;
import org.apache.tapestry5.ioc.Messages;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.util.EnumSelectModel;

import java.util.List;

/**
 * @author sletellier <letellier@codelutin.com>
 */
public class ContactFilterComponent extends FilterComponent<ContactFilter> {

    @Inject
    private Messages messages;

    @Inject
    private ServiceContact serviceContact;

    @Parameter(required = false)
    private Boolean synthesisMode;

    /*
     * Datas
     */
    @Persist
    private ContactFilterValues possibleValuesForFilter;

    @Override
    public void resetFilter() {
        ContactFilter filter = serviceContact.newContactFilter(getUser());
        if (getSynthesisMode()) {
            filter.setEstimatedTides(true);
        } else {
            filter.setOrderBy(Contact.PROPERTY_CREATION_DATE + " desc");
        }
        setFilter(filter);
    }

    @Override
    protected boolean isAvailableDataForFiltersOnly() {
        return false;
    }

    @Override
    public void updateSearchFields() {
        updatePossibleValuesForFilter();
    }

    public ContactFilterValues getPossibleValuesForFilter() {
        return getPossibleValuesForFilter(false);
    }

    public ContactFilterValues updatePossibleValuesForFilter() {
        return getPossibleValuesForFilter(true);
    }

    protected ContactFilterValues getPossibleValuesForFilter(boolean update) {
        if (update || possibleValuesForFilter == null) {
            possibleValuesForFilter = serviceContact.getPossibleValuesForFilter(getFilter());
        }
        return possibleValuesForFilter;
    }

    public SelectModel getContactStateSelectModel() {
        List<ContactState> allowedStates = ContactState.getAllowedStates(getUser().getProfile().getObsProgram());
        return new EnumSelectModel(ContactState.class, messages,
                                 // just convert list to array
                                 allowedStates.toArray(new ContactState[allowedStates.size()]));
    }

    @Override
    public Boolean getFiltersVisible() {

        // If visible on startup
        Boolean filtersVisible = super.getFiltersVisible();
        if (filtersVisible == null) {
            filtersVisible = getVisibleOnStartup();

            // If somthing is selected
            if (!filtersVisible) {
                filtersVisible = !getFilter().isFiltered();
            }
        }

        return filtersVisible;
    }

    public Boolean getSynthesisMode() {
        if (synthesisMode == null) {
            synthesisMode = Boolean.FALSE;
        }
        return synthesisMode;
    }

    public boolean showTerrestrialLocations() {
        boolean show = getFilter().getSamplingFilter().getObservationUnit() != null
                    || getFilter().getSamplingFilter().getTerrestrialDistrict() != null;
        return show;
    }

    public String getFormatForPeriod() {
        return "dd/MM/yyyy";
    }
}
