/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.wao.ui.services;

import fr.ifremer.wao.bean.ConnectedUser;
import fr.ifremer.wao.bean.ConnectedUserImpl;
import fr.ifremer.wao.bean.UserRole;
import fr.ifremer.wao.ui.data.RequiresAuthentication;
import fr.ifremer.wao.ui.services.ServiceAuthentication;
import org.apache.tapestry5.services.ApplicationStateManager;

public class ServiceAuthenticationImpl
implements ServiceAuthentication {
    private final ApplicationStateManager stateManager;

    public ServiceAuthenticationImpl(ApplicationStateManager stateManager) {
        this.stateManager = stateManager;
    }

    public boolean existConnectedUser() {
        return this.stateManager.exists(ConnectedUser.class);
    }

    public ConnectedUser getConnectedUser() {
        return (ConnectedUser)this.stateManager.getIfExists(ConnectedUser.class);
    }

    public void setConnectedUser(ConnectedUser user) {
        this.stateManager.set(ConnectedUser.class, (Object)user);
    }

    public boolean isAllowed(Class<?> page) {
        boolean isAllowed = false;
        if (this.existConnectedUser()) {
            if (page.isAnnotationPresent(RequiresAuthentication.class)) {
                RequiresAuthentication check = page.getAnnotation(RequiresAuthentication.class);
                ConnectedUser connectedUser = this.getConnectedUser();
                if (connectedUser.isReadOnly() && !check.readOnlyAllowed()) {
                    isAllowed = false;
                } else {
                    boolean roleAllowed = false;
                    boolean programAllowed = false;
                    for (UserRole userRole : check.allowedRoles()) {
                        if (!userRole.equals((Object)connectedUser.getRole())) continue;
                        roleAllowed = true;
                    }
                    if (roleAllowed) {
                        for (UserRole userRole : check.allowedPrograms()) {
                            if (!userRole.equals((Object)connectedUser.getProfile().getObsProgram())) continue;
                            programAllowed = true;
                        }
                    }
                    isAllowed = roleAllowed && programAllowed;
                }
            } else {
                isAllowed = true;
            }
        }
        return isAllowed;
    }

    public ConnectedUser getNewUserInstance() {
        return new ConnectedUserImpl();
    }
}

