/*
 * Decompiled with CFR 0.152.
 */
package winstone.auth;

import java.io.IOException;
import java.io.Serializable;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;

public class RetryRequestParams
implements Serializable {
    private String method;
    private String scheme;
    private String contextPath;
    private String servletPath;
    private String pathInfo;
    private String queryString;
    private String protocol;
    private int contentLength;
    private String contentType;
    private String encoding;
    private Map headers;
    private Vector locales;
    private Locale locale;
    private byte[] bodyContent;

    public RetryRequestParams(ServletRequest request) throws IOException {
        this.protocol = request.getProtocol();
        this.locales = new Vector(Collections.list(request.getLocales()));
        this.locale = request.getLocale();
        this.contentLength = request.getContentLength();
        this.contentType = request.getContentType();
        this.encoding = request.getCharacterEncoding();
        this.headers = new HashMap();
        if (request instanceof HttpServletRequest) {
            HttpServletRequest httpRequest = (HttpServletRequest)request;
            this.method = httpRequest.getMethod();
            this.contextPath = httpRequest.getContextPath();
            this.servletPath = httpRequest.getServletPath();
            this.pathInfo = httpRequest.getPathInfo();
            this.queryString = httpRequest.getQueryString();
            Enumeration names = httpRequest.getHeaderNames();
            while (names.hasMoreElements()) {
                String name = (String)names.nextElement();
                this.headers.put(name.toLowerCase(), new Vector(Collections.list(httpRequest.getHeaders(name))));
            }
        }
        if ((this.method == null || this.method.equalsIgnoreCase("POST")) && this.contentLength != -1) {
            ServletInputStream inData = request.getInputStream();
            this.bodyContent = new byte[this.contentLength];
            int readCount = 0;
            int read = 0;
            while ((read = inData.read(this.bodyContent, readCount, this.contentLength - readCount)) >= 0) {
                readCount += read;
            }
            inData.close();
        }
    }

    public byte[] getBodyContent() {
        return this.bodyContent;
    }

    public int getContentLength() {
        return this.contentLength;
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public Map getHeaders() {
        return this.headers;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public Vector getLocales() {
        return this.locales;
    }

    public String getMethod() {
        return this.method;
    }

    public String getPathInfo() {
        return this.pathInfo;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getQueryString() {
        return this.queryString;
    }

    public String getScheme() {
        return this.scheme;
    }

    public String getServletPath() {
        return this.servletPath;
    }

    public String getContextPath() {
        return this.contextPath;
    }
}

