/*
 * #%L
 * Wao :: Web Interface
 * 
 * $Id: Chart.java 650 2010-10-03 15:14:48Z fdesbois $
 * $HeadURL: http://svn.forge.codelutin.com/svn/wao/tags/wao-3.3.2/wao-ui/src/main/java/fr/ifremer/wao/ui/components/Chart.java $
 * %%
 * Copyright (C) 2009 - 2010 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

package fr.ifremer.wao.ui.components;

import org.apache.tapestry5.ComponentResources;
import org.apache.tapestry5.Link;
import org.apache.tapestry5.MarkupWriter;
import org.apache.tapestry5.StreamResponse;
import org.apache.tapestry5.annotations.Parameter;
import org.apache.tapestry5.annotations.Persist;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.services.Response;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;

/**
 * 
 * @author fdesbois <fdesbois@codelutin.com>
 */
public class Chart {

    /** titre du diagramme */
    @Parameter
    private String title = "";

    @Parameter(required = true)
    private JFreeChart chart;

    @Parameter(required = true)
    private int width;

    @Parameter(required = true)
    private int height;

    @Persist
    private JFreeChart currentChart;

    @Inject
    private ComponentResources resources;

    void beginRender(MarkupWriter writer) {

        currentChart = chart;

        // event link params
        Object[] params = new Object[] { title, width, height };

        // generate event link
        Link link = resources.createEventLink("chart", params);
        writer.element("img", "src", link);

        resources.renderInformalParameters(writer);
    }

    void afterRender(MarkupWriter writer) {
        writer.end();
    }

    public StreamResponse onChart(final String title, final int width, final int height) {
        // return the image
        return new StreamResponse() {
            @Override
            public String getContentType() {
                return "image/png";
            }

            @Override
            public InputStream getStream() throws IOException {
                ByteArrayOutputStream output = new ByteArrayOutputStream();
                ChartUtilities.writeChartAsPNG(output, currentChart, width, height);
                return new ByteArrayInputStream(output.toByteArray());
            }

            @Override
            public void prepareResponse(Response response) {
            }
        };
    }
}
