/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.wao.ui.pages;

import fr.ifremer.wao.WaoBusinessException;
import fr.ifremer.wao.WaoException;
import fr.ifremer.wao.bean.ConnectedUser;
import fr.ifremer.wao.bean.UserRole;
import fr.ifremer.wao.entity.SampleRow;
import fr.ifremer.wao.entity.SampleRowLog;
import fr.ifremer.wao.service.ServiceSampling;
import fr.ifremer.wao.ui.components.FeedBack;
import fr.ifremer.wao.ui.components.Layout;
import fr.ifremer.wao.ui.data.RequiresAuthentication;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.apache.tapestry5.annotations.Import;
import org.apache.tapestry5.annotations.InjectComponent;
import org.apache.tapestry5.annotations.Persist;
import org.apache.tapestry5.annotations.Property;
import org.apache.tapestry5.annotations.SessionState;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.slf4j.Logger;

@RequiresAuthentication
@Import(stylesheet={"context:css/sampling.css"})
public class SampleRowHistoric {
    @Inject
    private Logger log;
    @SessionState
    private ConnectedUser user;
    @InjectComponent
    private Layout layout;
    @Inject
    private ServiceSampling serviceSampling;
    private String sampleRowCode;
    @Persist
    private SampleRow sampleRow;
    @Property
    private SampleRowLog sampleRowLog;
    private SampleRowLog newLog;
    @InjectComponent
    private FeedBack addCommentInfo;

    void onActivate(String id) {
        this.sampleRowCode = id;
    }

    String onPassivate() {
        return this.sampleRowCode;
    }

    void setupRender() throws WaoException {
        if (StringUtils.isEmpty((CharSequence)this.sampleRowCode)) {
            this.layout.addFatal("L'historique ne peut pas \u00eatre affich\u00e9 : Aucun code de ligne n'est sp\u00e9cifi\u00e9 dans l'url. ");
        } else {
            try {
                this.sampleRow = null;
                this.getSampleRow();
            }
            catch (WaoBusinessException eee) {
                this.layout.addFatal("L'historique ne peut pas \u00eatre affich\u00e9 : " + eee.getMessage());
            }
            if (this.canAddComment()) {
                this.addCommentInfo.addInfo("L'ajout d'un commentaire enverra un email aux administrateurs du programme Obsmer");
            }
        }
    }

    public SampleRow getSampleRow() throws WaoBusinessException {
        if (this.sampleRow == null) {
            this.sampleRow = this.serviceSampling.getSampleRowByCode(this.user, this.sampleRowCode);
        }
        return this.sampleRow;
    }

    public DateFormat getDateFormat() {
        return new SimpleDateFormat("dd/MM/yyyy HH:mm:ss", Locale.FRENCH);
    }

    public String getContent() {
        String content = this.sampleRowLog.getLogText();
        content = content == null ? "Aucun changement enregistr\u00e9." : content.replaceAll("\\n", "<br />");
        return content;
    }

    public String getLogStyle() {
        String styleClass = "head-";
        styleClass = this.sampleRowLog.getFromAdmin() ? styleClass + "admin" : styleClass + "company";
        return styleClass;
    }

    public SampleRowLog getNewLog() throws WaoBusinessException {
        if (this.newLog == null) {
            this.newLog = this.serviceSampling.getNewSampleRowLog(this.getSampleRow(), this.user);
        }
        return this.newLog;
    }

    public boolean canAddComment() {
        return this.user.getRole().equals((Object)UserRole.COORDINATOR) && !this.user.isReadOnly();
    }

    public void onSuccessFromAddComment() throws WaoException {
        if (this.canAddComment()) {
            try {
                this.serviceSampling.createSampleRowLog(this.newLog);
            }
            catch (WaoBusinessException eee) {
                this.layout.addInfo(eee.getMessage());
            }
        }
    }
}

