/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.wao.ui.pages;

import fr.ifremer.wao.WaoBusinessException;
import fr.ifremer.wao.WaoException;
import fr.ifremer.wao.bean.ConnectedUser;
import fr.ifremer.wao.bean.ContactFilter;
import fr.ifremer.wao.bean.ContactState;
import fr.ifremer.wao.bean.ObsProgram;
import fr.ifremer.wao.bean.SamplingFilter;
import fr.ifremer.wao.bean.UserRole;
import fr.ifremer.wao.bean.ValidationResult;
import fr.ifremer.wao.entity.Contact;
import fr.ifremer.wao.entity.WaoUser;
import fr.ifremer.wao.io.ImportResults;
import fr.ifremer.wao.service.ServiceBoat;
import fr.ifremer.wao.service.ServiceContact;
import fr.ifremer.wao.service.ServiceReferential;
import fr.ifremer.wao.service.ServiceUser;
import fr.ifremer.wao.ui.components.ContactFilterComponent;
import fr.ifremer.wao.ui.components.Layout;
import fr.ifremer.wao.ui.data.ContactDataSource;
import fr.ifremer.wao.ui.data.GenericSelectModel;
import fr.ifremer.wao.ui.data.RequiresAuthentication;
import fr.ifremer.wao.ui.pages.Contacts;
import fr.ifremer.wao.ui.services.ContactModelFactory;
import fr.ifremer.wao.ui.services.WaoManager;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.List;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.tapestry5.ComponentResources;
import org.apache.tapestry5.StreamResponse;
import org.apache.tapestry5.annotations.Environmental;
import org.apache.tapestry5.annotations.Import;
import org.apache.tapestry5.annotations.InjectComponent;
import org.apache.tapestry5.annotations.Log;
import org.apache.tapestry5.annotations.Persist;
import org.apache.tapestry5.annotations.Property;
import org.apache.tapestry5.annotations.SessionState;
import org.apache.tapestry5.beaneditor.BeanModel;
import org.apache.tapestry5.corelib.components.Zone;
import org.apache.tapestry5.ioc.Messages;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.ioc.services.PropertyAccess;
import org.apache.tapestry5.services.BeanModelSource;
import org.apache.tapestry5.services.javascript.JavaScriptSupport;
import org.apache.tapestry5.upload.services.UploadedFile;
import org.slf4j.Logger;

@RequiresAuthentication(allowedRoles={UserRole.ADMIN, UserRole.COORDINATOR, UserRole.OBSERVER, UserRole.PROFESSIONAL})
@Import(stylesheet={"context:css/contacts.css"})
public class Contacts {
    @Inject
    private Logger logger;
    @InjectComponent
    private Layout layout;
    @SessionState
    @Property
    private ConnectedUser user;
    @Inject
    private ServiceBoat serviceBoat;
    @Inject
    private ServiceContact serviceContact;
    @Inject
    private ServiceReferential serviceReferential;
    @Environmental
    private JavaScriptSupport javascriptSupport;
    @Inject
    private WaoManager manager;
    @Inject
    private Messages messages;
    @InjectComponent
    private ContactFilterComponent filterComponent;
    @Persist
    private ContactFilter contactFilter;
    @InjectComponent
    private Zone importExportZone;
    private boolean reset;
    @Property
    private ContactState stateFilter;
    @Property
    private UploadedFile contactsCsvFile;
    @Persist
    @Property
    private Boolean fullView;
    @Inject
    private ServiceUser serviceUser;
    @Inject
    private BeanModelSource beanModelSource;
    @Inject
    private ComponentResources resources;
    @Persist
    private ContactDataSource contacts;
    @Property
    private Contact contact;
    private BeanModel<Contact> contactModel;
    @Inject
    private PropertyAccess propertyAccess;
    private GenericSelectModel<WaoUser> userSelectModel;
    @Persist
    private String contactSelectedId;
    @Property
    @Persist
    private String contactUserId;
    private boolean even = true;
    private Contact modifiedContact;

    public ServiceContact getServiceContact() {
        return this.serviceContact;
    }

    public String getLabelForEnum(Enum value) {
        return this.messages.get(value.getDeclaringClass().getSimpleName() + "." + value.name());
    }

    @Log
    void setupRender() throws WaoException {
        this.contacts = null;
        if (this.fullView == null) {
            this.fullView = this.user.isAdminOrProfessional();
        }
    }

    @Log
    void afterRender() {
        this.contactSelectedId = null;
    }

    public ContactFilter getContactFilter() throws WaoException {
        return (ContactFilter)this.filterComponent.getFilter();
    }

    public boolean isFiltersVisible() {
        return this.filterComponent.getFiltersVisible();
    }

    protected SamplingFilter getFilter() throws WaoException {
        return this.getContactFilter();
    }

    Object onActionFromShowImportExport() {
        return this.importExportZone.getBody();
    }

    Object onActionFromShowFilters() {
        this.filterComponent.switchFiltersVisible();
        return this.filterComponent;
    }

    void onSelectedFromReset() {
        this.reset = true;
    }

    public String[] onProvideCompletionsFromBoatName(String input) throws WaoException {
        List results = this.serviceBoat.getBoatNamesStartWith(input);
        return results.toArray(new String[results.size()]);
    }

    public boolean canImportExport() {
        return (this.user.isAdmin() || this.user.isCoordinator()) && !this.user.isReadOnly();
    }

    @Log
    void onSuccessFromImportContacts() throws WaoException {
        if (this.canImportExport()) {
            try {
                ImportResults result = this.serviceContact.importContactCsv(this.user, this.contactsCsvFile.getStream());
                this.contacts = null;
                this.layout.addInfo(result.getNbRowsImported() + " contacts " + "import\u00e9s,  " + result.getNbRowsRefused() + " refus\u00e9s.");
                for (String error : result.getErrors()) {
                    this.layout.addInfo(error);
                }
            }
            catch (WaoBusinessException eee) {
                this.layout.addError(new String[]{eee.getMessage()});
            }
        }
    }

    StreamResponse onActionFromExportShowContacts() {
        if (this.canImportExport()) {
            return new /* Unavailable Anonymous Inner Class!! */;
        }
        return null;
    }

    void onActionFromToggleDisplayMode() {
        this.fullView = this.fullView == false;
    }

    public void setContactSelectedId(String contactSelectedId) {
        this.contactSelectedId = contactSelectedId;
    }

    public ContactDataSource getContacts() throws WaoException {
        if (this.contacts == null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Create DataSource");
            }
            this.contacts = new ContactDataSource(this.getContactFilter(), this.serviceContact);
        }
        return this.contacts;
    }

    public BeanModel<Contact> getContactModel() {
        if (this.contactModel == null) {
            ContactModelFactory contactModelFactory = new ContactModelFactory(this.user.getProfile().getObsProgram(), this.user.getProfile().getUserRole(), this.fullView.booleanValue());
            this.contactModel = contactModelFactory.newModel(this.beanModelSource, this.resources);
        }
        return this.contactModel;
    }

    public GenericSelectModel<WaoUser> getUserSelectModel() {
        if (this.userSelectModel == null) {
            List users = this.serviceUser.getObservers(this.user.getCompany(), true);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Nb users : " + users.size());
            }
            this.userSelectModel = new GenericSelectModel(users, WaoUser.class, "fullName", "id", this.propertyAccess);
        }
        return this.userSelectModel;
    }

    public String getCommentDisplayText(String comment) {
        if (comment != null && comment.length() > 20) {
            return comment.substring(0, 20) + "...";
        }
        return comment;
    }

    public String getCommentTooltip(String comment) {
        return this.manager.getTooltipText(comment);
    }

    public String getSampleRowDescription() {
        return this.manager.getTooltipSampleRow(this.contact.getSampleRow());
    }

    public String getBoatDescription() {
        return this.manager.getTooltipBoat(this.contact.getBoat());
    }

    public String getSecondaryObservers() {
        StringBuilder result = new StringBuilder();
        result.append(this.contact.getMainObserver().getFullName());
        for (WaoUser observer : this.contact.getSecondaryObservers()) {
            result.append(", ");
            result.append(observer.getFullName());
        }
        return result.toString();
    }

    public String getTooltipExportFrom() throws WaoException {
        if (this.getContactFilter().getFromDate() != null) {
            return "depuis le " + this.getDateFormat().format(this.getContactFilter().getFromDate());
        }
        return "";
    }

    public String getGridClass() {
        return this.fullView != false ? "admin" : "user";
    }

    public String getRowClass() {
        String result = this.manager.getContactStyle(this.contact, this.user.isAdmin());
        if (this.contact.getTopiaId().equals(this.contactSelectedId)) {
            result = "selected";
        }
        return result;
    }

    public DateFormat getDateFormat() {
        return new SimpleDateFormat("dd/MM/yyyy");
    }

    public DateFormat getDateTimeFormat() {
        return new SimpleDateFormat("dd/MM/yyyy HH:mm");
    }

    public boolean isEmpty(Boolean validation) {
        return validation == null;
    }

    public boolean isBoardingDone() {
        return this.contact.getContactState() == ContactState.OBSERVATION_DONE;
    }

    public boolean hasActions() {
        return !this.user.isAdmin() && this.contact.getValidationCompany() == null && !this.user.isReadOnly();
    }

    public boolean hasValidationActions() {
        return (this.user.isAdmin() || this.user.isCoordinator()) && !this.user.isReadOnly();
    }

    public boolean canEditSampleRow() {
        boolean canEdit = this.user.getProfile().getCanWrite() != false && (this.user.isAdminAndCanWrite() && this.contact.getValidationProgram() == null || this.user.isCoordinatorOrObserver() && this.contact.getValidationCompany() == null);
        return canEdit;
    }

    public boolean canDeleteSampleRow() {
        boolean noValidation = this.contact.getValidationProgram() == null && this.contact.getValidationCompany() == null;
        return noValidation && this.user.getProfile().getCanWrite() != false;
    }

    public boolean canValidate() {
        switch (2.$SwitchMap$fr$ifremer$wao$bean$UserRole[this.user.getRole().ordinal()]) {
            case 1: {
                return this.contact.getValidationProgram() == null && BooleanUtils.isTrue((Boolean)this.contact.getValidationCompany());
            }
            case 2: {
                boolean requiredDataAreFilled = this.contact.getObsProgram() == ObsProgram.OBSMER ? this.contact.getRestitution() != null : this.contact.getDataInputDate() != null;
                ContactState state = this.contact.getContactState();
                boolean observationDone = state.equals((Object)ContactState.OBSERVATION_DONE) && requiredDataAreFilled;
                return this.contact.getValidationCompany() == null && (state.isUnfinishedState() || observationDone);
            }
        }
        return false;
    }

    public boolean canUnvalidate() {
        switch (2.$SwitchMap$fr$ifremer$wao$bean$UserRole[this.user.getRole().ordinal()]) {
            case 1: {
                return this.contact.getValidationProgram() != null;
            }
            case 2: {
                return this.contact.getValidationCompany() != null && this.contact.getValidationProgram() == null;
            }
        }
        return false;
    }

    @Log
    void onActionFromAcceptContact(String contactId) throws WaoException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Accept contact : " + contactId);
        }
        this.contactSelectedId = contactId;
        this.modifiedContact = (Contact)this.getContacts().get((Object)contactId);
        if (this.user.isAdmin()) {
            this.modifiedContact.setValidationProgram(Boolean.TRUE);
        } else {
            this.modifiedContact.setValidationCompany(Boolean.TRUE);
        }
        this.saveContact(this.modifiedContact);
    }

    @Log
    void onActionFromUnvalidateContact(String contactId) throws WaoException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Unvalidate contact : " + contactId);
        }
        this.contactSelectedId = contactId;
        this.modifiedContact = (Contact)this.getContacts().get((Object)contactId);
        if (this.user.isAdmin()) {
            this.modifiedContact.setValidationProgram(null);
        } else {
            this.modifiedContact.setValidationCompany(null);
        }
        this.saveContact(this.modifiedContact);
    }

    @Log
    void onActionFromRefuseContact(String contactId) throws WaoException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Refuse contact : " + contactId);
        }
        this.contactSelectedId = contactId;
        this.modifiedContact = (Contact)this.getContacts().get((Object)contactId);
        if (this.user.isAdmin()) {
            this.modifiedContact.setValidationProgram(Boolean.FALSE);
        } else {
            this.modifiedContact.setValidationCompany(Boolean.FALSE);
        }
        this.saveContact(this.modifiedContact);
    }

    protected void saveContact(Contact contact) {
        ValidationResult validationResult = this.serviceContact.validateContact(contact);
        if (validationResult.isSuccess()) {
            this.serviceContact.saveContact(this.user, contact, false);
        } else {
            this.layout.addError(new String[]{validationResult.getMessage()});
        }
    }

    @Log
    void onActionFromDeleteContact(String contactId) throws WaoException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Delete contact : " + contactId);
        }
        this.contactSelectedId = contactId;
        this.modifiedContact = (Contact)this.getContacts().get((Object)contactId);
        this.serviceContact.saveContact(this.user, this.modifiedContact, true);
    }

    static /* synthetic */ ServiceContact access$000(Contacts x0) {
        return x0.serviceContact;
    }
}

