/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.wao.ui.data;

import fr.ifremer.wao.bean.SamplingFilter;
import fr.ifremer.wao.bean.UserFilter;
import fr.ifremer.wao.bean.WaoFilter;
import fr.ifremer.wao.entity.Company;
import fr.ifremer.wao.entity.SampleRow;
import fr.ifremer.wao.service.ServiceSampling;
import fr.ifremer.wao.service.ServiceUser;
import fr.ifremer.wao.ui.data.GenericSelectModel;
import java.util.ArrayList;
import java.util.List;
import org.apache.tapestry5.SelectModel;
import org.apache.tapestry5.internal.OptionModelImpl;
import org.apache.tapestry5.internal.SelectModelImpl;
import org.apache.tapestry5.ioc.services.PropertyAccess;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FiltersModel<F extends WaoFilter> {
    private static final Logger logger = LoggerFactory.getLogger(FiltersModel.class);
    private PropertyAccess propertyAccess;
    private ServiceUser serviceUser;
    private ServiceSampling serviceSampling;
    private GenericSelectModel<Company> companySelectModel;
    private SelectModel programSelectModel;
    private GenericSelectModel<SampleRow> sampleRowSelectModel;
    private F filter;
    private boolean companyActive;

    public FiltersModel(PropertyAccess propertyAccess) {
        this.propertyAccess = propertyAccess;
    }

    public FiltersModel(PropertyAccess propertyAccess, F filter) {
        this(propertyAccess);
        this.filter = filter;
    }

    public void setServiceUser(ServiceUser serviceUser) {
        this.serviceUser = serviceUser;
    }

    public void setServiceSampling(ServiceSampling serviceSampling) {
        this.serviceSampling = serviceSampling;
    }

    public void setCompanyActive(boolean companyActive) {
        this.companyActive = companyActive;
    }

    public void update(F filter) {
        this.filter = filter;
    }

    public GenericSelectModel<Company> getCompanySelectModel() throws IllegalStateException {
        if (this.serviceUser == null) {
            throw new IllegalStateException("ServiceUser not exists to retrieve companies");
        }
        if (this.companySelectModel == null) {
            List companies = this.serviceUser.getCompanies(this.companyActive);
            this.companySelectModel = new GenericSelectModel(companies, Company.class, "name", "topiaId", this.propertyAccess);
        }
        return this.companySelectModel;
    }

    public void setCompanyId(String companyId) throws IllegalStateException {
        if (this.companySelectModel == null) {
            throw new IllegalStateException("Company selectModel not found !");
        }
        Company company = (Company)this.companySelectModel.findObject(companyId);
        this.getUserFilter().setCompany(company);
    }

    public String getCompanyId() {
        String companyId = null;
        if (this.getUserFilter().getCompany() != null) {
            companyId = this.getUserFilter().getCompany().getTopiaId();
        }
        return companyId;
    }

    public void updateCompany(String companyId) {
        this.setCompanyId(companyId);
        this.programSelectModel = null;
        this.sampleRowSelectModel = null;
    }

    public SelectModel getProgramSelectModel() {
        if (this.serviceSampling == null) {
            throw new IllegalStateException("ServiceSampling not exists to retrieve programs");
        }
        if (this.programSelectModel == null) {
            ArrayList<OptionModelImpl> options = new ArrayList<OptionModelImpl>();
            for (String programName : this.serviceSampling.getPrograms(this.getUserFilter().getCompany())) {
                options.add(new OptionModelImpl(programName, (Object)programName));
            }
            this.programSelectModel = new SelectModelImpl(null, options);
        }
        return this.programSelectModel;
    }

    public void updateProgram(String programName) {
        this.getSamplingFilter().setProgramName(programName);
        this.sampleRowSelectModel = null;
    }

    public GenericSelectModel<SampleRow> getSampleRowSelectModel() {
        if (this.serviceSampling == null) {
            throw new IllegalStateException("ServiceSampling not exists to retrieve sampleRows");
        }
        if (this.sampleRowSelectModel == null) {
            SampleRow rowFiltered = this.getSamplingFilter().getSampleRow();
            this.getSamplingFilter().setSampleRow(null);
            List sampleRows = this.serviceSampling.getSampleRowsByFilter(this.getSamplingFilter());
            this.getSamplingFilter().setSampleRow(rowFiltered);
            this.sampleRowSelectModel = new GenericSelectModel(sampleRows, SampleRow.class, "code", "topiaId", this.propertyAccess);
        }
        return this.sampleRowSelectModel;
    }

    public void setSampleRowId(String sampleRowId) {
        if (this.sampleRowSelectModel == null) {
            throw new IllegalStateException("SampleRow selectModel not found !");
        }
        SampleRow sampleRow = (SampleRow)this.sampleRowSelectModel.findObject(sampleRowId);
        this.getSamplingFilter().setSampleRow(sampleRow);
    }

    public String getSampleRowId() {
        String sampleRowId = null;
        if (this.getSamplingFilter().getSampleRow() != null) {
            sampleRowId = this.getSamplingFilter().getSampleRow().getTopiaId();
        }
        return sampleRowId;
    }

    public F getFilter() {
        return (F)this.filter;
    }

    protected UserFilter getUserFilter() {
        this.checkAssignableFrom(UserFilter.class);
        return (UserFilter)this.filter;
    }

    protected SamplingFilter getSamplingFilter() {
        this.checkAssignableFrom(SamplingFilter.class);
        return (SamplingFilter)this.filter;
    }

    private void checkAssignableFrom(Class filterClass) {
        if (!filterClass.isAssignableFrom(this.filter.getClass())) {
            throw new ClassCastException("SamplingFilter not assignable from " + this.filter.getClass().getName());
        }
    }
}

