/*
 * #%L
 * Wao :: Web Interface
 * 
 * $Id: Administration.java 1483 2012-01-12 15:42:30Z bleny $
 * $HeadURL: http://svn.forge.codelutin.com/svn/wao/tags/wao-3.2.2/wao-ui/src/main/java/fr/ifremer/wao/ui/pages/Administration.java $
 * %%
 * Copyright (C) 2009 - 2010 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

package fr.ifremer.wao.ui.pages;

import fr.ifremer.wao.WaoBusinessException;
import fr.ifremer.wao.WaoBusinessException.Type;
import fr.ifremer.wao.WaoException;
import fr.ifremer.wao.WaoProperty;
import fr.ifremer.wao.bean.ConnectedUser;
import fr.ifremer.wao.bean.GlobalIndicatorValue;
import fr.ifremer.wao.bean.GlobalSynthesisParameters;
import fr.ifremer.wao.bean.ReferentialState;
import fr.ifremer.wao.bean.UserRole;
import fr.ifremer.wao.entity.Company;
import fr.ifremer.wao.entity.CompanyImpl;
import fr.ifremer.wao.entity.Indicator;
import fr.ifremer.wao.entity.IndicatorLevel;
import fr.ifremer.wao.entity.UserProfile;
import fr.ifremer.wao.entity.UserProfileImpl;
import fr.ifremer.wao.entity.WaoUser;
import fr.ifremer.wao.io.ImportResults;
import fr.ifremer.wao.io.ImportResultsImpl;
import fr.ifremer.wao.service.ServiceBoat;
import fr.ifremer.wao.service.ServiceCartography;
import fr.ifremer.wao.service.ServiceReferential;
import fr.ifremer.wao.service.ServiceSampling;
import fr.ifremer.wao.service.ServiceSynthesis;
import fr.ifremer.wao.service.ServiceUser;
import fr.ifremer.wao.ui.components.Layout;
import fr.ifremer.wao.ui.data.ErrorReport;
import fr.ifremer.wao.ui.data.GenericSelectModel;
import fr.ifremer.wao.ui.data.ImportEngine;
import fr.ifremer.wao.ui.data.RequiresAuthentication;
import fr.ifremer.wao.ui.services.WaoManager;
import org.apache.commons.lang3.StringUtils;
import org.apache.tapestry5.EventContext;
import org.apache.tapestry5.OptionModel;
import org.apache.tapestry5.SelectModel;
import org.apache.tapestry5.annotations.Environmental;
import org.apache.tapestry5.annotations.Import;
import org.apache.tapestry5.annotations.InjectComponent;
import org.apache.tapestry5.annotations.Log;
import org.apache.tapestry5.annotations.Persist;
import org.apache.tapestry5.annotations.Property;
import org.apache.tapestry5.annotations.SessionState;
import org.apache.tapestry5.beaneditor.BeanModel;
import org.apache.tapestry5.beaneditor.Validate;
import org.apache.tapestry5.corelib.components.BeanEditForm;
import org.apache.tapestry5.corelib.components.Form;
import org.apache.tapestry5.corelib.components.Zone;
import org.apache.tapestry5.internal.OptionModelImpl;
import org.apache.tapestry5.ioc.Messages;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.ioc.services.PropertyAccess;
import org.apache.tapestry5.ioc.services.TypeCoercer;
import org.apache.tapestry5.services.BeanModelSource;
import org.apache.tapestry5.services.javascript.JavaScriptSupport;
import org.apache.tapestry5.util.EnumSelectModel;
import org.slf4j.Logger;

import java.io.FileNotFoundException;
import java.io.InputStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.List;

/**
 * Administration
 *
 * Created: 9 nov. 2009
 *
 * @author fdesbois <fdesbois@codelutin.com>
 */
@RequiresAuthentication(allowedRoles = {UserRole.ADMIN, UserRole.COORDINATOR}, readOnlyAllowed = false)
@Import(stylesheet = "context:css/administration.css", library = "context:js/administration.js")
public class Administration {

    @InjectComponent
    private Layout layout;

    @SessionState
    @Property
    private ConnectedUser currentUser;

    @Inject
    private Logger log;
                                  
    @Inject
    private WaoManager manager;

    @Inject
    private ServiceUser serviceUser;

    @Inject
    private ServiceReferential serviceReferential;

    @Inject
    private ServiceCartography serviceCartography;

    @Inject
    private TypeCoercer typeCoercer;

    @Environmental
    private JavaScriptSupport javaScriptSupport;

    @Property
    private String companyId;

    @Property
    private String userId;

    @Persist
    private List<Company> companies;

    @Inject
    private PropertyAccess propertyAccess;

    private GenericSelectModel<Company> companiesSelectModel;

    private Company company;

    private GenericSelectModel<WaoUser> usersSelectModel;

    @InjectComponent
    private BeanEditForm userForm;

    private boolean addNewCompanySelected;
    private boolean deleteCompanySelected;
    private boolean addNewUserSelected;
    private boolean showUserSelected;
    private boolean deleteUserSelected;

    void setupRender() throws WaoException {
        companies = null;
        getCompanies();
        userEdited = null;
        userModel = null;
    }

    void onActivate(EventContext ec) {
        if (ec.getCount() > 0) {
            companyId = ec.get(String.class, 0);
            if (ec.getCount() > 1) {
                userId = ec.get(String.class, 1);
            }
        } else if (currentUser.isCoordinator()) {
            companyId = currentUser.getCompany().getId();
        }
    }

    Object[] onPassivate() {
        return new String[] {companyId, userId};
    }

    void afterRender() {
        // Prototype class for UserSelect (manual usage because of specific style on options)
        javaScriptSupport.addScript("new AdminUserSelect();");
    }

   /**************************** IMPORTS (ADMIN) *******************************/

    @Inject
    private ServiceSampling serviceSampling;

    @Inject
    private ServiceBoat serviceBoat;

    public ImportEngine getFishingZoneImportEngine() {
        return new ImportEngine() {
            
            @Override
            public ImportResults execute(InputStream input)
                    throws WaoException, WaoBusinessException {
                int nbImported = serviceReferential.importFishingZoneCsv(input);
                ImportResults results = new ImportResultsImpl();
                results.setNbRowsImported(nbImported);
                return results;
            }
        };
    }

    public ImportEngine getSamplingPlanImportEngine() {
        return new ImportEngine() {

            @Override
            public ImportResults execute(InputStream input)
                    throws WaoException, WaoBusinessException {
                ImportResults results = serviceSampling.importSamplingPlanCsv(input, currentUser);
                return results;
            }
        };
    }

    @Log
    public ImportEngine getBoatImportEngine() {
        return new ImportEngine() {

            @Override
            public ImportResults execute(InputStream input)
                    throws WaoException, WaoBusinessException {
                ImportResults results = serviceBoat.importBoatCsv(input);
                return results;
            }
        };
    }

    public ImportEngine getActivityCalendarImportEngine() {
        return new ImportEngine() {

            @Override
            public ImportResults execute(InputStream input)
                    throws WaoException, WaoBusinessException {
                // Will execute a thread to import activityCalendars
                serviceBoat.importActivityCalendarCsv(input);
                // Errors will be written in an activityCalendarLogFile
                return null;
            }
        };
    }

    public ImportEngine getTerrestrialLocationsImportEngine() {
        return new ImportEngine() {

            @Override
            public ImportResults execute(InputStream input)
                    throws WaoException, WaoBusinessException {
                ImportResults importResults = serviceReferential.importTerrestrialLocations(input);
                return importResults;
            }
        };
    }

    public ImportEngine getTerrestrialDivisionsImportEngine() {
        return new ImportEngine() {

            @Override
            public ImportResults execute(InputStream input)
                    throws WaoException, WaoBusinessException {
                ImportResults importResults = serviceReferential.importTerrestrialDivisions(input);
                return importResults;
            }
        };
    }

    public ImportEngine getContactStateMotivesImportEngine() {
        return new ImportEngine() {
            @Override
            public ImportResults execute(InputStream input) throws WaoException, WaoBusinessException {
                ImportResults result = serviceReferential.importContactStateMotives(input);
                return result;
            }
        };
    }

    public ImportEngine getObsDebCodesImportEngine() {
        return new ImportEngine() {
            @Override
            public ImportResults execute(InputStream input) {
                ImportResults result = serviceReferential.importObsDebCodes(input);
                return result;
            }
        };
    }

    public ImportEngine getBoatGroupsImportEngine() {
        return new ImportEngine() {
            @Override
            public ImportResults execute(InputStream input) throws WaoException, WaoBusinessException {
                ImportResults results = serviceBoat.importBoatGroups(input);
                return results;
            }
        };
    }

    public InputStream getActivityCalendarLogFile() {
        return getActivityCalendarLogFile(WaoProperty.FILENAME_LOG_ACTIVITY_IMPORT);
    }

    public InputStream getActivityCalendarAccessLogFile() {
        return getActivityCalendarLogFile(WaoProperty.FILENAME_LOG_ACTIVITY_ACCESS);
    }
    
    private InputStream getActivityCalendarLogFile(WaoProperty property) {
        InputStream result = null;
        try {
            switch (property) {
                case FILENAME_LOG_ACTIVITY_ACCESS:
                    result = serviceBoat.getActivityCalendarLogAccessFile(); break;
                case FILENAME_LOG_ACTIVITY_IMPORT:
                    result = serviceBoat.getActivityCalendarLogFile();
            }
        } catch (FileNotFoundException eee) {
            if (log.isInfoEnabled()) {
                log.info("Not existing log file for " + property);
            }
        }
        return result;
    }

    public boolean isActivityCalendarImportRun() {
        return manager.isActivityCalendarImportRun();
    }

    public ImportEngine getBoatDistrictImportEngine() {
        return new ImportEngine() {

            @Override
            public ImportResults execute(InputStream input)
                    throws WaoException, WaoBusinessException {
                return serviceCartography.importBoatDistrictKml(input);
            }
        };
    }

    @Log
    void onImported(ErrorReport report) {
        for (String info : report.getInfos()) {
            layout.addInfo(info);
        }
        for (String error : report.getErrors()) {
            layout.addError(error);
        }
    }

    @Property // for loop
    private ReferentialState referentialState;

    public List<ReferentialState> getReferentialStates() {
        List<ReferentialState> referentialStates =
                serviceReferential.getReferentialStates(
                        currentUser.getProfile().getObsProgram());
        return referentialStates;
    }

    /**************************** EDITING COMPANIES ***************************/

    public List<Company> getCompanies() throws WaoException {
        if (companies == null) {
            companies = serviceUser.getCompanies(false);
        }
        return companies;
    }

    public GenericSelectModel<Company> getCompaniesSelectModel() throws WaoException {
        if (companiesSelectModel == null) {
            companiesSelectModel = new GenericSelectModel<Company>(getCompanies(),
                    Company.class, Company.PROPERTY_NAME, "id", propertyAccess);
        }
        return companiesSelectModel;
    }

    public Company getCompany() throws WaoException {
        if (company == null) {
            if (companyId != null) {
                company = getCompaniesSelectModel().findObject(companyId);
            } else {
                company = new CompanyImpl();
            }
        }
        return company;
    }

    public boolean isUsersAvailable() throws WaoException {
        return !StringUtils.isEmpty(getCompany().getId()) && getCompany().getActive();
    }

    void onSelectedFromAddNewCompany() {
        addNewCompanySelected = true;
    }

    void onSelectedFromDeleteCompany() {
        deleteCompanySelected = true;
    }

    void onSuccessFromActionsForm() {
        if (addNewCompanySelected) {
            companyId = null;            
        } else if (deleteCompanySelected && companyId != null) {
            company = getCompaniesSelectModel().findObject(companyId);
            try {
                serviceUser.deleteCompany(company);
                companyId = null;
                company = null;
                layout.addInfo("Société supprimée avec succès !");
            } catch (WaoBusinessException eee) {
                layout.addError(eee.getMessage());
            }
        }
        userId = null;
        userEdited = null;
    }

    void onSuccessFromCompany() throws WaoException {
        serviceUser.createUpdateCompany(company);
        companyId = company.getId();
    }

    /******************** USER ACTIONS FORM ***********************************/

    private List<WaoUser> users;

    @Property
    private WaoUser user;

    @Log
    public List<WaoUser> getUsers() {
        if (users == null) {
            users = serviceUser.getUsersByCompany(getCompany());
        }
        return users;
    }

//    @Log
//    public GenericSelectModel<WaoUser> getUsersSelectModel() throws WaoException {
//        if (usersSelectModel == null) {
//            List<WaoUser> users = serviceUser.getUsersByCompany(getCompany());
//            if (log.isDebugEnabled()) {
//                log.debug("Nb users : " + users.size());
//            }
//            usersSelectModel = new GenericSelectModel<WaoUser>(users, WaoUser.class,
//                    "fullName", "id", propertyAccess);
//        }
//        return usersSelectModel;
//    }

    private WaoUser findUser(String id) {
        for (WaoUser user : getUsers()) {
            if (user.getId().equals(id)) {
                return user;
            }
        }
        return null;
    }

    public String getUserOptionStyle() {
        String result = "";
        // Inactive user
        if (!user.getActive()) {
            result = "line-through";
        }
        return result;
    }

    @Log
    void onSelectedFromAddNewUser() {
        addNewUserSelected = true;
    }

    @Log
    void onSelectedFromDeleteUser() {
        deleteUserSelected = true;
    }

    @Log
    void onSelectedFromShowUser() {
        showUserSelected = true;
    }

    @Log
    void onSuccessFromUserActionsForm() throws WaoException {
        if (addNewUserSelected) {
            userId = null;
        } else if (deleteUserSelected && userId != null) {
            userEdited = findUser(userId);
            try {
                serviceUser.deleteUser(userEdited);
                userEdited = null;
                userId = null;
                layout.addInfo("Utilisateur supprimé avec succès !");
            } catch (WaoBusinessException eee) {
                layout.addError(eee.getMessage());
            }
        } else if (showUserSelected && userId != null) {
            userEdited = findUser(userId);
        }

        // reset : if user change, its profiles change
        editedUserProfiles = null;
        editedProfile = null;
        
        if (log.isDebugEnabled()) {
            log.debug("'User id : " + userId);
        }
    }

    /******************** USER PROFILE FORM ***********************************/

    @InjectComponent
    private Zone userFormZone;

    @Inject
    private BeanModelSource beanModelSource;

    /**
     * User is persistant cause of autobuild problem ?!?
     */
    @Persist
    private WaoUser userEdited;

    @Persist
    private BeanModel<WaoUser> userModel;

    @Property
    private boolean generatePassword;

    @Property
    private String password;

    public WaoUser getUserEdited() throws WaoException {
        if (userEdited == null) {
            if (userId == null) {
                userEdited = serviceUser.getNewUser(getCompany());
                generatePassword = true;
            } else {
                if (log.isDebugEnabled()) {
                    log.debug("User exist in selectModel : " + userId);
                }
                userEdited = findUser(userId);
            }
        }
        return userEdited;
    }

    public BeanModel<WaoUser> getUserModel() {
        if (userModel == null) {
            userModel = beanModelSource.createEditModel(WaoUser.class, messages);
            userModel.add("generatePassword", null);
            userModel.add("userRole", null);
            userModel.include(
                    WaoUser.PROPERTY_FIRST_NAME,
                    WaoUser.PROPERTY_LAST_NAME,
                    WaoUser.PROPERTY_LOGIN,
                    "generatePassword",
                    WaoUser.PROPERTY_PASSWORD,
                    WaoUser.PROPERTY_PHONE_NUMBER,
                    WaoUser.PROPERTY_MAMMALS_NOTIFICATIONS,
                    WaoUser.PROPERTY_ACTIVE,
                    "userRole"
            );
        }
        return userModel;
    }

    @Log
    void onSelectedFromUserForm() {
        refreshUserRoleZone = false;
    }

    @Log
    void onValidateFormFromUserForm() {
        userForm.clearErrors();

        getUserEdited().clearUserProfile(currentUser.getProfile().getObsProgram());
        getUserEdited().addAllUserProfile(getEditedUserProfiles());
    }

    @Log
    Object onSuccessFromUserForm() throws WaoException {
        if (log.isDebugEnabled()) {
            log.debug("User : " + userEdited);
            log.debug("User.active : " + userEdited.isActive());
            log.debug("User.login : " + userEdited.getLogin());
        }

        if (!StringUtils.isEmpty(password)) {
            userEdited.setPassword(password);
            userEdited.setPasswordChanged(true);
        }
        try {
            serviceUser.createUpdateUser(userEdited, generatePassword);
            userId = userEdited.getId();
        } catch (WaoBusinessException eee) {
            if (eee.getType().equals(Type.SMTP_NOT_FOUND)) {
                layout.addInfo(eee.getMessage());
                userId = userEdited.getId();
            } else {
                layout.addError(eee.getMessage());
            }
        }
        return this;
    }

    @Log
    Object onFailureFromUserForm() {
        return userForm;
    }

    /****************************** UserRole **********************************/

    @InjectComponent
    private Zone userRoleZone;

    private SelectModel userRoleSelectModel;

    @Persist
    private List<UserProfile> editedUserProfiles;

    @Persist
    @Property
    private UserProfile profile;

    @Persist
    private UserProfile editedProfile;

    @Persist
    @Property
    private boolean readOnly;

    @Property
    private UserRole role;

    @Property
    private int profileIndex;

    @Property
    private boolean refreshUserRoleZone;

    @Log
    public UserProfile getEditedProfile() {
        if (editedProfile == null) {
            editedProfile = new UserProfileImpl();

            // By default, rights has a scope on the same program as the current user is
            // ie an user connected as an Admin of the ObsMer program can give rights
            // only on the ObsMer program
            editedProfile.setObsProgram(currentUser.getProfile().getObsProgram());
        }
        return editedProfile;
    }

    @Log
    public SelectModel getUserRoleSelectModel() {
        if (userRoleSelectModel == null) {
            UserRole[] allowedRoles = UserRole.getAllowedRoles(
                                                currentUser.getProfile().getObsProgram(),
                                                currentUser.getProfile().getUserRole());
            return new EnumSelectModel(UserRole.class, messages, allowedRoles);
        }
        return userRoleSelectModel;
    }

    private OptionModel newUserRoleOption(UserRole role) {
        return new OptionModelImpl(role.getTranslation(), role);
    }

    @Log
    Zone onValueChangedFromUserRole(String value) {
        if (StringUtils.isEmpty(value)) {
            getEditedProfile().setUserRole(null);
        } else {
            getEditedProfile().setUserRole(UserRole.valueOf(value));
        }
        return userRoleZone;
    }

    @Log
    void onChangeFromReadOnly(boolean value) {
        if (log.isDebugEnabled()) {
            log.debug("readOnly value changed to " + value);
        }
        readOnly = value;
    }

    @Log
    public List<UserProfile> getEditedUserProfiles() {
        if (editedUserProfiles == null) {
            if (getUserEdited() != null) {
                editedUserProfiles = getUserEdited().getUserProfile(currentUser.getProfile().getObsProgram());
            }
        }
        return editedUserProfiles;
    }

    @Log
    Zone onActionFromAddRole() {

        if ( getEditedProfile() == null
          || getEditedProfile().getUserRoleOrdinal() == null) {
             return null;
        }

        boolean profileCanBeAdded = true;
        for (UserProfile userProfile : getEditedUserProfiles()) {
            if (userProfile.getUserRole() == getEditedProfile().getUserRole()) {
                profileCanBeAdded = false;
            }
        }

        if (profileCanBeAdded) {
            getEditedProfile().setCanWrite( ! readOnly);
            if (log.isDebugEnabled()) {
                log.debug("Add user profile : " + getEditedProfile().getDescription());
            }
            getEditedUserProfiles().add(getEditedProfile());
        }
        // Reset fields
        editedProfile = null;
        readOnly = false;
        // Refresh the zone
//        refreshUserRoleZone = true;
        return userRoleZone;
    }

    @Log
    Zone onActionFromRemoveRole(int roleIndex) {
        if (log.isDebugEnabled()) {
            log.debug("edited profiles before remove : " + getEditedUserProfiles());
        }

        getEditedUserProfiles().remove(roleIndex);

        if (log.isDebugEnabled()) {
            log.debug("edited profiles after remove : " + getEditedUserProfiles());
        }

        // Refresh the zone
//        refreshUserRoleZone = true;
        return userRoleZone;
    }

    /*********************** INDICATORS AND LEVELS ****************************/

    @Inject
    private ServiceSynthesis serviceSynthesis;

    private GlobalSynthesisParameters globalSynthesisParameters;

    /* variable used in view */
    @Property
    private Indicator indicator;

    public GlobalSynthesisParameters getGlobalSynthesisParameters() {
        if (globalSynthesisParameters == null) {
            globalSynthesisParameters = serviceSynthesis.getGlobalSynthesisParameters();
        }
        return globalSynthesisParameters;
    }

    @InjectComponent
    private Form synthesisParametersForm;

    /** The comment field value of the form. */
    @Property
    @Validate("required")
    private String comment;

    void onValidateFromSynthesisParametersForm() {

        // TODO bleny 20101027 check that for each level, upperBound is contained
        // between the upperBound of the lower level and the upperBound of
        // the higher level

    }

    void onSuccessFromSynthesisParametersForm() {
        serviceSynthesis.updateGlobalSynthesisParameters(
                getGlobalSynthesisParameters(), currentUser.getUser(), comment);
        getGlobalSynthesisParameters();
    }

    /* variable used in loop */
    @Property
    private IndicatorLevel indicatorLevel;

    public GlobalIndicatorValue getGlobalIndicatorValue() {
        if (log.isDebugEnabled()) {
            log.debug("indicatorLevel is " + indicatorLevel);
            log.debug(indicatorLevel.getLevel() + " is " +
                    GlobalIndicatorValue.valueOf(indicatorLevel.getLevel()));
        }
        return GlobalIndicatorValue.valueOf(indicatorLevel.getLevel());
    }

    public DateFormat getDateTimeFormat() {
        return new SimpleDateFormat("dd/MM/yyyy HH:mm");
    }

    /*************************************** I18N ****************************/

    @Inject
    private Messages messages;
}
