/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.wao.ui.components;

import fr.ifremer.wao.bean.ConnectedUser;
import fr.ifremer.wao.bean.SamplingFilter;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.tapestry5.ComponentResources;
import org.apache.tapestry5.annotations.InjectComponent;
import org.apache.tapestry5.annotations.Parameter;
import org.apache.tapestry5.annotations.Persist;
import org.apache.tapestry5.corelib.components.Zone;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.nuiton.util.PeriodDates;
import org.slf4j.Logger;

public abstract class FilterComponent<E extends SamplingFilter> {
    @Inject
    private Logger log;
    @Inject
    private ComponentResources resources;
    @Parameter(required=true)
    private ConnectedUser user;
    @Persist
    private E filter;
    @Parameter(required=false)
    private Boolean visibleOnStartup;
    @InjectComponent
    private Zone filtersZone;
    @Persist
    private Boolean filtersVisible;
    private boolean reset;
    private boolean refresh;

    public ConnectedUser getUser() {
        return this.user;
    }

    public E getFilter() {
        if (this.filter == null) {
            this.resetFilter();
        }
        return (E)this.filter;
    }

    public void setFilter(E filter) {
        this.filter = filter;
    }

    public abstract void resetFilter();

    protected abstract boolean isAvailableDataForFiltersOnly();

    public abstract void updateSearchFields();

    public ComponentResources getResources() {
        return this.resources;
    }

    public Boolean getVisibleOnStartup() {
        if (this.visibleOnStartup == null) {
            this.visibleOnStartup = true;
        }
        return this.visibleOnStartup;
    }

    public Boolean getFiltersVisible() {
        if (this.filtersVisible == null) {
            this.filtersVisible = this.getVisibleOnStartup();
        }
        return this.filtersVisible;
    }

    public void setFiltersVisible(Boolean filtersVisible) {
        this.filtersVisible = filtersVisible;
    }

    public void switchFiltersVisible() {
        this.filtersVisible = this.getFiltersVisible() == false;
    }

    public Zone getFiltersZone() {
        return this.filtersZone;
    }

    public DateFormat getDateFormat() {
        return new SimpleDateFormat("MM/yyyy");
    }

    public boolean isReset() {
        return this.reset;
    }

    public boolean isRefresh() {
        return this.refresh;
    }

    public void onSelectedFromReset() {
        this.reset = true;
    }

    public void onSelectedFromRefresh() {
        this.refresh = true;
    }

    public Object onSuccessFromFiltersForm() {
        PeriodDates period;
        if (this.isReset()) {
            this.resetFilter();
        }
        if ((period = this.getFilter().getPeriod()) != null) {
            Date fromDate = period.getFromDate();
            Date thruDate = period.getThruDate();
            if (thruDate.before(fromDate)) {
                period.setFromDate(thruDate);
                period.setThruDate(fromDate);
            }
        }
        this.updateSearchFields();
        if (this.isRefresh()) {
            return this;
        }
        return this.getResources().getContainer();
    }
}

