/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.wao.ui.pages;

import fr.ifremer.wao.bean.ConnectedUser;
import fr.ifremer.wao.bean.ContactFilter;
import fr.ifremer.wao.bean.ContactFilterImpl;
import fr.ifremer.wao.bean.UserRole;
import fr.ifremer.wao.bean.WaoFilter;
import fr.ifremer.wao.entity.Company;
import fr.ifremer.wao.service.ServiceSampling;
import fr.ifremer.wao.service.ServiceUser;
import fr.ifremer.wao.ui.data.FiltersModel;
import fr.ifremer.wao.ui.data.RequiresAuthentication;
import fr.ifremer.wao.ui.pages.KmlLoader;
import java.io.IOException;
import org.apache.tapestry5.Link;
import org.apache.tapestry5.annotations.InjectComponent;
import org.apache.tapestry5.annotations.Log;
import org.apache.tapestry5.annotations.Persist;
import org.apache.tapestry5.annotations.Property;
import org.apache.tapestry5.annotations.SessionState;
import org.apache.tapestry5.corelib.components.Zone;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.ioc.services.PropertyAccess;
import org.apache.tapestry5.services.PageRenderLinkSource;
import org.nuiton.util.PeriodDates;
import org.slf4j.Logger;

@RequiresAuthentication(allowedRoles={UserRole.ADMIN, UserRole.COORDINATOR, UserRole.OBSERVER, UserRole.PROFESSIONAL})
public class Cartography {
    @SessionState
    @Property
    private ConnectedUser user;
    @Inject
    private Logger logger;
    @Inject
    private PageRenderLinkSource pageRender;
    @Inject
    private PropertyAccess propertyAccess;
    @Inject
    private ServiceUser serviceUser;
    @Inject
    private ServiceSampling serviceSampling;
    private String url;
    @SessionState(create=false)
    private WaoFilter cartographyFilter;
    @Persist
    private FiltersModel<ContactFilter> filtersModel;
    @InjectComponent
    private Zone samplingFilterZone;
    @InjectComponent
    private Zone sampleRowFilterZone;

    void setupRender() {
    }

    public FiltersModel<ContactFilter> getFiltersModel() {
        if (this.filtersModel == null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Initialize FiltersModel");
            }
            this.filtersModel = new FiltersModel(this.propertyAccess, (WaoFilter)new ContactFilterImpl());
            this.filtersModel.setServiceUser(this.serviceUser);
            this.filtersModel.setServiceSampling(this.serviceSampling);
            this.filtersModel.setCompanyActive(true);
            if (this.user.isCoordinatorOrObserver()) {
                this.getFilter().setCompany(this.user.getCompany());
            }
            PeriodDates period = PeriodDates.createMonthsPeriodFromToday((int)-12);
            this.getFilter().setPeriod(period);
            this.getFilter().setObsProgram(this.user.getProfile().getObsProgram());
            this.cartographyFilter = this.getFilter();
        }
        return this.filtersModel;
    }

    public ContactFilter getFilter() {
        return (ContactFilter)this.getFiltersModel().getFilter();
    }

    public Company getCompany() {
        return this.getFilter().getCompany();
    }

    @Log
    Zone onValueChangedFromCompany(String companyId) {
        this.getFiltersModel().updateCompany(companyId);
        return this.samplingFilterZone;
    }

    @Log
    Zone onValueChangedFromProgramName(String programName) {
        this.getFiltersModel().updateProgram(programName);
        return this.sampleRowFilterZone;
    }

    void onSelectedFromReset() {
        this.filtersModel = null;
    }

    public String getUrl() throws IOException {
        if (this.url == null) {
            Link link = this.pageRender.createPageRenderLinkWithContext(KmlLoader.class, new Object[]{KmlLoader.StrategyValues.CONTACTS_STATES});
            this.url = link.toURI();
        }
        return this.url;
    }

    public String getTitle() {
        return "Contacts";
    }
}

