/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.wao.ui.components;

import fr.ifremer.wao.bean.SamplingFilter;
import fr.ifremer.wao.bean.SamplingFilterValues;
import fr.ifremer.wao.service.ServiceSampling;
import fr.ifremer.wao.ui.components.FilterComponent;
import org.apache.tapestry5.annotations.Parameter;
import org.apache.tapestry5.annotations.Persist;
import org.nuiton.util.PeriodDates;

public class SamplingFilterComponent
extends FilterComponent<SamplingFilter> {
    @Parameter(required=false)
    private Boolean showEstimatedTides;
    @Parameter(required=true)
    private String legendMsg;
    @Parameter(required=true)
    private ServiceSampling serviceSampling;
    @Persist
    private SamplingFilterValues possibleValuesForFilter;
    @Persist
    private boolean initFlag;

    protected boolean isAvailableDataForFiltersOnly() {
        return false;
    }

    public Boolean getFiltersVisible() {
        Boolean filtersVisible = super.getFiltersVisible();
        if (filtersVisible == null && !(filtersVisible = this.getVisibleOnStartup()).booleanValue()) {
            filtersVisible = !this.getFilter().isPeriodFilteredOnly();
        }
        return filtersVisible;
    }

    public void resetFilter() {
        PeriodDates period = null;
        if (this.initFlag) {
            SamplingFilter filter = this.getFilter();
            period = filter == null ? null : filter.getPeriod();
        } else {
            this.initFlag = true;
        }
        this.setFilter(this.serviceSampling.newSamplingFilter(this.getUser()));
        if (period != null) {
            this.getFilter().setPeriod(period);
        }
    }

    public void updateSearchFields() {
        this.updatePossibleValuesForFilter();
    }

    public SamplingFilterValues getPossibleValuesForFilter() {
        return this.getPossibleValuesForFilter(false);
    }

    public SamplingFilterValues updatePossibleValuesForFilter() {
        return this.getPossibleValuesForFilter(true);
    }

    protected SamplingFilterValues getPossibleValuesForFilter(boolean update) {
        if (update || this.possibleValuesForFilter == null) {
            this.possibleValuesForFilter = this.serviceSampling.getPossibleValuesForFilter(this.getFilter());
        }
        return this.possibleValuesForFilter;
    }

    public Boolean getShowEstimatedTides() {
        if (this.showEstimatedTides == null) {
            this.showEstimatedTides = false;
        }
        return this.showEstimatedTides;
    }

    public String getLegendMsg() {
        return this.legendMsg;
    }

    public String getFormatForPeriod() {
        String format = this.getUser().isObsDeb() ? "dd/MM/yyyy" : "MM/yyyy";
        return format;
    }
}

