/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.wao.ui.components;

import fr.ifremer.wao.WaoBusinessException;
import fr.ifremer.wao.WaoException;
import fr.ifremer.wao.io.ImportResults;
import fr.ifremer.wao.ui.data.ErrorReport;
import fr.ifremer.wao.ui.data.ImportEngine;
import fr.ifremer.wao.ui.services.WaoManager;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.zip.GZIPInputStream;
import org.apache.tapestry5.ComponentResources;
import org.apache.tapestry5.annotations.Log;
import org.apache.tapestry5.annotations.Parameter;
import org.apache.tapestry5.annotations.Property;
import org.apache.tapestry5.ioc.Messages;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.upload.services.UploadedFile;
import org.slf4j.Logger;

public class ImportFieldSet {
    protected static final String EVENT_IMPORTED = "imported";
    protected static final String MIMETYPE_GZIP = "application/x-gzip";
    protected static final String FORMAT_DEFAULT_VALUE = "CSV";
    @Parameter(required=true, defaultPrefix="literal")
    @Property
    private String label;
    @Parameter(required=true)
    private ImportEngine engine;
    @Parameter(value="CSV", defaultPrefix="literal")
    @Property
    private String format;
    @Inject
    private WaoManager manager;
    @Inject
    private ComponentResources resources;
    @Inject
    private Messages messages;
    @Inject
    private Logger logger;
    @Property
    private UploadedFile file;

    @Log
    void onSuccessFromImportForm() {
        ErrorReport errorReport = new ErrorReport();
        try {
            ImportResults result = this.engine.execute(this.getStream());
            if (result != null) {
                StringBuilder info = new StringBuilder().append(result.getNbRowsImported()).append(" lignes import\u00e9es");
                if (result.getNbRowsImportedNew() > 0) {
                    info.append(" dont ").append(result.getNbRowsImportedNew()).append(" nouvelles");
                }
                info.append(", ").append(result.getNbRowsRefused()).append(" refus\u00e9es.");
                errorReport.addInfo(info.toString());
                List errors = result.getErrors();
                errorReport.addError(errors.toArray(new String[errors.size()]));
            }
        }
        catch (WaoBusinessException eee) {
            errorReport.addError(new String[]{eee.getMessage()});
        }
        catch (WaoException eee) {
            String[] errors = this.manager.getErrorMessages(eee, this.messages, this.logger);
            errorReport.addError(errors);
        }
        catch (IOException eee) {
            errorReport.addError(new String[]{"Erreur de format du fichier ! Seul les formats [csv, gz, kml] sont autoris\u00e9s."});
            this.logger.error("Error on import file", (Throwable)eee);
        }
        this.resources.triggerEvent(EVENT_IMPORTED, new Object[]{errorReport}, null);
    }

    protected InputStream getStream() throws IOException {
        InputStream input = this.file.getStream();
        String contentType = this.file.getContentType();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Content type : " + this.file.getContentType());
        }
        if (contentType.equals(MIMETYPE_GZIP)) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Gzip file");
            }
            input = new GZIPInputStream(input);
        }
        return input;
    }
}

