/*
 * #%L
 * Wao :: Web Interface
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2011 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package fr.ifremer.wao.ui.components;

import fr.ifremer.wao.WaoException;
import fr.ifremer.wao.bean.BoatFilter;
import fr.ifremer.wao.bean.BoatFilterValues;
import fr.ifremer.wao.entity.SampleRow;
import fr.ifremer.wao.service.ServiceBoat;
import javassist.tools.reflect.Sample;
import org.apache.tapestry5.annotations.InjectComponent;
import org.apache.tapestry5.annotations.Parameter;
import org.apache.tapestry5.annotations.Persist;

import java.util.List;

/**
 * @author sletellier <letellier@codelutin.com>
 */
public class BoatFilterComponent extends FilterComponent<BoatFilter> {

    @InjectComponent
    private FeedBack filterFeedback;

    @Parameter(required = true)
    private ServiceBoat serviceBoat;

    /*
     * Datas
     */
    @Persist
    private BoatFilterValues possibleValuesForFilter;

    @Override
    protected boolean isAvailableDataForFiltersOnly() {
        return false;
    }

    @Override
    public void resetFilter() {
        setFilter(serviceBoat.newBoatFilter(getUser()));
    }

    @Override
    public void updateSearchFields() {
        updatePossibleValuesForFilter();
    }

    public BoatFilterValues getPossibleValuesForFilter() {
        return getPossibleValuesForFilter(false);
    }

    public BoatFilterValues updatePossibleValuesForFilter() {
        return getPossibleValuesForFilter(true);
    }

    protected BoatFilterValues getPossibleValuesForFilter(boolean update) {
        if (update || possibleValuesForFilter == null) {
            possibleValuesForFilter = serviceBoat.getPossibleValuesForFilter(getFilter());
        }
        return possibleValuesForFilter;
    }

    public String[] getShipOwnerNamesContains(String input) {
        List<String> results = serviceBoat.getShipOwnerNamesContains(input);
        return results.toArray(new String[results.size()]);
    }

    public String[] getBoatNamesStartWith(String input) {
        List<String> results = serviceBoat.getBoatNamesStartWith(input);
        return results.toArray(new String[results.size()]);
    }

    public SampleRow getSampleRow() {
        return getFilter().getSampleRow();
    }

    public void setSampleRow(SampleRow sampleRow) {
        getFilter().setSampleRow(sampleRow);
        getFilter().setSampleRowExists(sampleRow != null);
    }

    public String[] onProvideCompletionsFromShipOwnerName(String input) {
        return getShipOwnerNamesContains(input);
    }

    public String[] onProvideCompletionsFromBoatName(String input) throws WaoException {
        return getBoatNamesStartWith(input);
    }

    public boolean isSampleRowExists() {
        return getFilter().isSampleRowExists();
    }
}
