/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.wao.ui.components;

import fr.ifremer.wao.bean.SamplingFilter;
import fr.ifremer.wao.bean.SamplingFilterValues;
import fr.ifremer.wao.entity.SampleRow;
import fr.ifremer.wao.ui.base.FilterManager;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import org.apache.tapestry5.ComponentResources;
import org.apache.tapestry5.annotations.InjectComponent;
import org.apache.tapestry5.annotations.Parameter;
import org.apache.tapestry5.annotations.Persist;
import org.apache.tapestry5.annotations.Property;
import org.apache.tapestry5.corelib.components.Form;
import org.apache.tapestry5.corelib.components.Zone;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.nuiton.util.PeriodDates;
import org.slf4j.Logger;

public class SamplingFilterComponent {
    @Inject
    private Logger log;
    @Inject
    private ComponentResources resources;
    @InjectComponent
    private Form filtersForm;
    @Parameter(required=true)
    private FilterManager<? extends SamplingFilter> filterManager;
    @Parameter(required=true)
    private String legendMsg;
    @Parameter(required=false)
    private Boolean visibleOnStartup;
    @Parameter(required=false)
    private Boolean showEstimatedTides;
    @InjectComponent
    private Zone filtersZone;
    @Persist
    private Object owner;
    @Persist
    private Boolean filtersVisible;
    @Property
    private SampleRow row;
    private boolean reset;
    private boolean refresh;

    public String getLegendMsg() {
        return this.legendMsg;
    }

    public Boolean getShowEstimatedTides() {
        if (this.showEstimatedTides == null) {
            this.showEstimatedTides = false;
        }
        return this.showEstimatedTides;
    }

    public Boolean getVisibleOnStartup() {
        if (this.visibleOnStartup == null) {
            this.visibleOnStartup = true;
        }
        return this.visibleOnStartup;
    }

    public Boolean getFiltersVisible() {
        if (this.filtersVisible == null) {
            this.filtersVisible = this.getVisibleOnStartup();
        }
        return this.filtersVisible;
    }

    public void setFiltersVisible(Boolean filtersVisible) {
        this.filtersVisible = filtersVisible;
    }

    public void switchFiltersVisible() {
        this.filtersVisible = this.filtersVisible == false;
    }

    public Zone getFiltersZone() {
        return this.filtersZone;
    }

    public SamplingFilter getFilter() {
        return this.filterManager.getFilter();
    }

    public SamplingFilterValues getPossibleValuesForFilter() {
        return this.filterManager.getPossibleValuesForFilter();
    }

    public FilterManager getFilterManager() {
        return this.filterManager;
    }

    public void setFilterManager(FilterManager<? extends SamplingFilter> filterManager) {
        this.filterManager = filterManager;
    }

    public DateFormat getDateFormat() {
        return new SimpleDateFormat("MM/yyyy");
    }

    public void onSelectedFromReset() {
        this.reset = true;
    }

    public void onSelectedFromRefresh() {
        this.refresh = true;
    }

    Object onSuccessFromFiltersForm() {
        if (this.reset) {
            PeriodDates period = this.getFilter().getPeriod();
            this.getFilterManager().resetFilter();
            this.getFilter().setPeriod(period);
        }
        this.getFilterManager().updatePossibleValuesForFilter();
        if (this.refresh) {
            return this.filtersZone.getBody();
        }
        return this.resources.getContainer();
    }
}

