/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.wao.ui.pages;

import fr.ifremer.wao.WaoBusinessException;
import fr.ifremer.wao.WaoException;
import fr.ifremer.wao.bean.ConnectedUser;
import fr.ifremer.wao.bean.ContactFilter;
import fr.ifremer.wao.bean.ContactFilterImpl;
import fr.ifremer.wao.bean.ContactState;
import fr.ifremer.wao.bean.ObsProgram;
import fr.ifremer.wao.bean.SamplingFilter;
import fr.ifremer.wao.bean.UserRole;
import fr.ifremer.wao.bean.ValidationResult;
import fr.ifremer.wao.entity.Contact;
import fr.ifremer.wao.entity.ContactStateMotif;
import fr.ifremer.wao.entity.SampleRow;
import fr.ifremer.wao.entity.TerrestrialLocation;
import fr.ifremer.wao.entity.WaoUser;
import fr.ifremer.wao.io.ImportResults;
import fr.ifremer.wao.service.ServiceContact;
import fr.ifremer.wao.service.ServiceReferential;
import fr.ifremer.wao.service.ServiceUser;
import fr.ifremer.wao.ui.base.AbstractFilteredPage;
import fr.ifremer.wao.ui.components.Layout;
import fr.ifremer.wao.ui.data.ContactDataSource;
import fr.ifremer.wao.ui.data.GenericSelectModel;
import fr.ifremer.wao.ui.data.RequiresAuthentication;
import fr.ifremer.wao.ui.pages.Contacts;
import fr.ifremer.wao.ui.services.ContactModelFactory;
import fr.ifremer.wao.ui.services.WaoManager;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.List;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.tapestry5.ComponentResources;
import org.apache.tapestry5.SelectModel;
import org.apache.tapestry5.StreamResponse;
import org.apache.tapestry5.annotations.Environmental;
import org.apache.tapestry5.annotations.Import;
import org.apache.tapestry5.annotations.InjectComponent;
import org.apache.tapestry5.annotations.Log;
import org.apache.tapestry5.annotations.Persist;
import org.apache.tapestry5.annotations.Property;
import org.apache.tapestry5.annotations.SessionState;
import org.apache.tapestry5.beaneditor.BeanModel;
import org.apache.tapestry5.corelib.components.Zone;
import org.apache.tapestry5.ioc.Messages;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.ioc.services.PropertyAccess;
import org.apache.tapestry5.services.BeanModelSource;
import org.apache.tapestry5.services.javascript.JavaScriptSupport;
import org.apache.tapestry5.upload.services.UploadedFile;
import org.apache.tapestry5.util.EnumSelectModel;
import org.slf4j.Logger;

@RequiresAuthentication(allowedRoles={UserRole.ADMIN, UserRole.COORDINATOR, UserRole.OBSERVER})
@Import(stylesheet={"context:css/contacts.css"})
public class Contacts
extends AbstractFilteredPage {
    @Inject
    private Logger logger;
    @InjectComponent
    private Layout layout;
    @SessionState
    @Property
    private ConnectedUser user;
    @Inject
    private ServiceContact serviceContact;
    @Environmental
    private JavaScriptSupport javascriptSupport;
    @Inject
    private WaoManager manager;
    @Inject
    private Messages messages;
    @Persist
    private ContactFilter contactFilter;
    @InjectComponent
    private Zone filtersZone;
    @InjectComponent
    private Zone importExportZone;
    private boolean reset;
    @Property
    private ContactState stateFilter;
    @Inject
    private ServiceReferential serviceReferential;
    @Property
    @Persist
    private String terrestrialLocationId;
    private GenericSelectModel<TerrestrialLocation> terrestrialLocationSelectModel;
    @Property
    @Persist
    private String contactStateMotifId;
    private GenericSelectModel<ContactStateMotif> contactStateMotifSelectModel;
    @Property
    private UploadedFile contactsCsvFile;
    @Persist
    @Property
    private Boolean fullView;
    @Inject
    private ServiceUser serviceUser;
    @Inject
    private BeanModelSource beanModelSource;
    @Inject
    private ComponentResources resources;
    @Persist
    private ContactDataSource contacts;
    @Property
    private Contact contact;
    private BeanModel<Contact> contactModel;
    @Inject
    private PropertyAccess propertyAccess;
    private GenericSelectModel<WaoUser> userSelectModel;
    @Persist
    private String contactSelectedId;
    @Property
    @Persist
    private String contactUserId;
    private boolean even = true;
    private Contact modifiedContact;

    public String getLabelForEnum(Enum value) {
        return this.messages.get(value.getDeclaringClass().getSimpleName() + "." + value.name());
    }

    @Log
    void setupRender() throws WaoException {
        this.contacts = null;
        if (this.isFiltersVisible()) {
            this.initSelectFilters(true, true, true);
        }
        if (this.fullView == null) {
            this.fullView = this.user.isAdmin();
        }
    }

    @Log
    void afterRender() {
        this.contactSelectedId = null;
    }

    public ContactFilter getContactFilter() throws WaoException {
        if (this.contactFilter == null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Init contactFilter");
            }
            this.contactFilter = new ContactFilterImpl();
            GregorianCalendar initialFromDate = new GregorianCalendar();
            if (initialFromDate.get(2) < 3) {
                initialFromDate.add(2, -6);
            } else {
                initialFromDate.set(6, 1);
            }
            this.contactFilter.setFromDate(initialFromDate.getTime());
            this.contactFilter.setObsProgram(this.user.getProfile().getObsProgram());
            this.contactFilter.setEstimatedTides(true);
        }
        return this.contactFilter;
    }

    public boolean isFiltersVisible() {
        boolean companyFiltered = this.getContactFilter().getCompany() != null && this.user.isAdmin();
        return (this.getContactFilter().isFiltered() || companyFiltered) && StringUtils.isEmpty((String)this.getContactFilter().getBoatName());
    }

    protected SamplingFilter getFilter() throws WaoException {
        return this.getContactFilter();
    }

    protected boolean isAvailableDataForFiltersOnly() {
        return false;
    }

    protected void resetFilter() {
        this.contactFilter = null;
    }

    Object onActionFromShowFilters() {
        this.initSelectFilters(true, true, true);
        return this.filtersZone.getBody();
    }

    Object onActionFromShowImportExport() {
        return this.importExportZone.getBody();
    }

    void onSelectedFromReset() {
        this.reset = true;
    }

    @Log
    Object onSuccessFromFiltersForm() throws WaoException {
        if (StringUtils.isNotEmpty((String)this.contactStateMotifId)) {
            this.getContactFilter().setContactStateMotif((ContactStateMotif)this.getContactStateMotifSelectModel().findObject(this.contactStateMotifId));
        }
        if (this.isEdited()) {
            return this.filtersZone.getBody();
        }
        if (this.reset) {
            this.contactFilter = null;
        }
        return this;
    }

    public void onChangeFromSampleRow(String sampleRowId) {
        this.getFilter().setSampleRow((SampleRow)this.getSampleRowSelectModel().findObject(sampleRowId));
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("change sample row code in filter to " + this.getFilter().getSampleRow());
        }
    }

    public Zone onValueChangedTerrestrialDistrict(String terrestrialDistrictId) {
        this.updateLocation(terrestrialDistrictId);
        return this.filtersZone;
    }

    public GenericSelectModel<TerrestrialLocation> getTerrestrialLocationSelectModel() {
        ArrayList locations = new ArrayList();
        if (this.getFilter().getTerrestrialDistrict() != null) {
            this.serviceReferential.getAllTerrestrialLocations(this.getContactFilter(), this.getFilter().getTerrestrialDistrict().getDistrictCode());
        }
        this.terrestrialLocationSelectModel = new GenericSelectModel(locations, TerrestrialLocation.class, "description", "topiaId", this.propertyAccess);
        return this.terrestrialLocationSelectModel;
    }

    public SelectModel getContactStateSelectModel() {
        List allowedStates = ContactState.getAllowedStates((ObsProgram)this.user.getProfile().getObsProgram());
        return new EnumSelectModel(ContactState.class, this.messages, (Enum[])allowedStates.toArray(new ContactState[allowedStates.size()]));
    }

    public GenericSelectModel<ContactStateMotif> getContactStateMotifSelectModel() {
        List motifs;
        if (this.contactStateMotifSelectModel == null && this.contactFilter.getState() != null && (motifs = this.serviceReferential.getAllContactStateMotifs(this.contactFilter.getState())).size() != 0) {
            this.contactStateMotifSelectModel = new GenericSelectModel(motifs, ContactStateMotif.class, "translation", "topiaId", this.propertyAccess);
        }
        return this.contactStateMotifSelectModel;
    }

    public Zone onValueChangedFromState(ContactState contactState) {
        this.contactFilter.setState(contactState);
        this.contactStateMotifSelectModel = null;
        this.contactStateMotifId = null;
        return this.filtersZone;
    }

    public boolean canImportExport() {
        return (this.user.isAdmin() || this.user.isCoordinator()) && !this.user.isReadOnly();
    }

    @Log
    void onSuccessFromImportContacts() throws WaoException {
        if (this.canImportExport()) {
            try {
                ImportResults result = this.serviceContact.importContactCsv(this.user, this.contactsCsvFile.getStream());
                this.contacts = null;
                this.layout.addInfo(result.getNbRowsImported() + " contacts " + "import\u00e9s,  " + result.getNbRowsRefused() + " refus\u00e9s.");
                for (String error : result.getErrors()) {
                    this.layout.addInfo(error);
                }
            }
            catch (WaoBusinessException eee) {
                this.layout.addError(new String[]{eee.getMessage()});
            }
        }
    }

    StreamResponse onActionFromExportShowContacts() {
        if (this.canImportExport()) {
            return new /* Unavailable Anonymous Inner Class!! */;
        }
        return null;
    }

    void onActionFromToggleDisplayMode() {
        this.fullView = this.fullView == false;
    }

    public void setContactSelectedId(String contactSelectedId) {
        this.contactSelectedId = contactSelectedId;
    }

    public ContactDataSource getContacts() throws WaoException {
        if (this.contacts == null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Create DataSource");
            }
            this.contacts = new ContactDataSource(this.getContactFilter(), this.serviceContact);
        }
        return this.contacts;
    }

    public BeanModel<Contact> getContactModel() {
        if (this.contactModel == null) {
            ContactModelFactory contactModelFactory = new ContactModelFactory(this.user.getProfile().getObsProgram(), this.user.getProfile().getUserRole(), this.fullView.booleanValue());
            this.contactModel = contactModelFactory.newModel(this.beanModelSource, this.resources);
        }
        return this.contactModel;
    }

    public GenericSelectModel<WaoUser> getUserSelectModel() {
        if (this.userSelectModel == null) {
            List users = this.serviceUser.getObservers(this.user.getCompany(), true);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Nb users : " + users.size());
            }
            this.userSelectModel = new GenericSelectModel(users, WaoUser.class, "fullName", "id", this.propertyAccess);
        }
        return this.userSelectModel;
    }

    public String getCommentDisplayText(String comment) {
        if (comment != null && comment.length() > 20) {
            return comment.substring(0, 20) + "...";
        }
        return comment;
    }

    public String getCommentTooltip(String comment) {
        return this.manager.getTooltipText(comment);
    }

    public String getSampleRowDescription() {
        return this.manager.getTooltipSampleRow(this.contact.getSampleRow());
    }

    public String getBoatDescription() {
        return this.manager.getTooltipBoat(this.contact.getBoat());
    }

    public String getSecondaryObservers() {
        StringBuilder result = new StringBuilder();
        result.append(this.contact.getMainObserver().getFullName());
        for (WaoUser observer : this.contact.getSecondaryObservers()) {
            result.append(", ");
            result.append(observer.getFullName());
        }
        return result.toString();
    }

    public String getTooltipExportFrom() throws WaoException {
        if (this.getContactFilter().getFromDate() != null) {
            return "depuis le " + this.getDateFormat().format(this.getContactFilter().getFromDate());
        }
        return "";
    }

    public String getGridClass() {
        return this.fullView != false ? "admin" : "user";
    }

    public String getRowClass() {
        String result = this.manager.getContactStyle(this.contact, this.user.isAdmin());
        if (this.contact.getTopiaId().equals(this.contactSelectedId)) {
            result = "selected";
        }
        return result;
    }

    public DateFormat getDateFormat() {
        return new SimpleDateFormat("dd/MM/yyyy");
    }

    public DateFormat getDateTimeFormat() {
        return new SimpleDateFormat("dd/MM/yyyy HH:mm");
    }

    public boolean isEmpty(Boolean validation) {
        return validation == null;
    }

    public boolean isBoardingDone() {
        return this.contact.getContactState() == ContactState.OBSERVATION_DONE;
    }

    public boolean hasActions() {
        return !this.user.isAdmin() && this.contact.getValidationCompany() == null && !this.user.isReadOnly();
    }

    public boolean hasValidationActions() {
        return (this.user.isAdmin() || this.user.isCoordinator()) && !this.user.isReadOnly();
    }

    public boolean canEditSampleRow() {
        boolean canEdit = this.user.getProfile().isCanWrite() != false && (this.user.isAdminAndCanWrite() && this.contact.getValidationProgram() == null || this.user.isCoordinatorOrObserver() && this.contact.getValidationCompany() == null);
        return canEdit;
    }

    public boolean canDeleteSampleRow() {
        boolean noValidation = this.contact.getValidationProgram() == null && this.contact.getValidationCompany() == null;
        return noValidation && this.user.getProfile().isCanWrite() != false;
    }

    public boolean canValidate() {
        switch (2.$SwitchMap$fr$ifremer$wao$bean$UserRole[this.user.getRole().ordinal()]) {
            case 1: {
                return this.contact.getValidationProgram() == null && BooleanUtils.isTrue((Boolean)this.contact.getValidationCompany());
            }
            case 2: {
                ContactState state = this.contact.getContactState();
                boolean boardingDone = state.equals((Object)ContactState.OBSERVATION_DONE) && this.contact.getDataInputDate() != null;
                return this.contact.getValidationCompany() == null && (state.isUnfinishedState() || boardingDone);
            }
        }
        return false;
    }

    public boolean canUnvalidate() {
        switch (2.$SwitchMap$fr$ifremer$wao$bean$UserRole[this.user.getRole().ordinal()]) {
            case 1: {
                return this.contact.getValidationProgram() != null;
            }
            case 2: {
                return this.contact.getValidationCompany() != null && this.contact.getValidationProgram() == null;
            }
        }
        return false;
    }

    @Log
    void onActionFromAcceptContact(String contactId) throws WaoException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Accept contact : " + contactId);
        }
        this.contactSelectedId = contactId;
        this.modifiedContact = (Contact)this.getContacts().get((Object)contactId);
        if (this.user.isAdmin()) {
            this.modifiedContact.setValidationProgram(Boolean.TRUE);
        } else {
            this.modifiedContact.setValidationCompany(Boolean.TRUE);
        }
        this.saveContact(this.modifiedContact);
    }

    @Log
    void onActionFromUnvalidateContact(String contactId) throws WaoException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Unvalidate contact : " + contactId);
        }
        this.contactSelectedId = contactId;
        this.modifiedContact = (Contact)this.getContacts().get((Object)contactId);
        if (this.user.isAdmin()) {
            this.modifiedContact.setValidationProgram(null);
        } else {
            this.modifiedContact.setValidationCompany(null);
        }
        this.saveContact(this.modifiedContact);
    }

    @Log
    void onActionFromRefuseContact(String contactId) throws WaoException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Refuse contact : " + contactId);
        }
        this.contactSelectedId = contactId;
        this.modifiedContact = (Contact)this.getContacts().get((Object)contactId);
        if (this.user.isAdmin()) {
            this.modifiedContact.setValidationProgram(Boolean.FALSE);
        } else {
            this.modifiedContact.setValidationCompany(Boolean.FALSE);
        }
        this.saveContact(this.modifiedContact);
    }

    protected void saveContact(Contact contact) {
        ValidationResult validationResult = this.serviceContact.validateContact(contact);
        if (validationResult.isSuccess()) {
            this.serviceContact.saveContact(this.user, contact, false);
        } else {
            this.layout.addError(new String[]{validationResult.getMessage()});
        }
    }

    @Log
    void onActionFromDeleteContact(String contactId) throws WaoException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Delete contact : " + contactId);
        }
        this.contactSelectedId = contactId;
        this.modifiedContact = (Contact)this.getContacts().get((Object)contactId);
        this.serviceContact.saveContact(this.user, this.modifiedContact, true);
    }

    static /* synthetic */ ServiceContact access$000(Contacts x0) {
        return x0.serviceContact;
    }
}

