/*
 * #%L
 * Wao :: Web Interface
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2011 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package fr.ifremer.wao.ui.components;

import fr.ifremer.wao.WaoDAOHelper;
import org.apache.tapestry5.BindingConstants;
import org.apache.tapestry5.OptionGroupModel;
import org.apache.tapestry5.OptionModel;
import org.apache.tapestry5.ValueEncoder;
import org.apache.tapestry5.annotations.InjectComponent;
import org.apache.tapestry5.annotations.Parameter;
import org.apache.tapestry5.annotations.Persist;
import org.apache.tapestry5.corelib.components.Select;
import org.apache.tapestry5.internal.OptionModelImpl;
import org.apache.tapestry5.internal.SelectModelImpl;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.ioc.services.PropertyAccess;
import org.apache.tapestry5.ioc.services.PropertyAdapter;
import org.apache.tapestry5.util.AbstractSelectModel;
import org.chenillekit.tapestry.core.components.MultipleSelect;
import org.chenillekit.tapestry.core.models.GenericMultipleSelectModel;
import org.nuiton.topia.persistence.TopiaEntity;
import org.slf4j.Logger;

import java.util.ArrayList;
import java.util.List;

/**
 * Component to select one or many topiaEntity
 *
 * @author sletellier <letellier@codelutin.com>
 */
public class TopiaEntitySelector<E extends TopiaEntity> {

    @Inject
    private Logger log;

    @Inject
    private PropertyAccess propertyAccess;

    @Parameter(required = false, defaultPrefix = BindingConstants.LITERAL)
    private String clazzName;

    @Parameter(required = true, defaultPrefix = BindingConstants.LITERAL)
    private String labelPropertyName;

    @Parameter(required = true)
    private List<E> values;

    @Parameter(required = false)
    private Boolean multiple;

    @Parameter(required = false)
    private E selectedValue;

    @Parameter(required = false)
    private List<E> selectedValues;

    @Parameter(required = false)
    private Integer size;

    @Parameter(required = false)
    private TopiaEntitySelectorModel model;

    @Parameter(required = false)
    private MultipleTopiaEntitySelectorModel multipleModel;

    @Persist
    private Class<E> clazz;

    public TopiaEntitySelectorModel getModel() {
        if (model == null) {
            model = new TopiaEntitySelectorModel();
        }
        return model;
    }

    public MultipleTopiaEntitySelectorModel getMultipleModel() {
        if (multipleModel == null) {
            multipleModel = new MultipleTopiaEntitySelectorModel();
        }
        return multipleModel;
    }

    public void setModel(TopiaEntitySelectorModel model) {
        this.model = model;
    }

    public void setMultipleModel(MultipleTopiaEntitySelectorModel multipleModel) {
        this.multipleModel = multipleModel;
    }

    public Class<E> getClazz() {
        if (clazz == null) {
            if (clazzName ==null) {
                throw new IllegalArgumentException("Clazz or ClazzName must be non null");
            }
            WaoDAOHelper.WaoEntityEnum waoEntityEnum = WaoDAOHelper.WaoEntityEnum.valueOf(getClazzName());
            clazz = (Class<E>)waoEntityEnum.getContract();
            if (clazz == null) {
                throw new IllegalArgumentException("Clazz with name " + clazzName  + " is not found");
            }
        }
        return clazz;
    }

    public void setClazz(Class<E> clazz) {
        this.clazz = clazz;
    }

    public String getClazzName() {
        return clazzName;
    }

    public void setClazz(String clazzName) {
        this.clazzName = clazzName;
    }

    public E getSelectedValue() {
        return selectedValue;
    }

    public void setSelectedValue(E selectedValue) {
        this.selectedValue = selectedValue;
    }

    public List<E> getSelectedValues() {
        return selectedValues;
    }

    public void setSelectedValues(List<E> selectedValues) {
        this.selectedValues = selectedValues;
    }

    public List<E> getValues() {
        return values;
    }

    public void setValues(List<E> values) {
        this.values = values;
    }

    public Integer getSize() {
        if (size == null) {
            size = getValues().size();
        }
        return size;
    }

    public void setSize(Integer size) {
        this.size = size;
    }

    public String getLabelPropertyName() {
        return labelPropertyName;
    }

    public void setLabelPropertyName(String labelPropertyName) {
        this.labelPropertyName = labelPropertyName;
    }

    public boolean getMultiple() {
        if (multiple == null) {
            multiple = false;
        }
        return multiple;
    }

    public void setMultiple(Boolean multiple) {
        this.multiple = multiple;
    }

    /**
     * Model used by {@link fr.ifremer.wao.ui.components.TopiaEntitySelector}
     *
     * @author sletellier <letellier@codelutin.com>
     */
    public class MultipleTopiaEntitySelectorModel extends GenericMultipleSelectModel<E> {

        public MultipleTopiaEntitySelectorModel() {
            super(getValues(), getClazz(), getLabelPropertyName(), TopiaEntity.TOPIA_ID, propertyAccess);
        }
    }

    /**
     * Model used by {@link fr.ifremer.wao.ui.components.TopiaEntitySelector}
     *
     * @author sletellier <letellier@codelutin.com>
     */
    public class TopiaEntitySelectorModel extends AbstractSelectModel implements ValueEncoder<E> {

        protected SelectModelImpl delegate;

        public TopiaEntitySelectorModel() {
            delegate = new SelectModelImpl(null, getOptionModels(getValues()));
        }

        @Override
        public List<OptionGroupModel> getOptionGroups() {
            return delegate.getOptionGroups();
        }

        @Override
        public List<OptionModel> getOptions() {
            return delegate.getOptions();
        }

        @Override
        public String toClient(E value) {
            return value.getTopiaId();
        }

        @Override
        public E toValue(String clientValue) {
            for (E value : getValues()) {
                if (clientValue.equals(value.getTopiaId())) {
                    return value;
                }
            }
            return null;
        }

        protected List<OptionModel> getOptionModels(List<E> entities) {
            List<OptionModel> options = new ArrayList<OptionModel>();
            for (E entity : entities) {
                if (entity != null) {
                    PropertyAdapter propertyAdapter = propertyAccess.getAdapter(getClazz()).getPropertyAdapter(getLabelPropertyName());
                    if (propertyAdapter == null) {
                        log.error("PropertyAdapter not found for clazz[" + getClazz() + "] labelPropertyName[" + getLabelPropertyName() + "]");
                    } else {
                        String toRender = (String)propertyAdapter.get(entity);
                        options.add(new OptionModelImpl(toRender, entity));
                    }
                }
            }
            return options;
        }
    }
}
