/*
 * #%L
 * Wao :: Web Interface
 * 
 * $Id: WaoPropertyChangeListener.java 734 2010-11-03 16:51:31Z bleny $
 * $HeadURL: svn+ssh://bleny@labs.libre-entreprise.org/svnroot/suiviobsmer/tags/wao-2.0/wao-ui/src/main/java/fr/ifremer/wao/ui/data/WaoPropertyChangeListener.java $
 * %%
 * Copyright (C) 2009 - 2010 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

package fr.ifremer.wao.ui.data;

import org.nuiton.topia.persistence.TopiaEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Map;

/**
 * BoatInfosPropertyChangeListener
 *
 * Created: 18 nov. 2009
 *
 * @author fdesbois <fdesbois@codelutin.com>
 */
public class WaoPropertyChangeListener implements PropertyChangeListener {

    private static final Logger log = LoggerFactory.getLogger(WaoPropertyChangeListener.class);

    //private boolean changed;

    private Map<String, Object> data;

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (log.isDebugEnabled()) {
            log.debug("property change : old = " + evt.getOldValue() +
                    " _ new = " + evt.getNewValue());
        }
        TopiaEntity entity = (TopiaEntity)evt.getSource();
        getData().put(entity.getTopiaId(), entity);
    }

    protected Map<String, Object> getData() {
        if (data == null) {
            data = new HashMap<String, Object>();
        }
        return data;
    }

    public boolean hasChanged(String topiaId) {

        if (log.isTraceEnabled()) {
            log.trace("data size : " + getData().size());
        }

        return getData().containsKey(topiaId);
    }

    public void reset() {
        data = null;
    }

}
