/*
 * #%L
 * Wao :: Web Interface
 * %%
 * Copyright (C) 2009 - 2010 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package fr.ifremer.wao.ui.pages;

import fr.ifremer.wao.WaoException;
import fr.ifremer.wao.bean.ConnectedUser;
import fr.ifremer.wao.bean.UserRole;
import fr.ifremer.wao.entity.Company;
import fr.ifremer.wao.service.ServiceCartography;
import fr.ifremer.wao.service.ServiceUser;
import fr.ifremer.wao.ui.data.GenericSelectModel;
import fr.ifremer.wao.ui.data.RequiresAuthentication;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.tapestry5.Link;
import org.apache.tapestry5.annotations.Persist;
import org.apache.tapestry5.annotations.Property;
import org.apache.tapestry5.annotations.SessionState;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.ioc.services.PropertyAccess;
import org.apache.tapestry5.services.PageRenderLinkSource;
import org.slf4j.Logger;

import java.io.IOException;
import java.util.List;

/**
 * Created: 6 juil. 2010
 *
 * @author fdesbois <fdesbois@codelutin.com>
 * @version $Id: Cartography.java 610 2010-07-11 19:10:28Z fdesbois $
 */
@RequiresAuthentication({UserRole.ADMIN, UserRole.COORDINATOR, UserRole.OBSERVER})
public class Cartography {

    @SessionState
    @Property
    private ConnectedUser user;

    @Inject
    private Logger logger;

    @Inject
    private PageRenderLinkSource pageRender;

    @Inject
    private PropertyAccess propertyAccess;

    @Inject
    private ServiceUser serviceUser;

    @Persist
    private GenericSelectModel<Company> companySelectModel;

    @Property
    private String companyId;

    @Persist
    private Company company;

    private String url;

    void setupRender() {

        if (logger.isDebugEnabled()) {
            String companyName = getCompany() != null ? getCompany().getName() : null;
            logger.debug("Company selected : " + companyName);
        }

        if (getCompany() != null) {
            companyId = getCompany().getTopiaId();
        }
    }

    public Company getCompany() {
        if (company == null && !user.isAdmin() && !user.isGuest()) {
            company = user.getCompany();
        }
        return company;
    }

    public GenericSelectModel<Company> getCompanySelectModel() throws WaoException {
        if (companySelectModel == null) {
            List<Company> companies = serviceUser.getCompanies(true);
            companySelectModel = new GenericSelectModel<Company>(
                    companies,
                    Company.class,
                    Company.NAME,
                    Company.TOPIA_ID,
                    propertyAccess
            );
        }
        return companySelectModel;
    }

    public String getUrl() throws IOException {
        if (url == null) {
            Link link = pageRender.createPageRenderLinkWithContext(
                                        KmlLoader.class,
                                        KmlLoader.StrategyValues.CONTACTS,
                                        companyId
            );
            url = link.toURI();
        }
        return url;
    }

    public String getTitle() {
        return "Contacts";
    }

    public String getPageTitle() {
        String title =  "Répartition des contacts par quartier des navires";
        if (company != null) {
            title += " pour la société " + company.getName();
        }
        return title;
    }

    void onSuccessFromFilters() {
        if (!user.isAdmin()) {
            throw new WaoException("Vous n'avez pas les droits nécessaires" +
                    " pour filtrer sur une société", null);
        }

        company = companySelectModel.findObject(companyId);
    }
}

