/*
 * #%L
 * Wao :: Web Interface
 * %%
 * Copyright (C) 2009 - 2010 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
/**
 * This class is used to manage comment window for contacts. Two possible cases :
 * - comment from current edition
 * - direct comment for coordinator or admin
 * The differences are in saveComment method. The openWindow method is used
 * in template using a JSONObject from Java that contains comment data.
 */
ContactComment = Class.create({
    initialize: function() {
        this.commentForm = $('commentForm');
        this.contactForm = $('contactsForm');

        this.image = $('commentImage');
        this.invalidImage = $('commentInvalidImage');
        this.validImage = $('commentValidImage');

        this.window = commentWindow;
    },
    /**
     * Open the commentWindow ::
     * Use JSON to initialize data from template :
     * - contact.edited : if a contact is currently in edition
     * - contact.comment : comment value to initialize
     * - contact.unfinished : if contact is in unfinished state
     * - contact.id : id of the contact (used to save directly the comment)
     */
    openWindow: function(contact) {
        this.editionMode = contact.edited;
        this.oldComment = contact.comment;
        this.contactUnfinished = contact.unfinished;

        this.commentForm.editComment.setValue(this.oldComment);
        this.commentForm.hiddenContactId.setValue(contact.id);

        this.window.showCenter(true);
    },
    /**
     * Save the comment ::
     * If form is in edition, the comment will be push in existing input 'comment'
     * otherwise the commentForm will be submitted to save the comment
     */
    saveComment: function() {

        if (!this.editionMode) {
            // Execute commentForm to save directly the comment
            this.commentForm.submit();
        } else {
            // Refresh edition form with comment
            this.newComment = $F(this.commentForm.editComment);
            this.refreshCommentImage();
            this.contactForm.comment.setValue(this.newComment);
        }

        this.window.close();
    },
    /**
     * Refresh the comment image (only in edition mode) ::
     * Depends on contactUnfinished value to know if errors can occurs on comment
     */
    refreshCommentImage: function() {
        if (this.contactUnfinished && (!this.newComment || this.oldComment == this.newComment)) {
            this.showImage(this.invalidImage);
            this.hideImage(this.validImage);
            this.hideImage(this.image);
        } else if (this.oldComment != this.newComment) {
            this.showImage(this.validImage);
            this.hideImage(this.invalidImage);
            this.hideImage(this.image);
        } else {
            this.showImage(this.image);
            this.hideImage(this.validImage);
            this.hideImage(this.invalidImage);
        }
    },
    showImage: function(image) {
        if (image.hasClassName('hidden')) {
            image.removeClassName('hidden');
        }
    },
    hideImage: function(image) {
        if (!image.hasClassName('hidden')) {
            image.addClassName('hidden');
        }
    }
});

ContactSendEmail = Class.create({
    initialize: function(message, contactState) {
        this.contactForm = $('contactsForm');
        this.contactState = contactState;
        this.message = message;
        this.contactForm.saveContact.observe('click', this.doConfirm.bind(this));
    },
    doConfirm: function(event) {
        if ($F(this.contactForm.contactState) == this.contactState && confirm(this.message)) {
            this.contactForm.hiddenSendEmail.setValue(true);
        }
    }
});