/*
 * #%L
 * Wao :: Web Interface
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2010 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package fr.ifremer.wao.ui.data;

import java.util.ArrayList;
import java.util.List;

/**
 * Created: 18 juin 2010
 *
 * @author fdesbois <fdesbois@codelutin.com>
 * @version $Id$
 */
public class ErrorReport {

    protected List<String> infos;

    protected List<String> errors;

    public void addInfo(String info) {
        getInfos().add(info);
    }

    public void addError(String... errors) {
        for (String error : errors) {
            getErrors().add(error);
        }
    }

    public List<String> getInfos() {
        if (infos == null) {
            infos = new ArrayList<String>();
        }
        return infos;
    }

    public List<String> getErrors() {
        if (errors == null) {
            errors = new ArrayList<String>();
        }
        return errors;
    }
}
