/*
 * Decompiled with CFR 0.152.
 */
package winstone;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.servlet.ServletInputStream;
import winstone.Launcher;
import winstone.Logger;

public class WinstoneInputStream
extends ServletInputStream {
    final int BUFFER_SIZE = 4096;
    private InputStream inData;
    private Integer contentLength;
    private int readSoFar;

    public WinstoneInputStream(InputStream inData) {
        this.inData = inData;
    }

    public WinstoneInputStream(byte[] inData) {
        this(new ByteArrayInputStream(inData));
    }

    public InputStream getRawInputStream() {
        return this.inData;
    }

    public void setContentLength(int length) {
        this.contentLength = new Integer(length);
        this.readSoFar = 0;
    }

    public int read() throws IOException {
        if (this.contentLength == null) {
            int data = this.inData.read();
            return data;
        }
        if (this.contentLength > this.readSoFar) {
            ++this.readSoFar;
            int data = this.inData.read();
            return data;
        }
        return -1;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if (this.contentLength == null) {
            return this.inData.read(b, off, len);
        }
        if ((len = Math.min(len, this.contentLength - this.readSoFar)) <= 0) {
            return -1;
        }
        int r = this.inData.read(b, off, len);
        if (r < 0) {
            return r;
        }
        this.readSoFar += r;
        return r;
    }

    public int readAsMuchAsPossible(byte[] buf, int offset, int len) throws IOException {
        int total;
        int count;
        for (total = 0; total < len && (count = this.read(buf, offset + total, len - total)) >= 0; total += count) {
        }
        return total;
    }

    public void finishRequest() {
    }

    public int available() throws IOException {
        return this.inData.available();
    }

    public byte[] readLine() throws IOException {
        byte[] buffer = new byte[4096];
        int charsRead = super.readLine(buffer, 0, 4096);
        if (charsRead == -1) {
            Logger.log(Logger.DEBUG, Launcher.RESOURCES, "WinstoneInputStream.EndOfStream");
            return new byte[0];
        }
        byte[] outBuf = new byte[charsRead];
        System.arraycopy(buffer, 0, outBuf, 0, charsRead);
        return outBuf;
    }
}

