/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.wao.ui.components;

import fr.ifremer.wao.WaoBusinessException;
import fr.ifremer.wao.WaoException;
import fr.ifremer.wao.WaoProperty;
import fr.ifremer.wao.entity.WaoUser;
import fr.ifremer.wao.service.ServiceUser;
import fr.ifremer.wao.ui.base.WaoPage;
import fr.ifremer.wao.ui.components.FeedBack;
import fr.ifremer.wao.ui.pages.Index;
import fr.ifremer.wao.ui.services.WaoManager;
import org.apache.commons.lang.StringUtils;
import org.apache.tapestry5.annotations.InjectComponent;
import org.apache.tapestry5.annotations.InjectContainer;
import org.apache.tapestry5.annotations.Log;
import org.apache.tapestry5.annotations.Parameter;
import org.apache.tapestry5.annotations.Persist;
import org.apache.tapestry5.annotations.Property;
import org.apache.tapestry5.annotations.SessionState;
import org.apache.tapestry5.ioc.Messages;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.services.Request;
import org.slf4j.Logger;

public class Layout {
    @Inject
    private WaoManager manager;
    @Parameter(required=true, defaultPrefix="literal")
    private String pageTitle;
    @Parameter(required=true, defaultPrefix="literal")
    private String contentId;
    @SessionState
    private WaoUser currentUser;
    @InjectComponent
    private FeedBack connexionFeedback;
    @InjectComponent
    private FeedBack contentFeedback;
    @InjectContainer
    private WaoPage page;
    @Inject
    private ServiceUser serviceUser;
    @Inject
    private Request request;
    @Inject
    private Logger logger;
    @Inject
    private Messages messages;
    private boolean fatal = false;
    @Property
    private String login;
    @Property
    private String password;
    @Persist(value="flash")
    @Property
    private String email;

    void setupRender() {
        if (this.isCurrentUserExists() && !this.canShowPage()) {
            this.contentFeedback.addError(new String[]{"Vous n'\u00eates pas autoris\u00e9 \u00e0 acc\u00e9der \u00e0 cette page !"});
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Initialize page from Layout");
            this.logger.debug("currentUserExists : " + this.isCurrentUserExists());
        }
        this.page.initialize();
    }

    boolean afterRender() {
        if (this.fatal && this.contentFeedback.hasErrors() && !this.contentFeedback.hasBeeanReloaded()) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info("[ FATAL ] Reload the page to display errors");
            }
            this.contentFeedback.reload();
            return false;
        }
        this.contentFeedback.clearErrors();
        this.fatal = false;
        return true;
    }

    public boolean isDevEnvironment() {
        return this.manager.isDevEnvironment();
    }

    public boolean isCurrentUserExists() {
        return StringUtils.isNotEmpty((String)this.currentUser.getTopiaId());
    }

    public String getContextPath() {
        return this.request.getContextPath();
    }

    public String getVersion() {
        return WaoProperty.APP_VERSION.getValue();
    }

    public String getPageTitle() {
        return this.pageTitle;
    }

    public String getContentId() {
        return this.contentId;
    }

    public void setCurrentUser(WaoUser user) {
        this.currentUser = user;
    }

    public WaoUser getCurrentUser() {
        return this.currentUser;
    }

    public FeedBack getFeedBack() {
        return this.contentFeedback;
    }

    public String getAdminClass() {
        return this.currentUser.isAdmin() ? " admin" : "";
    }

    public String getSamplingSelected() {
        return this.contentId.equals("so-sampling") ? "selected" : "";
    }

    public String getBoatsSelected() {
        return this.contentId.equals("so-boats") ? "selected" : "";
    }

    public String getContactsSelected() {
        return this.contentId.equals("so-contacts") ? "selected" : "";
    }

    public String getSynthesisSelected() {
        return this.contentId.equals("so-synthesis") ? "selected" : "";
    }

    public String getAdminSelected() {
        return this.contentId.equals("so-admin") ? "selected" : "";
    }

    public boolean canShowPage() {
        return this.page.canDisplay();
    }

    public String getAccessText() {
        String text = this.currentUser.getUserRole().getLibelle();
        if (this.currentUser.getReadOnly()) {
            text = text + " lecture seule";
        }
        return text;
    }

    public boolean displayBody() {
        return this.canShowPage() && !this.fatal;
    }

    public void addInfo(String message) {
        this.contentFeedback.addInfo(message);
    }

    public void addError(String ... message) {
        this.contentFeedback.addError(message);
    }

    public void addFatal(String message) {
        this.contentFeedback.addError(new String[]{message});
        this.fatal = true;
    }

    @Log
    Object onSuccessFromConnexionForm() throws WaoException {
        block8: {
            try {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Login : " + this.login);
                }
                if (this.login != null && this.password != null) {
                    this.currentUser = this.serviceUser.connect(this.login, this.password);
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("User connected : " + this.currentUser.getFullName());
                    }
                }
            }
            catch (WaoBusinessException eee) {
                if (eee.getType().equals((Object)WaoBusinessException.Type.BAD_CONNECTION)) {
                    this.connexionFeedback.addError(new String[]{eee.getMessage()});
                    this.email = this.login;
                } else if (eee.getType().equals((Object)WaoBusinessException.Type.ILLEGAL_CONNECTION)) {
                    this.connexionFeedback.addInfo(eee.getMessage());
                }
                if (!this.logger.isDebugEnabled()) break block8;
                this.logger.error("WaoBusinessException : " + eee.getMessage(), (Throwable)eee);
            }
        }
        return null;
    }

    public boolean hasConnexionErrors() {
        return this.connexionFeedback.hasErrors();
    }

    void onSuccessFromForgetPassword() throws WaoException {
        try {
            this.serviceUser.forgetPassword(this.email);
            this.connexionFeedback.addInfo("Un email avec votre nouveau mot de passe vous a \u00e9t\u00e9 envoy\u00e9.");
        }
        catch (WaoBusinessException eee) {
            this.connexionFeedback.addError(new String[]{eee.getMessage()});
        }
    }

    @Log
    Object onActionFromExit() {
        this.setCurrentUser(null);
        this.request.getSession(false).invalidate();
        return Index.class;
    }
}

