/*
 * #%L
 * Wao :: Web Interface
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2010 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

package fr.ifremer.wao.ui.services;

import fr.ifremer.wao.bean.UserRole;
import fr.ifremer.wao.entity.WaoUser;
import fr.ifremer.wao.entity.WaoUserImpl;
import fr.ifremer.wao.ui.data.RequiresAuthentication;
import org.apache.tapestry5.services.ApplicationStateManager;

/**
 * ServiceAuthenticationImpl
 *
 * Created: 3 mai 2010
 *
 * @author fdesbois
 * $Id: ServiceAuthenticationImpl.java 474 2010-05-03 16:48:00Z fdesbois $
 */
public class ServiceAuthenticationImpl implements ServiceAuthentication {

    private final ApplicationStateManager stateManager;

    public ServiceAuthenticationImpl(ApplicationStateManager stateManager) {
        this.stateManager = stateManager;
    }

    @Override
    public boolean isUserConnected() {
        return stateManager.exists(WaoUser.class);
    }

    @Override
    public WaoUser getUserConnected() {
        return stateManager.getIfExists(WaoUser.class);
    }

    @Override
    public void setUserConnected(WaoUser user) {
        stateManager.set(WaoUser.class, user);
    }

    @Override
    public boolean isAllowed(Class<?> page) {
        if (page.isAnnotationPresent(RequiresAuthentication.class) &&
                isUserConnected()) {

            RequiresAuthentication check =
                    page.getAnnotation(RequiresAuthentication.class);

            WaoUser user = getUserConnected();

            // Check if user readOnly is allowed
            if (user.getReadOnly() && !check.readOnlyAllowed()) {
                return false;
            }

            // Check if user role is allowed
            for (UserRole role : check.value()) {
                if (role.equals(user.getUserRole())) {
                    return true;
                }
            }
            return false;
        }
        // No restriction if annotation is not present
        return true;
    }

    @Override
    public WaoUser getNewUserInstance() {
        return new WaoUserImpl();
    }

}
