/*
 * #%L
 * Wao :: Web Interface
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2010 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

package fr.ifremer.wao.ui.pages;

import fr.ifremer.wao.WaoBusinessException;
import fr.ifremer.wao.WaoBusinessException.Type;
import fr.ifremer.wao.WaoException;
import fr.ifremer.wao.entity.WaoUser;
import fr.ifremer.wao.service.ServiceUser;
import fr.ifremer.wao.ui.components.FeedBack;
import org.apache.tapestry5.PersistenceConstants;
import org.apache.tapestry5.annotations.InjectComponent;
import org.apache.tapestry5.annotations.Log;
import org.apache.tapestry5.annotations.Persist;
import org.apache.tapestry5.annotations.Property;
import org.apache.tapestry5.annotations.SessionState;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.services.PageRenderLinkSource;
import org.slf4j.Logger;

/**
 * Login
 *
 * Created: 3 mai 2010
 *
 * @author fdesbois
 * $Id: Connexion.java 478 2010-05-04 12:29:11Z fdesbois $
 */
public class Connexion {
    
    @Inject
    private Logger logger;

    @Inject
    private ServiceUser serviceUser;

    @Inject
    private PageRenderLinkSource pageRender;
    
    /**
     * Objet de session représentant l'utilisateur identifié
     */
    @SessionState
    private WaoUser currentUser;
    
    @InjectComponent
    private FeedBack connexionFeedback;

    private String redirectPage;

    /**
     * User for connexion form data
     */
    @Property
    private String login;

    @Property
    private String password;

    @Persist(PersistenceConstants.FLASH)
    @Property
    private String email;

    void onActivate(String page) {
        this.redirectPage = page;
    }

    String onPassivate() {
        return redirectPage;
    }

    void onValidateFormFromConnexionForm() {
        try {
            if (logger.isDebugEnabled()) {
                logger.debug("Login : " + login);
            }
            if (login != null && password != null) {
                currentUser = serviceUser.connect(login, password);
                if (logger.isDebugEnabled()) {
                    logger.debug("User connected : " +
                            currentUser.getFullName());
                }
            }
        } catch (WaoBusinessException eee) {
            if (eee.getType().equals(Type.BAD_CONNECTION)) {
                connexionFeedback.addError(eee.getMessage());
                email = login;
            } else if (eee.getType().equals(Type.ILLEGAL_CONNECTION)) {
                connexionFeedback.addInfo(eee.getMessage());
            }
            if (logger.isDebugEnabled()) {
                logger.error("WaoBusinessException : " + eee.getMessage(), eee);
            }
        }
    }

    @Log
    Object onSuccessFromConnexionForm() throws WaoException {
        if (hasConnexionErrors()) {
            return this;
        }
        // If redirectPage is defined, return a new Link to this page
        if (redirectPage == null) {
            redirectPage = "index";
        }
        return pageRender.createPageRenderLink(redirectPage);
    }

    public boolean hasConnexionErrors() {
        return connexionFeedback.hasErrors();
    }
    
    void onSuccessFromForgetPassword() throws WaoException {
        try {
            serviceUser.forgetPassword(email);
            connexionFeedback.addInfo("Un email avec votre nouveau mot de " +
                    "passe vous a été envoyé.");
        } catch (WaoBusinessException eee) {
            connexionFeedback.addError(eee.getMessage());
        }
    }
}
