/*
 * #%L
 * Wao :: Web Interface
 * 
 * $Id: BusinessUtils.java 462 2010-04-19 23:41:59Z tchemit $
 * $HeadURL: svn+ssh://fdesbois@labs.libre-entreprise.org/svnroot/suiviobsmer/tags/wao-1.2.1/wao-ui/src/main/java/fr/ifremer/wao/ui/data/BusinessUtils.java $
 * %%
 * Copyright (C) 2009 - 2010 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

package fr.ifremer.wao.ui.data;

import fr.ifremer.wao.bean.ContactState;
import fr.ifremer.wao.bean.SamplingFilter;
import fr.ifremer.wao.entity.Boat;
import fr.ifremer.wao.entity.Contact;
import fr.ifremer.wao.entity.FishingZone;
import fr.ifremer.wao.entity.Profession;
import fr.ifremer.wao.entity.SampleRow;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;

/**
 * DataUtils
 *
 * Created: 3 déc. 2009
 *
 * @author fdesbois <fdesbois@codelutin.com>
 */
public class BusinessUtils {


    public static String getTooltipSampleRow(SampleRow row) {
        StringBuilder result = new StringBuilder();
        DateFormat dateFormat = new SimpleDateFormat("MM/yyyy");
        Profession profession = row.getProfession();
        result.append("<strong>Métier : </strong>").
               append(profession.getCodeDCF5());
        if (!StringUtils.isEmpty(profession.getMeshSize())) {
            result.append(' ').append(profession.getMeshSize());
        }
        if (!StringUtils.isEmpty(profession.getSize())) {
            result.append(' ').append(profession.getSize());
        }
        if (!StringUtils.isEmpty(profession.getOther())) {
            result.append(' ').append(profession.getOther());
        }
        result.append(" - ").append(profession.getLibelle());
        if (!StringUtils.isEmpty(profession.getSpecies())) {
            result.append("<br /><strong>Espèces cibles : </strong>").
                   append(profession.getSpecies());
        }
        result.append("<br /><strong>Programme : </strong>").
               append(row.getProgramName()).
               append("<br /><strong>Période : </strong> du ").
               append(dateFormat.format(row.getPeriodBegin())).append(" au ").
               append(dateFormat.format(row.getPeriodEnd()));

        for (FishingZone zone : row.getFishingZone()) {
            result.append("<br /><strong>Zone de pêche : </strong>").
                   append(zone.getCode());
        }

        return result.toString();
    }

    public static String getTooltipBoat(Boat boat) {
        StringBuilder result = new StringBuilder("<strong>").
                append(boat.getImmatriculation()).append("</strong>").
                append("<br /><strong>Quartier : </strong>").
                append(boat.getDistrictCode()).
                append("<br /><strong>Longueur : </strong>").
                append(boat.getBoatLength()).append(" m").
                append("<br /><strong>Année de construction : </strong>").
                append(boat.getBuildYear());
        return result.toString();
    }

    public static String getDataSamplingTitle(SamplingFilter filter) {
        StringBuilder result = new StringBuilder("Données des marées");
        String separator = " : ";
        if (filter.getCompany() != null) {
            //result.append(!filtered ? " : " : ", ";
            result.append(separator).
                   append("\nSociété ").append(filter.getCompany().getName());
            separator = ", ";
        }
        if (StringUtils.isNotEmpty(filter.getProgramName())) {
            result.append(separator).
                   append("\nProgramme ").append(filter.getProgramName());
            separator = ", ";
        }
        if (filter.getSampleRow() != null) {
            Profession profession = filter.getSampleRow().getProfession();
            result.append(separator).
                   append("\nMétier ").append(profession.getCode());
            if (StringUtils.isNotEmpty(profession.getLibelle())) {
                result.append(" - ").append(profession.getLibelle());
            }
            if (StringUtils.isNotEmpty(profession.getSpecies())) {
                result.append("\nEspèces (").
                       append(profession.getSpecies()).append(")");
            }
            result.append("\nZones de pêche (");
            for (FishingZone zone : filter.getSampleRow().getFishingZone()) {
                result.append(zone.getDistrictCode()).append(' ');
            }
            result.append(")");
            separator = ", ";
        } else {
            if (filter.getFacadeName() != null) {
                result.append(separator).
                       append("\nFaçade ").append(filter.getFacadeName());
                separator = ", ";
            }
            if (filter.getSectorName() != null) {
                result.append(separator).
                       append("\nZone ").append(filter.getSectorName());
            }
        }
        return result.toString();
    }

    public static String getContactStyle(Contact contact, boolean admin) {
        String result = "";
        boolean accepted = BooleanUtils.isTrue(contact.getValidationProgram()) ||
                (!admin && BooleanUtils.isTrue(contact.getValidationCompany()));

        ContactState state = contact.getContactState();
        if (BooleanUtils.isFalse(contact.getValidationProgram()) ||
                (!admin && BooleanUtils.isFalse(contact.getValidationCompany()))) {
            result = "refused";
        } else if (accepted && state.equals(ContactState.BOARDING_DONE)) {
            result = "accepted";
        } else if (accepted && state.isUnfinishedState()) {
            result = "unfinished";
        } else if (state.isFinalState()) {
            result = "even";
        } else {
            result = "odd";
        }
        return result;
    }
}
