/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.wao.ui.pages;

import fr.ifremer.wao.WaoException;
import fr.ifremer.wao.entity.ActivityCalendar;
import fr.ifremer.wao.entity.ActivityMonth;
import fr.ifremer.wao.entity.ActivityProfession;
import fr.ifremer.wao.entity.ActivityZone;
import fr.ifremer.wao.entity.Boat;
import fr.ifremer.wao.entity.WaoUser;
import fr.ifremer.wao.service.ServiceBoat;
import fr.ifremer.wao.ui.base.WaoPage;
import fr.ifremer.wao.ui.pages.Boats;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.tapestry5.annotations.IncludeStylesheet;
import org.apache.tapestry5.annotations.InjectPage;
import org.apache.tapestry5.annotations.Persist;
import org.apache.tapestry5.annotations.Property;
import org.apache.tapestry5.annotations.SessionState;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.nuiton.util.DateUtils;
import org.slf4j.Logger;

@IncludeStylesheet(value={"context:css/boats.css"})
public class BoatActivityCalendar
implements WaoPage {
    @Inject
    private Logger log;
    @Inject
    private ServiceBoat serviceBoat;
    @SessionState
    private WaoUser user;
    private ActivityCalendar activityCalendar;
    @Property
    private int month;
    @Property
    private int professionIndex;
    @Property
    private int zoneIndex;
    @Persist
    private Boat boat;
    @InjectPage
    private Boats boatsPage;

    public boolean canDisplay() {
        return true;
    }

    void setupRender() {
    }

    public void setBoat(Boat boat) {
        this.boat = boat;
    }

    public Boat getBoat() {
        return this.boat;
    }

    public List<Boat> getBoats() {
        return Collections.singletonList(this.boat);
    }

    public ActivityCalendar getActivityCalendar() throws WaoException {
        if (this.activityCalendar == null) {
            this.activityCalendar = this.serviceBoat.getLastActivityCalendar(this.user, this.getBoat());
        }
        return this.activityCalendar;
    }

    public ActivityMonth getActivityMonth() throws WaoException {
        return this.getActivityCalendar().getActivityMonth(this.month);
    }

    public String getMonthName() {
        String libelle = DateUtils.getMonthLibelle((int)this.month);
        return StringUtils.capitalize((String)libelle);
    }

    public int getProfessionIndexMax() {
        int result = 0;
        for (ActivityMonth curr : this.activityCalendar.getActivityMonth()) {
            int nbProfessions = curr.sizeActivityProfession();
            if (nbProfessions <= result) continue;
            result = nbProfessions;
        }
        return result - 1;
    }

    public boolean hasProfessions() {
        return this.getProfessionIndexMax() != -1;
    }

    public ActivityProfession getActivityProfession() throws WaoException {
        if (this.getActivityMonth() == null) {
            return null;
        }
        if (this.professionIndex >= this.getActivityMonth().sizeActivityProfession()) {
            return null;
        }
        return (ActivityProfession)this.getActivityMonth().getActivityProfession().get(this.professionIndex);
    }

    public int getZoneIndexMax() throws WaoException {
        int result = 0;
        for (ActivityMonth activityMonth : this.activityCalendar.getActivityMonth()) {
            int nbZones;
            this.month = activityMonth.getMonth();
            ActivityProfession profession = this.getActivityProfession();
            if (profession == null || (nbZones = profession.sizeActivityZone()) <= result) continue;
            result = nbZones;
        }
        return result - 1;
    }

    public String getNorow() {
        return null;
    }

    public ActivityZone getActivityZone() throws WaoException {
        ActivityProfession profession = this.getActivityProfession();
        if (profession == null) {
            return null;
        }
        if (this.zoneIndex >= profession.sizeActivityZone()) {
            return null;
        }
        return (ActivityZone)profession.getActivityZone().get(this.zoneIndex);
    }

    Object onActionFromReturnToBoats() {
        this.boatsPage.setBoatSelectedImmatriculation(Integer.valueOf(this.getBoat().getImmatriculation()));
        return this.boatsPage;
    }
}

