/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.wao.ui.pages;

import fr.ifremer.wao.WaoBusinessException;
import fr.ifremer.wao.WaoException;
import fr.ifremer.wao.entity.Company;
import fr.ifremer.wao.entity.CompanyImpl;
import fr.ifremer.wao.entity.WaoUser;
import fr.ifremer.wao.service.ServiceReferential;
import fr.ifremer.wao.service.ServiceUser;
import fr.ifremer.wao.ui.base.GenericSelectModel;
import fr.ifremer.wao.ui.base.WaoPage;
import fr.ifremer.wao.ui.components.Layout;
import fr.ifremer.wao.ui.data.BusinessUtils;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.tapestry5.EventContext;
import org.apache.tapestry5.annotations.IncludeStylesheet;
import org.apache.tapestry5.annotations.InjectComponent;
import org.apache.tapestry5.annotations.Log;
import org.apache.tapestry5.annotations.Persist;
import org.apache.tapestry5.annotations.Property;
import org.apache.tapestry5.annotations.SessionState;
import org.apache.tapestry5.ioc.Messages;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.ioc.services.PropertyAccess;
import org.apache.tapestry5.ioc.services.TypeCoercer;
import org.apache.tapestry5.upload.services.UploadedFile;
import org.slf4j.Logger;

@IncludeStylesheet(value={"context:css/administration.css"})
public class Administration
implements WaoPage {
    @Inject
    private Logger log;
    @InjectComponent
    private Layout layout;
    @SessionState
    private WaoUser currentUser;
    @Inject
    private ServiceUser serviceUser;
    @Inject
    private ServiceReferential serviceReferential;
    @Inject
    private TypeCoercer typeCoercer;
    @Property
    private String companyId;
    @Property
    private String userId;
    @Persist
    private List<Company> companies;
    @Inject
    private PropertyAccess propertyAccess;
    private GenericSelectModel<Company> companiesSelectModel;
    private Company company;
    private GenericSelectModel<WaoUser> usersSelectModel;
    @Persist
    private WaoUser user;
    @Property
    private boolean generatePassword;
    @Property
    private String password;
    private boolean addNewCompanySelected;
    private boolean addNewUserSelected;
    private boolean deleteUserSelected;
    @Property
    private UploadedFile fishingZoneCsvFile;
    @Inject
    private Messages messages;

    public boolean canDisplay() {
        return this.currentUser.isAdmin() && !this.currentUser.getReadOnly();
    }

    void setupRender() throws WaoException {
        this.companies = null;
        this.getCompanies();
        this.user = null;
    }

    void onActivate(EventContext ec) {
        if (ec.getCount() > 0) {
            this.companyId = (String)ec.get(String.class, 0);
            if (ec.getCount() > 1) {
                this.userId = (String)ec.get(String.class, 1);
            }
        }
    }

    Object[] onPassivate() {
        return new String[]{this.companyId, this.userId};
    }

    @Log
    void onSuccessFromImportFishingZones() {
        try {
            int result = this.serviceReferential.importFishingZoneCsv(this.fishingZoneCsvFile.getStream());
            this.layout.addInfo(result + " zones de p\u00eache import\u00e9es");
        }
        catch (WaoException eee) {
            String[] errors = BusinessUtils.getErrorMessages((WaoException)eee, (Messages)this.messages, (Logger)this.log);
            this.layout.addError(errors);
        }
    }

    public List<Company> getCompanies() throws WaoException {
        if (this.companies == null) {
            this.companies = this.serviceUser.getCompanies(false);
        }
        return this.companies;
    }

    public GenericSelectModel<Company> getCompaniesSelectModel() throws WaoException {
        if (this.companiesSelectModel == null) {
            this.companiesSelectModel = new GenericSelectModel(this.getCompanies(), Company.class, "name", "id", this.propertyAccess);
        }
        return this.companiesSelectModel;
    }

    public Company getCompany() throws WaoException {
        if (this.company == null) {
            this.company = this.companyId != null ? (Company)this.getCompaniesSelectModel().findObject(this.companyId) : new CompanyImpl();
        }
        return this.company;
    }

    public boolean isUsersAvailable() throws WaoException {
        return !StringUtils.isEmpty((String)this.getCompany().getId()) && this.getCompany().getActive();
    }

    void onSelectedFromAddNewCompany() {
        this.addNewCompanySelected = true;
    }

    void onSuccessFromActionsForm() {
        if (this.addNewCompanySelected) {
            this.companyId = null;
        }
        this.userId = null;
        this.user = null;
    }

    void onSuccessFromCompany() throws WaoException {
        this.serviceUser.createUpdateCompany(this.company);
        this.companyId = this.company.getId();
    }

    @Log
    public GenericSelectModel<WaoUser> getUsersSelectModel() throws WaoException {
        if (this.usersSelectModel == null) {
            List users = this.serviceUser.getUsersByCompany(this.getCompany());
            if (this.log.isDebugEnabled()) {
                this.log.debug("Nb users : " + users.size());
            }
            this.usersSelectModel = new GenericSelectModel(users, WaoUser.class, "fullName", "id", this.propertyAccess);
        }
        return this.usersSelectModel;
    }

    @Log
    public WaoUser getUser() throws WaoException {
        if (this.user == null) {
            if (this.userId != null) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("User exist in selectModel : " + this.userId);
                }
                this.user = (WaoUser)this.getUsersSelectModel().findObject(this.userId);
            } else {
                this.user = this.serviceUser.getNewUser(this.getCompany());
                this.generatePassword = true;
            }
        }
        return this.user;
    }

    void onSelectedFromAddNewUser() {
        this.addNewUserSelected = true;
    }

    void onSelectedFromDeleteUser() {
        this.deleteUserSelected = true;
    }

    void onSuccessFromUserActionsForm() throws WaoException {
        if (this.addNewUserSelected) {
            this.userId = null;
        } else if (this.deleteUserSelected && this.userId != null) {
            this.user = (WaoUser)this.getUsersSelectModel().findObject(this.userId);
            try {
                this.serviceUser.deleteUser(this.user);
                this.user = null;
                this.userId = null;
                this.layout.addInfo("Utilisateur supprim\u00e9 avec succ\u00e8s !");
            }
            catch (WaoBusinessException eee) {
                this.layout.addError(new String[]{eee.getMessage()});
            }
        }
    }

    @Log
    void onSuccessFromUser() throws WaoException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("User : " + this.user);
        }
        if (!StringUtils.isEmpty((String)this.password)) {
            this.user.setPassword(this.password);
            this.user.setPasswordChanged(true);
        }
        try {
            this.serviceUser.createUpdateUser(this.user, this.generatePassword);
            this.userId = this.user.getId();
        }
        catch (WaoBusinessException eee) {
            this.layout.addError(new String[]{eee.getMessage()});
        }
    }
}

