/*
 * Decompiled with CFR 0.152.
 */
package winstone.ssl;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Map;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import winstone.HostGroup;
import winstone.HttpListener;
import winstone.Logger;
import winstone.ObjectPool;
import winstone.WebAppConfiguration;
import winstone.WinstoneException;
import winstone.WinstoneRequest;
import winstone.WinstoneResourceBundle;

public class HttpsListener
extends HttpListener {
    private static final WinstoneResourceBundle SSL_RESOURCES = new WinstoneResourceBundle("winstone.ssl.LocalStrings");
    private String keystore;
    private String password;
    private String keyManagerType;

    public HttpsListener(Map args, ObjectPool objectPool, HostGroup hostGroup) throws IOException {
        super(args, objectPool, hostGroup);
        this.keystore = WebAppConfiguration.stringArg(args, this.getConnectorName() + "KeyStore", "winstone.ks");
        this.password = WebAppConfiguration.stringArg(args, this.getConnectorName() + "KeyStorePassword", null);
        this.keyManagerType = WebAppConfiguration.stringArg(args, this.getConnectorName() + "KeyManagerType", "SunX509");
    }

    protected int getDefaultPort() {
        return -1;
    }

    protected String getConnectorScheme() {
        return "https";
    }

    protected ServerSocket getServerSocket() throws IOException {
        SSLContext context = this.getSSLContext(this.keystore, this.password);
        SSLServerSocketFactory factory = context.getServerSocketFactory();
        SSLServerSocket ss = (SSLServerSocket)(this.listenAddress == null ? factory.createServerSocket(this.listenPort, HttpListener.BACKLOG_COUNT) : factory.createServerSocket(this.listenPort, HttpListener.BACKLOG_COUNT, InetAddress.getByName(this.listenAddress)));
        ss.setEnableSessionCreation(true);
        ss.setWantClientAuth(true);
        return ss;
    }

    protected void parseSocketInfo(Socket socket, WinstoneRequest req) throws IOException {
        super.parseSocketInfo(socket, req);
        if (socket instanceof SSLSocket) {
            SSLSocket s = (SSLSocket)socket;
            SSLSession ss = s.getSession();
            if (ss != null) {
                Certificate[] certChain = null;
                try {
                    certChain = ss.getPeerCertificates();
                }
                catch (Throwable err) {
                    // empty catch block
                }
                if (certChain != null) {
                    req.setAttribute("javax.servlet.request.X509Certificate", certChain);
                    req.setAttribute("javax.servlet.request.cipher_suite", ss.getCipherSuite());
                    req.setAttribute("javax.servlet.request.ssl_session", new String(ss.getId()));
                    req.setAttribute("javax.servlet.request.key_size", this.getKeySize(ss.getCipherSuite()));
                }
            }
            req.setIsSecure(true);
        }
    }

    private Integer getKeySize(String cipherSuite) {
        if (cipherSuite.indexOf("_WITH_NULL_") != -1) {
            return new Integer(0);
        }
        if (cipherSuite.indexOf("_WITH_IDEA_CBC_") != -1) {
            return new Integer(128);
        }
        if (cipherSuite.indexOf("_WITH_RC2_CBC_40_") != -1) {
            return new Integer(40);
        }
        if (cipherSuite.indexOf("_WITH_RC4_40_") != -1) {
            return new Integer(40);
        }
        if (cipherSuite.indexOf("_WITH_RC4_128_") != -1) {
            return new Integer(128);
        }
        if (cipherSuite.indexOf("_WITH_DES40_CBC_") != -1) {
            return new Integer(40);
        }
        if (cipherSuite.indexOf("_WITH_DES_CBC_") != -1) {
            return new Integer(56);
        }
        if (cipherSuite.indexOf("_WITH_3DES_EDE_CBC_") != -1) {
            return new Integer(168);
        }
        return null;
    }

    public SSLContext getSSLContext(String keyStoreName, String password) throws IOException {
        try {
            KeyManagerFactory kmf = KeyManagerFactory.getInstance(this.keyManagerType);
            File ksFile = new File(keyStoreName);
            if (!ksFile.exists() || !ksFile.isFile()) {
                throw new WinstoneException(SSL_RESOURCES.getString("HttpsListener.KeyStoreNotFound", ksFile.getPath()));
            }
            FileInputStream in = new FileInputStream(ksFile);
            char[] passwordChars = password == null ? null : password.toCharArray();
            KeyStore ks = KeyStore.getInstance("JKS");
            ks.load(in, passwordChars);
            kmf.init(ks, passwordChars);
            Logger.log(Logger.FULL_DEBUG, SSL_RESOURCES, "HttpsListener.KeyCount", ks.size() + "");
            Enumeration<String> e = ks.aliases();
            while (e.hasMoreElements()) {
                String alias = e.nextElement();
                Logger.log(Logger.FULL_DEBUG, SSL_RESOURCES, "HttpsListener.KeyFound", new String[]{alias, ks.getCertificate(alias) + ""});
            }
            SSLContext context = SSLContext.getInstance("SSL");
            context.init(kmf.getKeyManagers(), null, null);
            Arrays.fill(passwordChars, 'x');
            return context;
        }
        catch (IOException err) {
            throw err;
        }
        catch (Throwable err) {
            throw new WinstoneException(SSL_RESOURCES.getString("HttpsListener.ErrorGettingContext"), err);
        }
    }
}

