/*
 * Decompiled with CFR 0.152.
 */
package winstone.invoker;

import java.io.IOException;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import winstone.Logger;
import winstone.Mapping;
import winstone.RequestDispatcher;
import winstone.ServletConfiguration;
import winstone.WebAppConfiguration;
import winstone.WinstoneResourceBundle;

public class InvokerServlet
extends HttpServlet {
    private static final String INCLUDE_PATH_INFO = "javax.servlet.include.path_info";
    private static final WinstoneResourceBundle INVOKER_RESOURCES = new WinstoneResourceBundle("winstone.invoker.LocalStrings");
    private Map mountedInstances;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.mountedInstances = new Hashtable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        if (this.mountedInstances != null) {
            Map map = this.mountedInstances;
            synchronized (map) {
                Iterator i = this.mountedInstances.values().iterator();
                while (i.hasNext()) {
                    ((ServletConfiguration)i.next()).destroy();
                }
                this.mountedInstances.clear();
            }
        }
        this.mountedInstances = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ServletConfiguration getInvokableInstance(String servletName) throws ServletException, IOException {
        ServletConfiguration sc = null;
        Map map = this.mountedInstances;
        synchronized (map) {
            if (this.mountedInstances.containsKey(servletName)) {
                sc = (ServletConfiguration)this.mountedInstances.get(servletName);
            }
        }
        if (sc == null) {
            try {
                sc = new ServletConfiguration((WebAppConfiguration)this.getServletContext(), this.getServletConfig().getServletName() + ":" + servletName, servletName, new Hashtable(), -1);
                this.mountedInstances.put(servletName, sc);
                Logger.log(Logger.DEBUG, INVOKER_RESOURCES, "InvokerServlet.MountingServlet", new String[]{servletName, this.getServletConfig().getServletName()});
                sc.ensureInitialization();
            }
            catch (Throwable err) {
                sc = null;
            }
        }
        return sc;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse rsp) throws ServletException, IOException {
        ServletConfiguration invokedServlet;
        boolean isInclude = req.getAttribute(INCLUDE_PATH_INFO) != null;
        String servletName = null;
        servletName = isInclude ? (String)req.getAttribute(INCLUDE_PATH_INFO) : (req.getPathInfo() != null ? req.getPathInfo() : "");
        if (servletName.startsWith("/")) {
            servletName = servletName.substring(1);
        }
        if ((invokedServlet = this.getInvokableInstance(servletName)) == null) {
            Logger.log(Logger.WARNING, INVOKER_RESOURCES, "InvokerServlet.NoMatchingServletFound", servletName);
            rsp.sendError(404, INVOKER_RESOURCES.getString("InvokerServlet.NoMatchingServletFound", servletName));
        } else {
            RequestDispatcher rd = new RequestDispatcher((WebAppConfiguration)this.getServletContext(), invokedServlet);
            rd.setForNamedDispatcher(new Mapping[0], new Mapping[0]);
            rd.forward(req, rsp);
        }
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse rsp) throws ServletException, IOException {
        this.doGet(req, rsp);
    }
}

