/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.referential.actions;

import com.google.common.base.Preconditions;
import fr.ifremer.tutti.persistence.entities.referential.TuttiReferentialEntity;
import fr.ifremer.tutti.service.referential.ReferentialImportResult;
import fr.ifremer.tutti.ui.swing.content.referential.ManageTemporaryReferentialUI;
import fr.ifremer.tutti.ui.swing.content.referential.ManageTemporaryReferentialUIHandler;
import fr.ifremer.tutti.ui.swing.content.referential.ManageTemporaryReferentialUIModel;
import fr.ifremer.tutti.ui.swing.util.actions.LongActionSupport;
import java.io.File;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class ImportTemporaryActionSupport<E extends TuttiReferentialEntity>
extends LongActionSupport<ManageTemporaryReferentialUIModel, ManageTemporaryReferentialUI, ManageTemporaryReferentialUIHandler> {
    private static final Log log = LogFactory.getLog(ImportTemporaryActionSupport.class);
    private File file;
    private ReferentialImportResult<E> result;

    protected abstract File chooseImportFile();

    protected abstract ReferentialImportResult<E> doImport(File var1);

    protected abstract void postSuccessAction(File var1, ReferentialImportResult<E> var2);

    public ImportTemporaryActionSupport(ManageTemporaryReferentialUIHandler handler) {
        super(handler, true);
    }

    public boolean prepareAction() throws Exception {
        boolean doAction = super.prepareAction();
        if (doAction) {
            this.file = this.chooseImportFile();
            doAction = this.file != null;
        }
        return doAction;
    }

    public void releaseAction() {
        this.file = null;
        this.result = null;
        super.releaseAction();
    }

    @Override
    public void doAction() throws Exception {
        Preconditions.checkNotNull((Object)this.file);
        if (log.isInfoEnabled()) {
            log.info((Object)("Will import temporary referential from file: " + this.file));
        }
        this.result = this.doImport(this.file);
    }

    public void postSuccessAction() {
        super.postSuccessAction();
        this.postSuccessAction(this.file, this.result);
    }

    protected void reloadCruise() {
        if (this.getDataContext().isCruiseFilled()) {
            this.getDataContext().reloadCruise();
        }
    }

    protected void reloadFishingOperation() {
        if (this.getDataContext().isFishingOperationFilled()) {
            this.getDataContext().reloadFishingOperation();
        }
    }
}

