/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.protocol.calcifiedpiecessampling.actions;

import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.ui.swing.content.protocol.EditProtocolSpeciesRowModel;
import fr.ifremer.tutti.ui.swing.content.protocol.calcifiedpiecessampling.CalcifiedPiecesSamplingEditorRowModel;
import fr.ifremer.tutti.ui.swing.content.protocol.calcifiedpiecessampling.CalcifiedPiecesSamplingEditorTableModel;
import fr.ifremer.tutti.ui.swing.content.protocol.calcifiedpiecessampling.CalcifiedPiecesSamplingEditorUI;
import fr.ifremer.tutti.ui.swing.util.actions.SimpleActionSupport;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.swing.JOptionPane;
import org.jdesktop.swingx.JXTable;
import org.nuiton.decorator.Decorator;
import org.nuiton.i18n.I18n;

public class DeleteSpeciesAction
extends SimpleActionSupport<CalcifiedPiecesSamplingEditorUI> {
    public DeleteSpeciesAction(CalcifiedPiecesSamplingEditorUI ui) {
        super(ui);
    }

    @Override
    protected void onActionPerformed(CalcifiedPiecesSamplingEditorUI ui) {
        int confirmDeletion;
        JXTable cpsTable = ui.getCpsTable();
        CalcifiedPiecesSamplingEditorTableModel tableModel = (CalcifiedPiecesSamplingEditorTableModel)((Object)cpsTable.getModel());
        int[] selectedRows = cpsTable.getSelectedRows();
        List<CalcifiedPiecesSamplingEditorRowModel> cpsRows = ui.getModel().getCpsRows();
        LinkedHashSet<Species> speciesToDelete = new LinkedHashSet<Species>();
        for (int selectedRow : selectedRows) {
            CalcifiedPiecesSamplingEditorRowModel row = cpsRows.get(selectedRow);
            EditProtocolSpeciesRowModel speciesRowToDelete = row.getProtocolSpecies();
            speciesToDelete.add(speciesRowToDelete.getSpecies());
        }
        Decorator<Species> speciesDecorator = ui.getHandler().getDecorator(Species.class, "withSurveyCode");
        if (speciesToDelete.size() == 1) {
            confirmDeletion = JOptionPane.showConfirmDialog(ui, I18n.t((String)"tutti.editCps.deleteOneSpecies.message", (Object[])new Object[]{speciesDecorator.toString(speciesToDelete.iterator().next())}), I18n.t((String)"tutti.editCps.deleteOneSpecies.title", (Object[])new Object[0]), 0, 3);
        } else {
            StringBuilder builder = new StringBuilder();
            for (Species species : speciesToDelete) {
                builder.append("<li>").append(speciesDecorator.toString((Object)species)).append("</li>");
            }
            confirmDeletion = JOptionPane.showConfirmDialog(ui, I18n.t((String)"tutti.editCps.deleteMoreThanOneSpecies.message", (Object[])new Object[]{builder.toString()}), I18n.t((String)"tutti.editCps.deleteMoreThanOneSpecies.title", (Object[])new Object[0]), 0, 3);
        }
        if (confirmDeletion == 0) {
            for (Species species : speciesToDelete) {
                List rowsToDelete = cpsRows.stream().filter(r -> r.getProtocolSpecies().getSpecies().equals(species)).collect(Collectors.toList());
                TreeSet indexesToDelete = new TreeSet(rowsToDelete.stream().map(cpsRows::indexOf).collect(Collectors.toSet()));
                cpsRows.removeAll(rowsToDelete);
                tableModel.fireTableRowsDeleted((Integer)indexesToDelete.first(), (Integer)indexesToDelete.last());
                ui.getSpeciesComboBox().addItem((Object)species);
            }
        }
    }
}

