/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.actions;

import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.ui.swing.content.operation.FishingOperationsUI;
import fr.ifremer.tutti.ui.swing.content.operation.FishingOperationsUIModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.EditCatchesUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.EditSpeciesBatchPanelUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.SpeciesOrBenthosBatchUISupport;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.edit.SpeciesBatchUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.SpeciesFrequencyUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.SpeciesFrequencyUIHandler;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.SpeciesFrequencyUIModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.actions.SaveSupportAction;
import fr.ifremer.tutti.ui.swing.content.operation.fishing.actions.EditFishingOperationAction;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.swing.JOptionPane;
import jaxx.runtime.SwingUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTable;
import org.nuiton.i18n.I18n;

public class SearchSpeciesInPrevOrNextCatchesAction
extends SaveSupportAction {
    private static final Log log = LogFactory.getLog(SearchSpeciesInPrevOrNextCatchesAction.class);
    protected boolean prev;
    protected Map operationIdAndBatchId;
    protected SpeciesFrequencyUIHandler handler;

    public SearchSpeciesInPrevOrNextCatchesAction(SpeciesFrequencyUI ui, boolean prev) {
        super(ui);
        this.prev = prev;
        this.handler = ui.getHandler();
        if (prev) {
            this.putValue("Name", I18n.t((String)"tutti.editSpeciesFrequencies.action.searchSpeciesInPrevCatches", (Object[])new Object[0]));
            this.putValue("ShortDescription", I18n.t((String)"tutti.editSpeciesFrequencies.action.searchSpeciesInPrevCatches.tip", (Object[])new Object[0]));
            this.putValue("MnemonicKey", SwingUtil.getFirstCharAt((String)I18n.t((String)"tutti.editSpeciesFrequencies.action.searchSpeciesInPrevCatches.mnemonic", (Object[])new Object[0]), (char)'Z'));
        } else {
            this.putValue("Name", I18n.t((String)"tutti.editSpeciesFrequencies.action.searchSpeciesInNextCatches", (Object[])new Object[0]));
            this.putValue("ShortDescription", I18n.t((String)"tutti.editSpeciesFrequencies.action.searchSpeciesInNextCatches.tip", (Object[])new Object[0]));
            this.putValue("MnemonicKey", SwingUtil.getFirstCharAt((String)I18n.t((String)"tutti.editSpeciesFrequencies.action.searchSpeciesInNextCatches.mnemonic", (Object[])new Object[0]), (char)'Z'));
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.operationIdAndBatchId = this.search();
        if (this.operationIdAndBatchId != null) {
            if (this.checkSave()) {
                this.move();
            }
        } else {
            JOptionPane.showOptionDialog(this.handler.getTopestUI(), I18n.t((String)"tutti.informCantFindBatchWithSpecies.message", (Object[])new Object[0]), I18n.t((String)"tutti.informCantFindBatchWithSpecies.title", (Object[])new Object[0]), 0, 1, null, new String[]{I18n.t((String)"tutti.option.ok", (Object[])new Object[0])}, I18n.t((String)"tutti.option.ok", (Object[])new Object[0]));
        }
    }

    protected Map search() {
        SpeciesFrequencyUIModel model = (SpeciesFrequencyUIModel)this.handler.getModel();
        int fishingOperationId = model.getFishingOperation().getIdAsInt();
        int taxonId = model.getBatch().getSpecies().getReferenceTaxonId();
        log.debug((Object)String.format("looking for fishingOperationId: %s, taxonId: %s", fishingOperationId, taxonId));
        Map result = this.prev ? this.handler.getPersistenceService().getPrevOperationNameAndBatchId(fishingOperationId, taxonId) : this.handler.getPersistenceService().getNextOperationNameAndBatchId(fishingOperationId, taxonId);
        log.debug((Object)String.format("search result: %s", result));
        return result;
    }

    protected boolean checkSave() {
        boolean doAction = true;
        if (((SpeciesFrequencyUIModel)this.handler.getModel()).isModify() && (doAction = this.handler.askCancelEditBeforeLeaving())) {
            ((SpeciesFrequencyUIModel)this.handler.getModel()).setModify(false);
        }
        return doAction;
    }

    public void move() {
        EditSpeciesBatchPanelUI oldBatchUI = ((SpeciesFrequencyUI)this.handler.getUI()).getParentContainer(EditSpeciesBatchPanelUI.class);
        final SpeciesOrBenthosBatchUISupport sbbs = oldBatchUI.getModel().getSpeciesOrBenthosBatchUISupport();
        final FishingOperationsUI foUI = ((SpeciesFrequencyUI)this.handler.getUI()).getParentContainer(FishingOperationsUI.class);
        FishingOperationsUIModel foModel = foUI.getModel();
        List<FishingOperation> list = foModel.getFishingOperation();
        Optional<FishingOperation> op = list.stream().filter(o -> Objects.equals(o.getIdAsInt(), this.operationIdAndBatchId.get("operationId"))).findFirst();
        final EditFishingOperationAction changeAction = foUI.getHandler().getEditFishingOperationAction();
        changeAction.addPropertyChangeListener("done", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                changeAction.removePropertyChangeListener("done", this);
                foUI.getTabPane().setSelectedIndex(1);
                EditCatchesUI catchUI = foUI.getCatchesTabContent();
                EditSpeciesBatchPanelUI batchUI = catchUI.getEditSpeciesBatchPanelUI(sbbs);
                SpeciesBatchUI speciesUI = batchUI.getEditBatchesUI();
                JXTable table = speciesUI.getTable();
                String batchId = String.valueOf(SearchSpeciesInPrevOrNextCatchesAction.this.operationIdAndBatchId.get("batchId"));
                int max = table.getRowCount();
                for (int i = 0; i < max; ++i) {
                    Object value = table.getValueAt(i, 1);
                    if (!Objects.equals(value, batchId)) continue;
                    table.setRowSelectionInterval(i, i);
                    break;
                }
            }
        });
        log.debug((Object)String.format("switch to operation: %s", op));
        foModel.setSelectedFishingOperation(op.get());
    }
}

