/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.application.swing.util;

import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import org.apache.commons.lang3.StringUtils;
import org.jdesktop.swingx.JXErrorPane;
import org.jdesktop.swingx.error.ErrorInfo;
import org.jdesktop.swingx.error.ErrorReporter;
import org.nuiton.csv.ImportRuntimeException;
import org.nuiton.i18n.I18n;
import org.nuiton.jaxx.application.ApplicationBusinessException;
import org.nuiton.jaxx.application.swing.ApplicationUIContext;
import org.nuiton.jaxx.application.swing.action.ApplicationActionUI;

public class ApplicationErrorHelper
implements ErrorReporter {
    protected ApplicationUIContext context;

    public ApplicationErrorHelper(ApplicationUIContext context) {
        this.context = context;
    }

    protected Component createHTML(String html) {
        JTextPane textPane = new JTextPane();
        textPane.setContentType("text/html");
        textPane.setEditable(false);
        JScrollPane paneScrollPane = new JScrollPane(textPane);
        paneScrollPane.setVerticalScrollBarPolicy(22);
        paneScrollPane.setPreferredSize(new Dimension(700, 500));
        paneScrollPane.setMinimumSize(new Dimension(100, 100));
        if (!StringUtils.startsWith((CharSequence)html, (CharSequence)"<html>")) {
            html = "<html><body>" + StringUtils.replace((String)html, (String)"\n", (String)"<br/>") + "</body></html>";
        }
        textPane.setText(html);
        return paneScrollPane;
    }

    public void showErrorDialog(String message, Throwable cause) {
        if (cause == null) {
            JOptionPane.showMessageDialog(this.context.getMainUI(), this.createHTML(message), I18n.t((String)"jaxx.application.error.ui.business.error", (Object[])new Object[0]), 0);
        } else if (cause instanceof ApplicationBusinessException) {
            JOptionPane.showMessageDialog(this.context.getMainUI(), this.createHTML(cause.getMessage()), I18n.t((String)"jaxx.application.error.ui.business.error", (Object[])new Object[0]), 0);
        } else if (cause instanceof ImportRuntimeException) {
            JOptionPane.showMessageDialog(this.context.getMainUI(), this.createHTML(cause.getMessage()), I18n.t((String)"jaxx.application.error.ui.business.error", (Object[])new Object[0]), 0);
        } else {
            JXErrorPane pane = new JXErrorPane();
            ErrorInfo info = new ErrorInfo(I18n.t((String)"jaxx.application.error.ui.other.error", (Object[])new Object[0]), I18n.t((String)"jaxx.application.error.errorpane.htmlmessage", (Object[])new Object[]{message}), null, null, cause, null, null);
            pane.setErrorInfo(info);
            pane.setErrorReporter((ErrorReporter)this);
            ApplicationActionUI actionUI = this.context.getActionUI();
            if (actionUI != null) {
                actionUI.close();
            }
            JXErrorPane.showDialog((Component)this.context.getMainUI(), (JXErrorPane)pane);
        }
    }

    public void showErrorDialog(String message) {
        this.showErrorDialog(message, null);
    }

    public void reportError(ErrorInfo errorInfo) throws NullPointerException {
        this.showErrorDialog(errorInfo.getBasicErrorMessage(), errorInfo.getErrorException());
    }

    public void showWarningDialog(String message) {
        JOptionPane.showMessageDialog(this.context.getMainUI(), "<html><body>" + message + "</body></html>", I18n.t((String)"jaxx.application.error.ui.business.warning", (Object[])new Object[0]), 2);
    }
}

