/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.persistence.service.referential;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import fr.ifremer.adagio.core.dao.referential.location.LocationClassificationId;
import fr.ifremer.adagio.core.dao.referential.location.LocationExtendDao;
import fr.ifremer.adagio.core.dao.referential.location.LocationLevelId;
import fr.ifremer.adagio.core.service.referential.location.LocationService;
import fr.ifremer.tutti.persistence.entities.referential.TuttiLocation;
import fr.ifremer.tutti.persistence.entities.referential.TuttiLocations;
import fr.ifremer.tutti.persistence.service.referential.LocationPersistenceService;
import fr.ifremer.tutti.persistence.service.referential.ReferentialPersistenceServiceSupport;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.type.IntegerType;
import org.springframework.stereotype.Service;

@Service(value="locationPersistenceService")
public class LocationPersistenceServiceImpl
extends ReferentialPersistenceServiceSupport
implements LocationPersistenceService {
    private static final Log log = LogFactory.getLog(LocationPersistenceServiceImpl.class);
    @Resource(name="locationDao")
    protected LocationExtendDao locationDao;
    @Resource(name="locationService")
    protected LocationService locationService;

    @Override
    public List<TuttiLocation> getAllProgramZone() {
        Iterator<Object[]> list = this.queryListWithStatus("allLocationsByLevelAndClassificiation", "locationClassificationId", IntegerType.INSTANCE, LocationClassificationId.SECTOR.getValue(), "locationLevelId", IntegerType.INSTANCE, LocationLevelId.SCIENTIFIC_CRUISE_PROGRAM.getValue());
        ArrayList result = Lists.newArrayList();
        this.loadLocations(list, result);
        return Collections.unmodifiableList(result);
    }

    @Override
    public List<TuttiLocation> getAllCountry() {
        Iterator<Object[]> list = this.queryListWithStatus("allLocationsByLevelAndClassificiation", "locationClassificationId", IntegerType.INSTANCE, LocationClassificationId.TERRITORIAL.getValue(), "locationLevelId", IntegerType.INSTANCE, LocationLevelId.PAYS_ISO3.getValue());
        ArrayList result = Lists.newArrayList();
        this.loadLocations(list, result);
        return Collections.unmodifiableList(result);
    }

    @Override
    public List<TuttiLocation> getAllHarbour() {
        Iterator<Object[]> list = this.queryListWithStatus("allLocationsByLevelAndClassificiation", "locationClassificationId", IntegerType.INSTANCE, LocationClassificationId.TERRITORIAL.getValue(), "locationLevelId", IntegerType.INSTANCE, LocationLevelId.PORT.getValue());
        ArrayList result = Lists.newArrayList();
        this.loadLocations(list, result);
        return Collections.unmodifiableList(result);
    }

    @Override
    public List<TuttiLocation> getAllHarbourWithObsoletes() {
        Iterator<Object[]> list = this.queryListWithStatus2("allLocationsByLevelAndClassificiationWithObsoletes", "locationClassificationId", IntegerType.INSTANCE, LocationClassificationId.TERRITORIAL.getValue(), "locationLevelId", IntegerType.INSTANCE, LocationLevelId.PORT.getValue());
        ArrayList result = Lists.newArrayList();
        this.loadLocations(list, result);
        return Collections.unmodifiableList(result);
    }

    @Override
    public ImmutableSet<Integer> getAllFishingOperationStratasAndSubstratasIdsForProgram(String zoneId) {
        Preconditions.checkNotNull((Object)zoneId);
        ImmutableSet.Builder resultBuilder = ImmutableSet.builder();
        List<TuttiLocation> stratas = this.getAllFishingOperationStrata(zoneId);
        if (log.isInfoEnabled()) {
            log.info((Object)("found " + stratas.size() + " stratas for zone: " + zoneId));
        }
        stratas.forEach(strata -> {
            resultBuilder.add((Object)strata.getIdAsInt());
            List<TuttiLocation> subStrats = this.getAllFishingOperationSubStrata(zoneId, strata.getId());
            if (log.isInfoEnabled()) {
                log.info((Object)("found " + subStrats.size() + " substratas for strata: " + strata));
            }
            subStrats.forEach(subStrata -> resultBuilder.add((Object)subStrata.getIdAsInt()));
        });
        return resultBuilder.build();
    }

    @Override
    public Multimap<TuttiLocation, TuttiLocation> getAllFishingOperationStratasAndSubstratas(String zoneId) {
        Preconditions.checkNotNull((Object)zoneId);
        HashMultimap result = HashMultimap.create();
        List<TuttiLocation> stratas = this.getAllFishingOperationStrata(zoneId);
        if (log.isInfoEnabled()) {
            log.info((Object)("stratas : " + stratas.stream().map(TuttiLocation::getLabel).collect(Collectors.toSet())));
        }
        stratas.forEach(arg_0 -> this.lambda$getAllFishingOperationStratasAndSubstratas$2(zoneId, (Multimap)result, arg_0));
        if (log.isInfoEnabled()) {
            log.info((Object)("stratas in result : " + result.keySet().stream().map(TuttiLocation::getLabel).collect(Collectors.toSet())));
        }
        return result;
    }

    @Override
    public List<TuttiLocation> getAllFishingOperationStrata(String zoneId) {
        Preconditions.checkNotNull((Object)zoneId);
        List<TuttiLocation> result = this.getFishingOperationLocationsByParent(LocationLevelId.SCIENTIFIC_CRUISE_STRATA.getValue(), Integer.valueOf(zoneId), LocationLevelId.SCIENTIFIC_CRUISE_PROGRAM.getValue());
        return Collections.unmodifiableList(result);
    }

    @Override
    public List<TuttiLocation> getAllFishingOperationStrataWithObsoletes(String zoneId) {
        Preconditions.checkNotNull((Object)zoneId);
        List<TuttiLocation> result = this.getFishingOperationLocationsByParentWithObsoletes(LocationLevelId.SCIENTIFIC_CRUISE_STRATA.getValue(), Integer.valueOf(zoneId), LocationLevelId.SCIENTIFIC_CRUISE_PROGRAM.getValue());
        return Collections.unmodifiableList(result);
    }

    @Override
    public List<TuttiLocation> getAllFishingOperationSubStrata(String zoneId, String strataId) {
        Integer parentLocationLevelId;
        String parentId;
        if (strataId != null) {
            parentId = strataId;
            parentLocationLevelId = LocationLevelId.SCIENTIFIC_CRUISE_STRATA.getValue();
        } else {
            parentId = zoneId;
            parentLocationLevelId = LocationLevelId.SCIENTIFIC_CRUISE_PROGRAM.getValue();
        }
        Preconditions.checkNotNull((Object)parentId);
        List<TuttiLocation> result = this.getFishingOperationLocationsByParent(LocationLevelId.SCIENTIFIC_CRUISE_SUB_STRATA.getValue(), Integer.valueOf(parentId), parentLocationLevelId);
        return Collections.unmodifiableList(result);
    }

    @Override
    public List<TuttiLocation> getAllFishingOperationSubStrataWithObsoletes(String zoneId, String strataId) {
        Integer parentLocationLevelId;
        String parentId;
        if (strataId != null) {
            parentId = strataId;
            parentLocationLevelId = LocationLevelId.SCIENTIFIC_CRUISE_STRATA.getValue();
        } else {
            parentId = zoneId;
            parentLocationLevelId = LocationLevelId.SCIENTIFIC_CRUISE_PROGRAM.getValue();
        }
        Preconditions.checkNotNull((Object)parentId);
        List<TuttiLocation> result = this.getFishingOperationLocationsByParentWithObsoletes(LocationLevelId.SCIENTIFIC_CRUISE_SUB_STRATA.getValue(), Integer.valueOf(parentId), parentLocationLevelId);
        return Collections.unmodifiableList(result);
    }

    @Override
    public List<TuttiLocation> getAllFishingOperationLocation(String zoneId, String strataId, String subStrataId) {
        Integer parentLocationLevelId;
        String parentId;
        if (subStrataId != null) {
            parentId = subStrataId;
            parentLocationLevelId = LocationLevelId.SCIENTIFIC_CRUISE_SUB_STRATA.getValue();
        } else if (strataId != null) {
            parentId = strataId;
            parentLocationLevelId = LocationLevelId.SCIENTIFIC_CRUISE_STRATA.getValue();
        } else {
            parentId = zoneId;
            parentLocationLevelId = LocationLevelId.SCIENTIFIC_CRUISE_PROGRAM.getValue();
        }
        Preconditions.checkNotNull((Object)parentId);
        List<TuttiLocation> result = this.getFishingOperationLocationsByParent(LocationLevelId.SCIENTIFIC_CRUISE_LOCALITE.getValue(), Integer.valueOf(parentId), parentLocationLevelId);
        return Collections.unmodifiableList(result);
    }

    @Override
    public List<TuttiLocation> getAllFishingOperationLocationWithObsoletes(String zoneId, String strataId, String subStrataId) {
        Integer parentLocationLevelId;
        String parentId;
        if (subStrataId != null) {
            parentId = subStrataId;
            parentLocationLevelId = LocationLevelId.SCIENTIFIC_CRUISE_SUB_STRATA.getValue();
        } else if (strataId != null) {
            parentId = strataId;
            parentLocationLevelId = LocationLevelId.SCIENTIFIC_CRUISE_STRATA.getValue();
        } else {
            parentId = zoneId;
            parentLocationLevelId = LocationLevelId.SCIENTIFIC_CRUISE_PROGRAM.getValue();
        }
        Preconditions.checkNotNull((Object)parentId);
        List<TuttiLocation> result = this.getFishingOperationLocationsByParentWithObsoletes(LocationLevelId.SCIENTIFIC_CRUISE_LOCALITE.getValue(), Integer.valueOf(parentId), parentLocationLevelId);
        return Collections.unmodifiableList(result);
    }

    @Override
    public TuttiLocation getLocation(String id) {
        Object[] source = this.queryUnique("locationById", "locationId", IntegerType.INSTANCE, Integer.valueOf(id));
        TuttiLocation target = source == null ? null : this.loadLocation(source);
        return target;
    }

    @Override
    public String getLocationLabelByLatLong(Float latitude, Float longitude) {
        return this.locationService.getLocationLabelByLatLong(latitude, longitude);
    }

    @Override
    public Integer getLocationIdByLatLong(Float latitude, Float longitude) {
        return this.locationService.getLocationIdByLatLong(latitude, longitude);
    }

    protected List<TuttiLocation> getFishingOperationLocationsByParent(Integer locationLevelId, Integer parentId, Integer parentLocationLevelId) {
        Iterator<Object[]> sources = this.queryListWithStatus("allFishingOperationLocationByParent", "parentId", IntegerType.INSTANCE, parentId, "parentLocationLevelId", IntegerType.INSTANCE, parentLocationLevelId, "locationClassificationId", IntegerType.INSTANCE, LocationClassificationId.SECTOR.getValue(), "locationLevelId", IntegerType.INSTANCE, locationLevelId);
        ArrayList result = Lists.newArrayList();
        this.loadLocations(sources, result);
        return result;
    }

    protected List<TuttiLocation> getFishingOperationLocationsByParentWithObsoletes(Integer locationLevelId, Integer parentId, Integer parentLocationLevelId) {
        Iterator<Object[]> sources = this.queryListWithStatus2("allFishingOperationLocationByParentWithObsoletes", "parentId", IntegerType.INSTANCE, parentId, "parentLocationLevelId", IntegerType.INSTANCE, parentLocationLevelId, "locationClassificationId", IntegerType.INSTANCE, LocationClassificationId.SECTOR.getValue(), "locationLevelId", IntegerType.INSTANCE, locationLevelId);
        ArrayList result = Lists.newArrayList();
        this.loadLocations(sources, result);
        return result;
    }

    protected TuttiLocation loadLocation(Object ... source) {
        TuttiLocation target = TuttiLocations.newTuttiLocation();
        target.setId((Integer)source[0]);
        target.setLabel((String)source[1]);
        target.setName((String)source[2]);
        String statusCode = (String)source[3];
        this.setStatus(statusCode, target);
        return target;
    }

    protected void loadLocations(Iterator<Object[]> list, List<TuttiLocation> result) {
        while (list.hasNext()) {
            Object[] source = list.next();
            TuttiLocation target = this.loadLocation(source);
            result.add(target);
        }
    }

    private /* synthetic */ void lambda$getAllFishingOperationStratasAndSubstratas$2(String zoneId, Multimap result, TuttiLocation strata) {
        List<TuttiLocation> allFishingOperationSubStrata = this.getAllFishingOperationSubStrata(zoneId, strata.getId());
        if (allFishingOperationSubStrata.isEmpty()) {
            result.put((Object)strata, null);
        } else {
            result.putAll((Object)strata, allFishingOperationSubStrata);
        }
    }
}

