/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service.sampling;

import java.util.Objects;

public class SamplingCodePrefix {
    public static final String SEPARATOR = "#";
    public static final String NO_SURVEY_CODE_LABEL = "~";
    protected final String prefix;
    protected final String species;

    public SamplingCodePrefix(String prefix, String species) {
        this.prefix = prefix;
        if (SEPARATOR.equals(species)) {
            species = NO_SURVEY_CODE_LABEL;
        }
        this.species = species;
    }

    public SamplingCodePrefix(String samplingCode) {
        String[] codeParts = samplingCode.split(SEPARATOR);
        this.prefix = codeParts[0];
        this.species = codeParts[1];
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getSpecies() {
        return this.species;
    }

    public String toString() {
        return this.prefix + SEPARATOR + this.species + SEPARATOR;
    }

    public String toSamplingCode(int samplingCodeId) {
        return this.toString() + samplingCodeId;
    }

    public String toSpeciesOnlySamplingCode(int samplingCodeId) {
        return this.species + SEPARATOR + samplingCodeId;
    }

    public static int extractSamplingCodeIdFromSamplingCode(String samplingCode) {
        Objects.requireNonNull(samplingCode);
        String[] codeParts = samplingCode.split(SEPARATOR);
        return Integer.parseInt(codeParts[codeParts.length - 1]);
    }
}

