/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service.sampling;

import com.google.common.base.MoreObjects;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import fr.ifremer.tutti.persistence.entities.TuttiEntities;
import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.persistence.entities.data.IndividualObservationBatch;
import fr.ifremer.tutti.persistence.entities.protocol.CalcifiedPiecesSamplingDefinition;
import fr.ifremer.tutti.persistence.entities.protocol.TuttiProtocol;
import fr.ifremer.tutti.persistence.entities.protocol.Zone;
import fr.ifremer.tutti.persistence.entities.protocol.Zones;
import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.persistence.entities.referential.CaracteristicQualitativeValue;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.persistence.entities.referential.TuttiLocation;
import fr.ifremer.tutti.service.cruise.CruiseCacheAble;
import fr.ifremer.tutti.service.sampling.CacheExtractedKey;
import fr.ifremer.tutti.service.sampling.CalcifiedPiecesSamplingAlgorithmEntryNotFoundException;
import fr.ifremer.tutti.service.sampling.CruiseSamplingInternalCache;
import fr.ifremer.tutti.service.sampling.IndividualObservationSamplingCacheRequest;
import fr.ifremer.tutti.service.sampling.IndividualObservationSamplingContext;
import fr.ifremer.tutti.service.sampling.IndividualObservationSamplingStatus;
import fr.ifremer.tutti.service.sampling.SizeNotDefinedOnIndividualObservationException;
import fr.ifremer.tutti.service.sampling.ZoneNotDefinedOnFishingOperationException;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.IntStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CruiseSamplingCache
implements CruiseCacheAble {
    private static final Log log = LogFactory.getLog(CruiseSamplingCache.class);
    private final CruiseSamplingInternalCache cruiseCache = new CruiseSamplingInternalCache();
    private final CruiseSamplingInternalCache zoneCache = new CruiseSamplingInternalCache();
    private final CruiseSamplingInternalCache fishingOperationCache = new CruiseSamplingInternalCache();
    private final Multimap<Zone, Integer> locationIdsPerZone;
    private final Multimap<Integer, CalcifiedPiecesSamplingDefinition> cpsDefinitionsBySpecies = HashMultimap.create();
    private final Map<Integer, Caracteristic> maturityCaracteristicBySpecies = new HashMap<Integer, Caracteristic>();
    private final Multimap<String, String> matureStatesByMaturityCracteristic = HashMultimap.create();
    private final Caracteristic sexCaracteristic;
    private final Map<Integer, CaracteristicQualitativeValue> sexQualitativeValues;
    private boolean loading;

    public CruiseSamplingCache(TuttiProtocol protocol, Caracteristic sexCaracteristic, Collection<Caracteristic> maturityCaracteristics) {
        this.sexCaracteristic = sexCaracteristic;
        this.sexQualitativeValues = TuttiEntities.splitByIdAsInt((Iterable)sexCaracteristic.getQualitativeValue());
        this.locationIdsPerZone = HashMultimap.create();
        protocol.getZone().forEach(zone -> this.locationIdsPerZone.putAll(zone, (Iterable)Zones.getAllLocationIds((Zone)zone)));
        Map maturityCaracteristicsById = TuttiEntities.splitById(maturityCaracteristics);
        protocol.getSpecies().forEach(speciesProtocol -> {
            this.cpsDefinitionsBySpecies.putAll((Object)speciesProtocol.getSpeciesReferenceTaxonId(), (Iterable)speciesProtocol.getCalcifiedPiecesSamplingDefinition());
            this.maturityCaracteristicBySpecies.put(speciesProtocol.getSpeciesReferenceTaxonId(), (Caracteristic)maturityCaracteristicsById.get(speciesProtocol.getMaturityPmfmId()));
        });
        protocol.getBenthos().forEach(speciesProtocol -> {
            this.cpsDefinitionsBySpecies.putAll((Object)speciesProtocol.getSpeciesReferenceTaxonId(), (Iterable)speciesProtocol.getCalcifiedPiecesSamplingDefinition());
            this.maturityCaracteristicBySpecies.put(speciesProtocol.getSpeciesReferenceTaxonId(), (Caracteristic)maturityCaracteristicsById.get(speciesProtocol.getMaturityPmfmId()));
        });
        protocol.getMaturityCaracteristics().forEach(mc -> this.matureStatesByMaturityCracteristic.putAll((Object)mc.getId(), (Iterable)mc.getMatureStateIds()));
    }

    public boolean isLoading() {
        return this.loading;
    }

    public void setLoading(boolean loading) {
        this.loading = loading;
    }

    @Override
    public void addFishingOperation(FishingOperation fishingOperation, Collection<IndividualObservationBatch> individualObservations) {
        this.addIndividualObservations(fishingOperation, individualObservations);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addIndividualObservations(FishingOperation fishingOperation, Collection<IndividualObservationBatch> individualObservations) {
        Objects.requireNonNull(fishingOperation);
        Objects.requireNonNull(individualObservations);
        Optional<Zone> optionalZone = this.tryFindZone(fishingOperation);
        if (!optionalZone.isPresent()) {
            return;
        }
        Zone zone = optionalZone.get();
        this.setLoading(true);
        try {
            for (IndividualObservationBatch individualObservationBatch : individualObservations) {
                Optional<CalcifiedPiecesSamplingDefinition> optionalCalcifiedPiecesSamplingDefinition = this.tryToFindCalcifiedPiecesSamplingDefinition(individualObservationBatch);
                if (!optionalCalcifiedPiecesSamplingDefinition.isPresent()) continue;
                Species species = individualObservationBatch.getSpecies();
                Objects.requireNonNull(species);
                Float lengthStep = individualObservationBatch.getSize();
                Objects.requireNonNull(lengthStep);
                Boolean maturity = this.getMaturity(individualObservationBatch);
                int lengthStepInMm = individualObservationBatch.getLengthStepCaracteristic().getLengthStepInMm(lengthStep);
                CaracteristicQualitativeValue gender = individualObservationBatch.getCaracteristics().getQualitativeValue(this.sexCaracteristic);
                IndividualObservationSamplingContext individualObservationSamplingContext = this.createContext(fishingOperation.getIdAsInt(), species, zone, optionalCalcifiedPiecesSamplingDefinition.get(), lengthStepInMm, maturity, gender);
                this.addIndividualObservation(individualObservationSamplingContext, individualObservationBatch.getSamplingCode() != null);
            }
        }
        finally {
            this.setLoading(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeIndividualObservations(FishingOperation fishingOperation, Collection<IndividualObservationBatch> individualObservations) {
        Objects.requireNonNull(fishingOperation);
        Objects.requireNonNull(individualObservations);
        Optional<Zone> optionalZone = this.tryFindZone(fishingOperation);
        if (!optionalZone.isPresent()) {
            return;
        }
        Zone zone = optionalZone.get();
        this.setLoading(true);
        try {
            for (IndividualObservationBatch individualObservationBatch : individualObservations) {
                Optional<CalcifiedPiecesSamplingDefinition> optionalCalcifiedPiecesSamplingDefinition = this.tryToFindCalcifiedPiecesSamplingDefinition(individualObservationBatch);
                if (!optionalCalcifiedPiecesSamplingDefinition.isPresent()) continue;
                Species species = individualObservationBatch.getSpecies();
                Objects.requireNonNull(species);
                Boolean maturity = this.getMaturity(individualObservationBatch);
                Objects.requireNonNull(individualObservationBatch.getSize());
                float lengthStep = individualObservationBatch.getSize().floatValue();
                int lengthStepInMm = individualObservationBatch.getLengthStepCaracteristic().getLengthStepInMm(Float.valueOf(lengthStep));
                CaracteristicQualitativeValue gender = individualObservationBatch.getCaracteristics().getQualitativeValue(this.sexCaracteristic);
                IndividualObservationSamplingContext individualObservationSamplingContext = this.createContext(fishingOperation.getIdAsInt(), species, zone, optionalCalcifiedPiecesSamplingDefinition.get(), lengthStepInMm, maturity, gender);
                this.removeIndividualObservation(individualObservationSamplingContext, individualObservationBatch.getSamplingCode() != null);
            }
        }
        finally {
            this.setLoading(false);
        }
    }

    @Override
    public void removeFishingOperation(FishingOperation fishingOperation, Collection<IndividualObservationBatch> individualObservations) {
        Objects.requireNonNull(fishingOperation);
        Objects.requireNonNull(individualObservations);
        Optional<Zone> optionalZone = this.tryFindZone(fishingOperation);
        if (!optionalZone.isPresent()) {
            return;
        }
        Zone zone = optionalZone.get();
        String fishingOperationId = fishingOperation.getId();
        if (log.isInfoEnabled()) {
            log.info((Object)("Removing fishing operation: " + fishingOperation + " from " + this));
        }
        String keyPrefix = CruiseSamplingInternalCache.addPrefixKey((Serializable)((Object)fishingOperationId), "");
        int keyPrefixLength = keyPrefix.length();
        this.fishingOperationCache.getKeys().stream().filter(key -> key.startsWith(keyPrefix)).forEach(fishingOperationSamplingKey -> {
            CruiseSamplingInternalCache.SamplingData samplingData = this.fishingOperationCache.getSamplingData((String)fishingOperationSamplingKey);
            if (log.isInfoEnabled()) {
                log.info((Object)("Found " + fishingOperationSamplingKey + " to remove from fishing operation cache (" + samplingData + ")."));
            }
            int individualObservationCount = samplingData.getIndividualObservationCount();
            int samplingCount = samplingData.getSamplingCount();
            String cruiseSamplingKey = fishingOperationSamplingKey.substring(keyPrefixLength);
            this.cruiseCache.remove(cruiseSamplingKey, individualObservationCount, samplingCount);
            String zoneSamplingKey = this.createZoneSamplingKey(cruiseSamplingKey, zone);
            this.zoneCache.remove(zoneSamplingKey, individualObservationCount, samplingCount);
            this.fishingOperationCache.remove((String)fishingOperationSamplingKey, individualObservationCount, samplingCount);
        });
        this.printInfos("After removing " + fishingOperation);
        this.cleanEmptyEntries();
        this.printInfos("After cleanEmptyEntries");
        if (log.isInfoEnabled()) {
            log.info((Object)(fishingOperation + " removed from fishingOperationCache: " + this.fishingOperationCache.size()));
            log.info((Object)(fishingOperation + " removed from cruiseCache: " + this.cruiseCache.size()));
            log.info((Object)(fishingOperation + " removed from zoneCache: " + this.zoneCache.size()));
            log.info((Object)(fishingOperation + " removed from " + this));
        }
    }

    @Override
    public void close() {
        if (log.isInfoEnabled()) {
            log.info((Object)"Closing cruise sampling cache.");
        }
        this.cruiseCache.close();
        this.zoneCache.close();
        this.fishingOperationCache.close();
        this.locationIdsPerZone.clear();
        this.cpsDefinitionsBySpecies.clear();
        this.maturityCaracteristicBySpecies.clear();
        this.matureStatesByMaturityCracteristic.clear();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("cruiseCache", this.cruiseCache.size()).add("zoneCache", this.zoneCache.size()).add("fishingOperationCache", this.fishingOperationCache.size()).toString();
    }

    public IndividualObservationSamplingStatus getIndividualObservationSamplingStatus(IndividualObservationSamplingCacheRequest request) throws SizeNotDefinedOnIndividualObservationException, ZoneNotDefinedOnFishingOperationException, CalcifiedPiecesSamplingAlgorithmEntryNotFoundException {
        Objects.requireNonNull(request);
        Species species = request.getSpecies();
        Objects.requireNonNull(species);
        Integer lengthStep = request.getLengthClass();
        if (lengthStep == null) {
            throw new SizeNotDefinedOnIndividualObservationException(request);
        }
        FishingOperation fishingOperation = request.getFishingOperation();
        Objects.requireNonNull(fishingOperation);
        Optional<Zone> optionalZone = this.tryFindZone(fishingOperation);
        if (!optionalZone.isPresent()) {
            throw new ZoneNotDefinedOnFishingOperationException(request);
        }
        CaracteristicQualitativeValue gender = request.getGender();
        Boolean maturity = this.getMaturity(request);
        Optional<CalcifiedPiecesSamplingDefinition> optionalCalcifiedPiecesSamplingDefinition = this.tryToFindCalcifiedPiecesSamplingDefinition(species, lengthStep, maturity, gender);
        if (!optionalCalcifiedPiecesSamplingDefinition.isPresent()) {
            throw new CalcifiedPiecesSamplingAlgorithmEntryNotFoundException(request);
        }
        IndividualObservationSamplingContext context = this.createContext(fishingOperation.getIdAsInt(), species, optionalZone.get(), optionalCalcifiedPiecesSamplingDefinition.get(), lengthStep, maturity, gender);
        String cruiseSamplingKey = context.getCruiseSamplingKey();
        CruiseSamplingInternalCache.SamplingData cruiseSamplingData = this.cruiseCache.getOrCreateSamplingData(cruiseSamplingKey);
        String zoneSamplingKey = context.getZoneSamplingKey();
        CruiseSamplingInternalCache.SamplingData zoneSamplingData = this.zoneCache.getOrCreateSamplingData(zoneSamplingKey);
        String fishingOperationSamplingKey = context.getFishingOperationSamplingKey();
        CruiseSamplingInternalCache.SamplingData fishingOperationSamplingData = this.fishingOperationCache.getOrCreateSamplingData(fishingOperationSamplingKey);
        boolean computeSampling = !request.withSamplingCode();
        return new IndividualObservationSamplingStatus(context, computeSampling, cruiseSamplingData, zoneSamplingData, fishingOperationSamplingData);
    }

    public void addIndividualObservation(IndividualObservationSamplingCacheRequest request) {
        IndividualObservationSamplingContext individualObservationSamplingContext = this.getIndividualObservationSamplingContext(request);
        if (individualObservationSamplingContext != null) {
            this.addIndividualObservation(individualObservationSamplingContext, request.withSamplingCode());
        }
    }

    public void removeIndividualObservation(IndividualObservationSamplingCacheRequest request) {
        IndividualObservationSamplingContext individualObservationSamplingContext = this.getIndividualObservationSamplingContext(request);
        if (individualObservationSamplingContext != null) {
            this.removeIndividualObservation(individualObservationSamplingContext, request.withSamplingCode());
        }
    }

    public void addSampling(IndividualObservationSamplingCacheRequest request) {
        IndividualObservationSamplingContext individualObservationSamplingContext = this.getIndividualObservationSamplingContext(request);
        if (individualObservationSamplingContext != null) {
            this.addSampling(individualObservationSamplingContext);
        }
    }

    public void removeSampling(IndividualObservationSamplingCacheRequest request) {
        IndividualObservationSamplingContext individualObservationSamplingContext = this.getIndividualObservationSamplingContext(request);
        if (individualObservationSamplingContext != null) {
            this.removeSampling(individualObservationSamplingContext);
        }
    }

    public boolean isZoneChanged(FishingOperation operation1, FishingOperation operation2) {
        Optional<Zone> optionalZone2;
        Optional<Zone> optionalZone1 = this.tryFindZone(operation1);
        return !Objects.equals(optionalZone1, optionalZone2 = this.tryFindZone(operation2));
    }

    public List<CacheExtractedKey> getSamplingNumbers(Map<String, Species> speciesById) {
        List<CacheExtractedKey> result = this.cruiseCache.getSamplingNumbers(speciesById, this.sexQualitativeValues);
        result.forEach(key -> {
            Optional<CalcifiedPiecesSamplingDefinition> cpsDef = this.tryToFindCalcifiedPiecesSamplingDefinition(key.getSpecies(), key.getLengthStep(), key.getMaturity(), key.getSex());
            if (cpsDef.isPresent()) {
                key.setMaxByLengthStep(cpsDef.get().getMaxByLenghtStep());
            }
        });
        return result;
    }

    public Optional<Zone> tryFindZone(FishingOperation operation) {
        Optional<Object> result = operation.getSubStrata() != null ? this.tryFindZone(operation.getSubStrata()) : (operation.getStrata() != null ? this.tryFindZone(operation.getStrata()) : Optional.empty());
        return result;
    }

    public boolean isSpeciesDefined(Species species) {
        return this.cpsDefinitionsBySpecies.containsKey((Object)species.getReferenceTaxonId());
    }

    private Optional<Zone> tryFindZone(TuttiLocation location) {
        Integer locationId = location.getIdAsInt();
        return this.locationIdsPerZone.keySet().stream().filter(zone -> this.locationIdsPerZone.containsEntry(zone, (Object)locationId)).findFirst();
    }

    private Boolean getMaturity(IndividualObservationSamplingCacheRequest samplingCacheRequest) {
        Caracteristic maturityCaracteristic;
        Boolean maturity = samplingCacheRequest.getForcedMaturity();
        if (maturity == null && samplingCacheRequest.withMaturity() && (maturityCaracteristic = this.maturityCaracteristicBySpecies.get(samplingCacheRequest.getSpecies().getReferenceTaxonId())) != null) {
            CaracteristicQualitativeValue maturityQualitativeValue = samplingCacheRequest.getMaturity();
            maturity = this.matureStatesByMaturityCracteristic.containsEntry((Object)maturityCaracteristic.getId(), (Object)maturityQualitativeValue.getId());
        }
        return maturity;
    }

    private Boolean getMaturity(IndividualObservationBatch individualObservationBatch) {
        CaracteristicQualitativeValue qualitativeValue;
        Boolean maturity = null;
        Caracteristic maturityCaracteristic = this.maturityCaracteristicBySpecies.get(individualObservationBatch.getSpecies().getReferenceTaxonId());
        if (maturityCaracteristic != null && (qualitativeValue = individualObservationBatch.getCaracteristics().getQualitativeValue(maturityCaracteristic)) != null) {
            maturity = this.matureStatesByMaturityCracteristic.containsEntry((Object)maturityCaracteristic.getId(), (Object)qualitativeValue.getId());
        }
        return maturity;
    }

    private String createCruiseSamplingKey(Species species, CaracteristicQualitativeValue gender, Boolean maturity, int lengthStep) {
        return CruiseSamplingInternalCache.createSamplingKey(species, gender, maturity, lengthStep);
    }

    private String createZoneSamplingKey(String cruiseSamplingKey, Zone zone) {
        return CruiseSamplingInternalCache.addPrefixKey((Serializable)((Object)(zone == null ? "" : zone.getId())), cruiseSamplingKey);
    }

    private String createFishingOperationSamplingKey(String cruiseSamplingKey, int fishingOperationId) {
        return CruiseSamplingInternalCache.addPrefixKey(Integer.valueOf(fishingOperationId), cruiseSamplingKey);
    }

    private void addIndividualObservation(IndividualObservationSamplingContext individualObservationSamplingContext, boolean addSampling) {
        Objects.requireNonNull(individualObservationSamplingContext);
        String cruiseSamplingKey = individualObservationSamplingContext.getCruiseSamplingKey();
        CruiseSamplingInternalCache.SamplingData cruiseSamplingData = this.cruiseCache.addOneIndividualObservation(cruiseSamplingKey);
        String zoneSamplingKey = individualObservationSamplingContext.getZoneSamplingKey();
        CruiseSamplingInternalCache.SamplingData zoneSamplingData = this.zoneCache.addOneIndividualObservation(zoneSamplingKey);
        String fishingOperationSamplingKey = individualObservationSamplingContext.getFishingOperationSamplingKey();
        CruiseSamplingInternalCache.SamplingData fishingOperationSamplingData = this.fishingOperationCache.addOneIndividualObservation(fishingOperationSamplingKey);
        if (log.isInfoEnabled()) {
            log.info((Object)this.getLogMessage("add individual observation ", cruiseSamplingKey, zoneSamplingKey, fishingOperationSamplingKey, cruiseSamplingData, zoneSamplingData, fishingOperationSamplingData));
        }
        if (addSampling) {
            this.addSampling(individualObservationSamplingContext);
        }
    }

    private void removeIndividualObservation(IndividualObservationSamplingContext individualObservationSamplingContext, boolean removeSampling) {
        Objects.requireNonNull(individualObservationSamplingContext);
        String cruiseSamplingKey = individualObservationSamplingContext.getCruiseSamplingKey();
        CruiseSamplingInternalCache.SamplingData cruiseSamplingData = this.cruiseCache.removeOneIndividualObservation(cruiseSamplingKey);
        String zoneSamplingKey = individualObservationSamplingContext.getZoneSamplingKey();
        CruiseSamplingInternalCache.SamplingData zoneSamplingData = this.zoneCache.removeOneIndividualObservation(zoneSamplingKey);
        String fishingOperationSamplingKey = individualObservationSamplingContext.getFishingOperationSamplingKey();
        CruiseSamplingInternalCache.SamplingData fishingOperationSamplingData = this.fishingOperationCache.removeOneIndividualObservation(fishingOperationSamplingKey);
        if (log.isInfoEnabled()) {
            log.info((Object)this.getLogMessage("remove individual observation ", cruiseSamplingKey, zoneSamplingKey, fishingOperationSamplingKey, cruiseSamplingData, zoneSamplingData, fishingOperationSamplingData));
        }
        if (removeSampling) {
            this.removeSampling(individualObservationSamplingContext);
        }
    }

    private void addSampling(IndividualObservationSamplingContext individualObservationSamplingContext) {
        Objects.requireNonNull(individualObservationSamplingContext);
        String cruiseSamplingKey = individualObservationSamplingContext.getCruiseSamplingKey();
        CruiseSamplingInternalCache.SamplingData cruiseSamplingData = this.cruiseCache.addOneSampling(cruiseSamplingKey);
        String zoneSamplingKey = individualObservationSamplingContext.getZoneSamplingKey();
        CruiseSamplingInternalCache.SamplingData zoneSamplingData = this.zoneCache.addOneSampling(zoneSamplingKey);
        String fishingOperationSamplingKey = individualObservationSamplingContext.getFishingOperationSamplingKey();
        CruiseSamplingInternalCache.SamplingData fishingOperationSamplingData = this.fishingOperationCache.addOneSampling(fishingOperationSamplingKey);
        if (log.isInfoEnabled()) {
            log.info((Object)this.getLogMessage("add sampling ", cruiseSamplingKey, zoneSamplingKey, fishingOperationSamplingKey, cruiseSamplingData, zoneSamplingData, fishingOperationSamplingData));
        }
    }

    private void removeSampling(IndividualObservationSamplingContext individualObservationSamplingContext) {
        Objects.requireNonNull(individualObservationSamplingContext);
        String cruiseSamplingKey = individualObservationSamplingContext.getCruiseSamplingKey();
        CruiseSamplingInternalCache.SamplingData cruiseSamplingData = this.cruiseCache.removeOneSampling(cruiseSamplingKey);
        String zoneSamplingKey = individualObservationSamplingContext.getZoneSamplingKey();
        CruiseSamplingInternalCache.SamplingData zoneSamplingData = this.zoneCache.removeOneSampling(zoneSamplingKey);
        String fishingOperationSamplingKey = individualObservationSamplingContext.getFishingOperationSamplingKey();
        CruiseSamplingInternalCache.SamplingData fishingOperationSamplingData = this.fishingOperationCache.removeOneSampling(fishingOperationSamplingKey);
        if (log.isInfoEnabled()) {
            log.info((Object)this.getLogMessage("remove sampling ", cruiseSamplingKey, zoneSamplingKey, fishingOperationSamplingKey, cruiseSamplingData, zoneSamplingData, fishingOperationSamplingData));
        }
    }

    private IndividualObservationSamplingContext getIndividualObservationSamplingContext(IndividualObservationSamplingCacheRequest request) {
        Objects.requireNonNull(request);
        FishingOperation fishingOperation = request.getFishingOperation();
        Objects.requireNonNull(fishingOperation);
        Optional<Zone> optionalZone = this.tryFindZone(fishingOperation);
        if (!optionalZone.isPresent()) {
            if (log.isInfoEnabled()) {
                log.info((Object)"Do not record sampling in cache, fishing operation has no matching zone.");
            }
            return null;
        }
        Integer lengthStep = request.getLengthClass();
        Objects.requireNonNull(lengthStep);
        Species species = request.getSpecies();
        Objects.requireNonNull(species);
        Boolean maturity = this.getMaturity(request);
        CaracteristicQualitativeValue gender = request.getGender();
        Optional<CalcifiedPiecesSamplingDefinition> optionalCalcifiedPiecesSamplingDefinition = this.tryToFindCalcifiedPiecesSamplingDefinition(species, lengthStep, maturity, gender);
        if (!optionalCalcifiedPiecesSamplingDefinition.isPresent()) {
            if (log.isInfoEnabled()) {
                log.info((Object)"Do not record sampling in cache, no definition matched.");
            }
            return null;
        }
        return this.createContext(fishingOperation.getIdAsInt(), species, optionalZone.get(), optionalCalcifiedPiecesSamplingDefinition.get(), lengthStep, maturity, gender);
    }

    private IndividualObservationSamplingContext createContext(int fishingOperationId, Species species, Zone zone, CalcifiedPiecesSamplingDefinition calcifiedPiecesSamplingDefinition, Integer lengthStep, Boolean maturity, CaracteristicQualitativeValue gender) {
        String cruiseSamplingKey = this.createCruiseSamplingKey(species, gender, maturity, lengthStep);
        String zoneSamplingKey = this.createZoneSamplingKey(cruiseSamplingKey, zone);
        String fishingOperationSamplingKey = this.createFishingOperationSamplingKey(cruiseSamplingKey, fishingOperationId);
        return new IndividualObservationSamplingContext(species, lengthStep, maturity, gender, calcifiedPiecesSamplingDefinition, zone, cruiseSamplingKey, zoneSamplingKey, fishingOperationSamplingKey);
    }

    private Optional<CalcifiedPiecesSamplingDefinition> tryToFindCalcifiedPiecesSamplingDefinition(IndividualObservationBatch individualObservationBatch) {
        Optional<CalcifiedPiecesSamplingDefinition> result;
        Species species = individualObservationBatch.getSpecies();
        Objects.requireNonNull(species);
        Float lengthStep = individualObservationBatch.getSize();
        if (lengthStep == null) {
            result = Optional.empty();
        } else {
            Boolean maturity = this.getMaturity(individualObservationBatch);
            int lengthStepInMm = individualObservationBatch.getLengthStepCaracteristic().getLengthStepInMm(lengthStep);
            CaracteristicQualitativeValue gender = individualObservationBatch.getCaracteristics().getQualitativeValue(this.sexCaracteristic);
            result = this.tryToFindCalcifiedPiecesSamplingDefinition(species, lengthStepInMm, maturity, gender);
        }
        return result;
    }

    private Optional<CalcifiedPiecesSamplingDefinition> tryToFindCalcifiedPiecesSamplingDefinition(Species species, int lengthStep, Boolean maturity, CaracteristicQualitativeValue gender) {
        Collection cpsDefinitions = this.cpsDefinitionsBySpecies.get((Object)species.getReferenceTaxonId());
        CalcifiedPiecesSamplingDefinition result = null;
        if (cpsDefinitions == null) {
            if (log.isInfoEnabled()) {
                log.info((Object)(species + " not found in any calcified pieces sampling definitions"));
            }
        } else {
            Optional<CalcifiedPiecesSamplingDefinition> optionalDefinition = cpsDefinitions.stream().filter(cpsDef -> !(cpsDef.getMaturity() != null && !Objects.equals(cpsDef.getMaturity(), maturity) || lengthStep < cpsDef.getMinSize() || cpsDef.getMaxSize() != null && lengthStep > cpsDef.getMaxSize())).findFirst();
            if (!optionalDefinition.isPresent()) {
                if (log.isInfoEnabled()) {
                    log.info((Object)(species + " - maturity " + maturity + " length step " + lengthStep + " not found in calcified pieces sampling definitions"));
                }
            } else {
                result = optionalDefinition.get();
                if (result.getSamplingInterval() == 0) {
                    if (log.isInfoEnabled()) {
                        log.info((Object)("Can't use definition with no sampling interval: " + result));
                    }
                    result = null;
                } else if (result.isSex() && gender == null) {
                    if (log.isInfoEnabled()) {
                        log.info((Object)("Can't use definition (sex is required, but none was given): " + result));
                    }
                    result = null;
                } else if (log.isInfoEnabled()) {
                    log.info((Object)("Found matching definition: " + result));
                }
            }
        }
        return Optional.ofNullable(result);
    }

    private String getLogMessage(String prefix, String cruiseSamplingKey, String zoneSamplingKey, String fishingOperationSamplingKey, CruiseSamplingInternalCache.SamplingData cruiseSamplingData, CruiseSamplingInternalCache.SamplingData zoneSamplingData, CruiseSamplingInternalCache.SamplingData fishingOperationSamplingData) {
        int maxSize = IntStream.builder().add(cruiseSamplingKey.length()).add(zoneSamplingKey.length()).add(fishingOperationSamplingKey.length()).build().max().orElseGet(() -> 0);
        return prefix + "\n[cruise            " + String.format("%1$" + maxSize + "s", cruiseSamplingKey).replaceAll(" ", ".") + "] \u2192 " + cruiseSamplingData + "\n[zone              " + String.format("%1$" + maxSize + "s", zoneSamplingKey).replaceAll(" ", ".") + "] \u2192 " + zoneSamplingData + "\n[fishing operation" + String.format("%1$" + maxSize + "s", fishingOperationSamplingKey).replaceAll(" ", ".") + "] \u2192 " + fishingOperationSamplingData;
    }

    private void cleanEmptyEntries() {
        this.cruiseCache.cleanEmptyEntries();
        this.zoneCache.cleanEmptyEntries();
        this.fishingOperationCache.cleanEmptyEntries();
    }

    public void printInfos(String message) {
        if (log.isInfoEnabled()) {
            String cruiseCacheInfos = this.cruiseCache.toStringVerbose();
            String zoneCacheInfos = this.zoneCache.toStringVerbose();
            String fishingOperationCacheInfos = this.fishingOperationCache.toStringVerbose();
            StringBuilder stringBuilder = new StringBuilder(message);
            stringBuilder.append("\nCruise            cache: ").append(cruiseCacheInfos);
            stringBuilder.append("\nZone              cache: ").append(zoneCacheInfos);
            stringBuilder.append("\nFishing operation cache: ").append(fishingOperationCacheInfos);
            if (log.isInfoEnabled()) {
                log.info((Object)stringBuilder.toString());
            }
        }
    }
}

