/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service.genericformat.csv;

import fr.ifremer.tutti.service.csv.AbstractTuttiImportExportModel;
import fr.ifremer.tutti.service.csv.TuttiCsvUtil;
import fr.ifremer.tutti.service.genericformat.GenericFormatImportEntityParserFactory;
import fr.ifremer.tutti.service.genericformat.csv.SurveyRow;
import org.nuiton.csv.ValueFormatter;
import org.nuiton.csv.ValueParser;

public class SurveyModel
extends AbstractTuttiImportExportModel<SurveyRow> {
    public static SurveyModel forExport(char separator) {
        SurveyModel exportModel = new SurveyModel(separator);
        exportModel.forExport();
        return exportModel;
    }

    public static SurveyModel forImport(char separator, GenericFormatImportEntityParserFactory parserFactory) {
        SurveyModel importModel = new SurveyModel(separator);
        importModel.forImport(parserFactory);
        return importModel;
    }

    public SurveyRow newEmptyInstance() {
        return SurveyRow.newEmptyInstance();
    }

    protected SurveyModel(char separator) {
        super(separator);
    }

    protected void forExport() {
        this.newColumnForExport("Annee", "beginDate", (ValueFormatter)TuttiCsvUtil.YEAR);
        this.newColumnForExport("Serie", "program", TuttiCsvUtil.PROGRAM_FORMATTER);
        this.newColumnForExport("Serie_Partielle", "surveyPart");
        this.newColumnForExport("Navire", "vessel", TuttiCsvUtil.VESSEL_FORMATTER);
        this.newColumnForExport("Nombre_Poches", "multirigNumber", (ValueFormatter)TuttiCsvUtil.PRIMITIVE_INTEGER);
        this.newColumnForExport("Pays", "country", TuttiCsvUtil.COUNTRY_FORMATTER);
        this.newColumnForExport("Zone_Etude", "zone", TuttiCsvUtil.PROGRAM_ZONE_FORMATTER);
        this.newColumnForExport("Campagne", "name");
        this.newColumnForExport("Id_Sismer", "idSismer");
        this.newColumnForExport("Date_Deb_Campagne", "beginDate", (ValueFormatter)TuttiCsvUtil.DAY_TIME_SECOND);
        this.newColumnForExport("Port_Deb_Campagne", "departureLocation", TuttiCsvUtil.HARBOUR_FORMATTER);
        this.newColumnForExport("Date_Fin_Campagne", "endDate", (ValueFormatter)TuttiCsvUtil.DAY_TIME_SECOND);
        this.newColumnForExport("Port_Fin_Campagne", "returnLocation", TuttiCsvUtil.HARBOUR_FORMATTER);
        this.newColumnForExport("Chef_Mission", "headOfMission", TuttiCsvUtil.PERSON_LIST_FORMATTER);
        this.newColumnForExport("Resp_Salle_Tri", "headOfSortRoom", TuttiCsvUtil.PERSON_LIST_FORMATTER);
        this.newColumnForExport("Commentaire", "comment", (ValueFormatter)TuttiCsvUtil.COMMENT_PARSER_FORMATTER);
        this.newColumnForExport("Serie_Id", "program", TuttiCsvUtil.PROGRAM_TECHNICAL_FORMATTER);
        this.newColumnForExport("Campagne_Id", "objectId", (ValueFormatter)TuttiCsvUtil.INTEGER);
        this.newColumnForExport("Navire_Id", "vessel", TuttiCsvUtil.VESSEL_TECHNICAL_FORMATTER);
        this.newColumnForExport("Engin_Id", "gear", TuttiCsvUtil.GEAR_LIST_TECHNICAL_FORMATTER);
        this.newColumnForExport("Port_Deb_Campagne_Id", "departureLocation", TuttiCsvUtil.HARBOUR_TECHNICAL_FORMATTER);
        this.newColumnForExport("Port_Fin_Campagne_Id", "returnLocation", TuttiCsvUtil.HARBOUR_TECHNICAL_FORMATTER);
        this.newColumnForExport("Chef_Mission_Id", "headOfMission", TuttiCsvUtil.PERSON_LIST_TECHNICAL_FORMATTER);
        this.newColumnForExport("Resp_Salle_Tri_Id", "headOfSortRoom", TuttiCsvUtil.PERSON_LIST_TECHNICAL_FORMATTER);
    }

    protected void forImport(GenericFormatImportEntityParserFactory parserFactory) {
        this.newMandatoryColumn("Annee", "beginDate", (ValueParser)TuttiCsvUtil.YEAR);
        this.newIgnoredColumn("Serie");
        this.newMandatoryColumn("Serie_Partielle", "surveyPart");
        this.newIgnoredColumn("Navire");
        this.newMandatoryColumn("Nombre_Poches", "multirigNumber", (ValueParser)TuttiCsvUtil.PRIMITIVE_INTEGER);
        this.newIgnoredColumn("Pays");
        this.newIgnoredColumn("Zone_Etude");
        this.newMandatoryColumn("Campagne", "name");
        this.newIgnoredColumn("Id_Sismer");
        this.newMandatoryColumn("Date_Deb_Campagne", "beginDate", (ValueParser)TuttiCsvUtil.DAY_TIME_SECOND);
        this.newIgnoredColumn("Port_Deb_Campagne");
        this.newMandatoryColumn("Date_Fin_Campagne", "endDate", (ValueParser)TuttiCsvUtil.DAY_TIME_SECOND);
        this.newIgnoredColumn("Port_Fin_Campagne");
        this.newIgnoredColumn("Chef_Mission");
        this.newIgnoredColumn("Resp_Salle_Tri");
        this.newMandatoryColumn("Commentaire", "comment", (ValueParser)TuttiCsvUtil.COMMENT_PARSER_FORMATTER);
        this.newMandatoryColumn("Serie_Id", "program", (ValueParser)parserFactory.getProgramParser());
        this.newMandatoryColumn("Campagne_Id", "objectId", (ValueParser)TuttiCsvUtil.INTEGER);
        this.newMandatoryColumn("Navire_Id", "vessel", (ValueParser)parserFactory.getVesselParser());
        this.newMandatoryColumn("Engin_Id", "gear", (ValueParser)parserFactory.getGearListParser());
        this.newMandatoryColumn("Port_Deb_Campagne_Id", "departureLocation", (ValueParser)parserFactory.getHarbourParser());
        this.newMandatoryColumn("Port_Fin_Campagne_Id", "returnLocation", (ValueParser)parserFactory.getHarbourParser());
        this.newMandatoryColumn("Chef_Mission_Id", "headOfMission", (ValueParser)parserFactory.getPersonListParser());
        this.newMandatoryColumn("Resp_Salle_Tri_Id", "headOfSortRoom", (ValueParser)parserFactory.getPersonListParser());
    }
}

