/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.protocol.calcifiedpiecessampling.actions;

import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import fr.ifremer.tutti.service.protocol.ProtocolImportExportService;
import fr.ifremer.tutti.ui.swing.content.protocol.EditProtocolUIModel;
import fr.ifremer.tutti.ui.swing.content.protocol.calcifiedpiecessampling.CalcifiedPiecesSamplingEditorRowModel;
import fr.ifremer.tutti.ui.swing.content.protocol.calcifiedpiecessampling.CalcifiedPiecesSamplingEditorUI;
import fr.ifremer.tutti.ui.swing.content.protocol.calcifiedpiecessampling.CalcifiedPiecesSamplingEditorUIHandler;
import fr.ifremer.tutti.ui.swing.util.actions.LongActionSupport;
import java.io.File;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;

public class ExportProtocolCpsAction
extends LongActionSupport<EditProtocolUIModel, CalcifiedPiecesSamplingEditorUI, CalcifiedPiecesSamplingEditorUIHandler> {
    private static final Log log = LogFactory.getLog(ExportProtocolCpsAction.class);
    private File file;

    public ExportProtocolCpsAction(CalcifiedPiecesSamplingEditorUIHandler handler) {
        super(handler, true);
    }

    public boolean prepareAction() throws Exception {
        boolean doAction = super.prepareAction();
        if (doAction) {
            this.file = this.saveFile(((EditProtocolUIModel)this.getModel()).getName() + "-cps", "csv", I18n.t((String)"tutti.editProtocol.title.choose.cpsExportFile", (Object[])new Object[0]), I18n.t((String)"tutti.editProtocol.action.exportProtocolCpsFile", (Object[])new Object[0]), new String[]{"^.*\\.csv", I18n.t((String)"tutti.common.file.csv", (Object[])new Object[0])});
            doAction = this.file != null;
        }
        return doAction;
    }

    @Override
    public void doAction() throws Exception {
        Preconditions.checkNotNull((Object)this.file);
        if (log.isInfoEnabled()) {
            log.info((Object)("Will export protocol cps to file: " + this.file));
        }
        EditProtocolUIModel model = (EditProtocolUIModel)this.getModel();
        ArrayListMultimap cps = ArrayListMultimap.create();
        for (CalcifiedPiecesSamplingEditorRowModel row : model.getCpsRows()) {
            cps.put(row.getProtocolSpecies().toEntity(), row.toEntity());
        }
        ProtocolImportExportService service = this.getContext().getTuttiProtocolImportExportService();
        service.exportCalcifiedPiecesSamplings(this.file, (Multimap)cps, ((EditProtocolUIModel)this.getModel()).getAllReferentSpeciesByTaxonId());
    }

    public void postSuccessAction() {
        super.postSuccessAction();
        this.sendMessage(I18n.t((String)"tutti.flash.info.cps.exported.from.protocol", (Object[])new Object[]{this.file}));
    }

    public void releaseAction() {
        this.file = null;
        super.releaseAction();
    }
}

