/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.protocol.calcifiedpiecessampling;

import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.ui.swing.content.protocol.EditProtocolSpeciesRowModel;
import fr.ifremer.tutti.ui.swing.content.protocol.EditProtocolUIModel;
import fr.ifremer.tutti.ui.swing.content.protocol.calcifiedpiecessampling.CalcifiedPiecesSamplingEditorRowModel;
import fr.ifremer.tutti.ui.swing.content.protocol.calcifiedpiecessampling.CalcifiedPiecesSamplingEditorTableModel;
import fr.ifremer.tutti.ui.swing.content.protocol.calcifiedpiecessampling.CalcifiedPiecesSamplingEditorUI;
import fr.ifremer.tutti.ui.swing.util.AbstractTuttiBeanUIModel;
import fr.ifremer.tutti.ui.swing.util.AbstractTuttiUIHandler;
import fr.ifremer.tutti.ui.swing.util.TuttiUIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JTable;
import javax.swing.border.LineBorder;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.swing.JAXXWidgetUtil;
import jaxx.runtime.swing.editor.cell.NumberCellEditor;
import jaxx.runtime.validator.swing.SwingValidator;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.decorator.FontHighlighter;
import org.jdesktop.swingx.decorator.HighlightPredicate;
import org.jdesktop.swingx.decorator.Highlighter;
import org.jdesktop.swingx.table.DefaultTableColumnModelExt;
import org.jdesktop.swingx.table.TableColumnExt;
import org.jdesktop.swingx.table.TableColumnModelExt;
import org.nuiton.i18n.I18n;
import org.nuiton.jaxx.application.swing.ApplicationUI;

public class CalcifiedPiecesSamplingEditorUIHandler
extends AbstractTuttiUIHandler<EditProtocolUIModel, CalcifiedPiecesSamplingEditorUI> {
    protected Caracteristic sexCaracteristic;
    protected final PropertyChangeListener rowChangeListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            ((EditProtocolUIModel)((Object)CalcifiedPiecesSamplingEditorUIHandler.this.getModel())).setModify(true);
            String propertyName = evt.getPropertyName();
            CalcifiedPiecesSamplingEditorRowModel row = (CalcifiedPiecesSamplingEditorRowModel)((Object)evt.getSource());
            if ("minSize".equals(propertyName)) {
                List<CalcifiedPiecesSamplingEditorRowModel> cpsRows = ((EditProtocolUIModel)((Object)CalcifiedPiecesSamplingEditorUIHandler.this.getModel())).getCpsRows();
                int newRowIndex = cpsRows.indexOf((Object)row);
                int previousRowIndex = newRowIndex - 1;
                CalcifiedPiecesSamplingEditorRowModel previousRow = cpsRows.get(previousRowIndex);
                Integer newValue = (Integer)evt.getNewValue();
                if (newValue == null) {
                    row.setMinSize(0);
                } else if (newValue <= previousRow.getMinSize() + 1 || row.getMaxSize() != null && newValue >= row.getMaxSize()) {
                    row.setMinSize((Integer)evt.getOldValue());
                } else {
                    previousRow.setMaxSize(newValue - 1);
                    CalcifiedPiecesSamplingEditorTableModel model = (CalcifiedPiecesSamplingEditorTableModel)((Object)((CalcifiedPiecesSamplingEditorUI)CalcifiedPiecesSamplingEditorUIHandler.this.getUI()).getCpsTable().getModel());
                    model.fireTableRowsUpdated(previousRowIndex, newRowIndex);
                }
            } else if ("samplingInterval".equals(propertyName) && evt.getNewValue() == null) {
                row.setSamplingInterval(0);
            }
        }
    };

    public void beforeInit(CalcifiedPiecesSamplingEditorUI ui) {
        super.beforeInit((ApplicationUI)ui);
        this.sexCaracteristic = this.getPersistenceService().getSexCaracteristic();
    }

    public void afterInit(CalcifiedPiecesSamplingEditorUI calcifiedPiecesSamplingEditorUI) {
        this.initUI(calcifiedPiecesSamplingEditorUI);
        this.initBeanFilterableComboBox(((CalcifiedPiecesSamplingEditorUI)this.ui).getSpeciesComboBox(), new ArrayList(), null, "withSurveyCode");
        ((CalcifiedPiecesSamplingEditorUI)this.ui).getSpeciesComboBox().getComboBoxModel().addWillChangeSelectedItemListener(evt -> {
            Optional<EditProtocolSpeciesRowModel> protocolSpecies;
            Species species = (Species)evt.getNextSelectedItem();
            if (species != null && (protocolSpecies = ((EditProtocolUIModel)((Object)((Object)this.getModel()))).getProtocolSpeciesRowForSpecies(species)).isPresent()) {
                ((CalcifiedPiecesSamplingEditorUI)this.getUI()).getMaturityCheckBox().setSelected(protocolSpecies.get().getMaturityPmfm() != null);
            }
        });
        JXTable cpsTable = ((CalcifiedPiecesSamplingEditorUI)this.ui).getCpsTable();
        DefaultTableColumnModelExt columnModel = this.initTableColumnModel();
        CalcifiedPiecesSamplingEditorTableModel tableModel = new CalcifiedPiecesSamplingEditorTableModel((TableColumnModelExt)columnModel);
        cpsTable.setModel((TableModel)((Object)tableModel));
        cpsTable.setColumnModel((TableColumnModel)columnModel);
        tableModel.addTableModelListener(e -> ((EditProtocolUIModel)((Object)((Object)this.getModel()))).setModify(true));
        JTableHeader tableHeader = cpsTable.getTableHeader();
        tableHeader.setReorderingAllowed(false);
        SwingUtil.scrollToTableSelection((JTable)cpsTable);
        this.addHighlighters(cpsTable);
        ((EditProtocolUIModel)((Object)this.getModel())).addPropertyChangeListener("cpsRows", evt -> {
            List rows = (List)evt.getNewValue();
            for (CalcifiedPiecesSamplingEditorRowModel row : rows) {
                row.removePropertyChangeListener(this.rowChangeListener);
                row.addPropertyChangeListener(this.rowChangeListener);
            }
            tableModel.setRows(rows);
            tableModel.fireTableDataChanged();
            ((CalcifiedPiecesSamplingEditorUI)this.getUI()).getSpeciesComboBox().removeItems((Iterable)rows.stream().map(CalcifiedPiecesSamplingEditorRowModel::getProtocolSpecies).map(EditProtocolSpeciesRowModel::getSpecies).collect(Collectors.toList()));
        });
    }

    @Override
    protected void addHighlighters(JXTable cpsTable) {
        CalcifiedPiecesSamplingEditorTableModel tableModel = (CalcifiedPiecesSamplingEditorTableModel)((Object)cpsTable.getModel());
        HighlightPredicate.NotHighlightPredicate notSelectedPredicate = new HighlightPredicate.NotHighlightPredicate(HighlightPredicate.IS_SELECTED);
        HighlightPredicate rowIsInvalidPredicate = (renderer, adapter) -> {
            boolean result = false;
            if (adapter.isEditable()) {
                int viewRow = adapter.row;
                int modelRow = adapter.convertRowIndexToModel(viewRow);
                AbstractTuttiBeanUIModel row = (AbstractTuttiBeanUIModel)((Object)((Object)tableModel.getEntry(modelRow)));
                result = !row.isValid();
            }
            return result;
        };
        HighlightPredicate.NotHighlightPredicate rowIsValidPredicate = new HighlightPredicate.NotHighlightPredicate(rowIsInvalidPredicate);
        Highlighter selectedHighlighter = TuttiUIUtil.newBackgroundColorHighlighter((HighlightPredicate)HighlightPredicate.IS_SELECTED, (Color)this.getConfig().getColorSelectedRow());
        cpsTable.addHighlighter(selectedHighlighter);
        Highlighter readOnlyHighlighter = TuttiUIUtil.newBackgroundColorHighlighter((HighlightPredicate)new HighlightPredicate.AndHighlightPredicate(new HighlightPredicate[]{HighlightPredicate.READ_ONLY, notSelectedPredicate}), (Color)this.getConfig().getColorRowReadOnly());
        cpsTable.addHighlighter(readOnlyHighlighter);
        Highlighter readOnlySelectedHighlighter = TuttiUIUtil.newBackgroundColorHighlighter((HighlightPredicate)new HighlightPredicate.AndHighlightPredicate(new HighlightPredicate[]{HighlightPredicate.READ_ONLY, HighlightPredicate.IS_SELECTED}), (Color)this.getConfig().getColorRowReadOnly().darker());
        cpsTable.addHighlighter(readOnlySelectedHighlighter);
        Highlighter validHighlighter = TuttiUIUtil.newBackgroundColorHighlighter((HighlightPredicate)new HighlightPredicate.AndHighlightPredicate(new HighlightPredicate[]{HighlightPredicate.EDITABLE, notSelectedPredicate, rowIsInvalidPredicate}), (Color)this.getConfig().getColorRowInvalid());
        cpsTable.addHighlighter(validHighlighter);
        Highlighter validSelectedHighlighter = TuttiUIUtil.newBackgroundColorHighlighter((HighlightPredicate)new HighlightPredicate.AndHighlightPredicate(new HighlightPredicate[]{HighlightPredicate.EDITABLE, HighlightPredicate.IS_SELECTED, rowIsInvalidPredicate}), (Color)this.getConfig().getColorRowInvalid().darker());
        cpsTable.addHighlighter(validSelectedHighlighter);
        HighlightPredicate speciesOrderEven = (renderer, adapter) -> {
            int rowIndex = adapter.convertRowIndexToModel(adapter.row);
            return tableModel.isSpeciesOrderEven(rowIndex);
        };
        Highlighter evenHighlighter = TuttiUIUtil.newBackgroundColorHighlighter((HighlightPredicate)new HighlightPredicate.AndHighlightPredicate(new HighlightPredicate[]{new HighlightPredicate.NotHighlightPredicate(speciesOrderEven), notSelectedPredicate, rowIsValidPredicate, HighlightPredicate.READ_ONLY}), (Color)this.getConfig().getColorAlternateRow().darker());
        cpsTable.addHighlighter(evenHighlighter);
        Highlighter oddHighlighter = TuttiUIUtil.newBackgroundColorHighlighter((HighlightPredicate)new HighlightPredicate.AndHighlightPredicate(new HighlightPredicate[]{speciesOrderEven, notSelectedPredicate, rowIsValidPredicate, HighlightPredicate.READ_ONLY}), (Color)Color.WHITE.darker());
        cpsTable.addHighlighter(oddHighlighter);
        Highlighter evenNotReadOnlyHighlighter = TuttiUIUtil.newBackgroundColorHighlighter((HighlightPredicate)new HighlightPredicate.AndHighlightPredicate(new HighlightPredicate[]{new HighlightPredicate.NotHighlightPredicate(speciesOrderEven), notSelectedPredicate, rowIsValidPredicate, HighlightPredicate.EDITABLE}), (Color)this.getConfig().getColorAlternateRow());
        cpsTable.addHighlighter(evenNotReadOnlyHighlighter);
        Highlighter oddNotReadOnlyHighlighter = TuttiUIUtil.newBackgroundColorHighlighter((HighlightPredicate)new HighlightPredicate.AndHighlightPredicate(new HighlightPredicate[]{speciesOrderEven, notSelectedPredicate, rowIsValidPredicate, HighlightPredicate.EDITABLE}), (Color)Color.WHITE);
        cpsTable.addHighlighter(oddNotReadOnlyHighlighter);
        Highlighter evenSelectedHighlighter = TuttiUIUtil.newBackgroundColorHighlighter((HighlightPredicate)new HighlightPredicate.AndHighlightPredicate(new HighlightPredicate[]{new HighlightPredicate.NotHighlightPredicate(speciesOrderEven), HighlightPredicate.IS_SELECTED, rowIsValidPredicate, HighlightPredicate.EDITABLE}), (Color)this.getConfig().getColorSelectedRow());
        cpsTable.addHighlighter(evenSelectedHighlighter);
        Font font = cpsTable.getFont().deriveFont(1);
        FontHighlighter selectHighlighter = new FontHighlighter(HighlightPredicate.IS_SELECTED, font);
        cpsTable.addHighlighter((Highlighter)selectHighlighter);
        HighlightPredicate rowWithoutValuePredicate = (renderer, adapter) -> {
            int rowIndex = adapter.convertRowIndexToModel(adapter.row);
            CalcifiedPiecesSamplingEditorRowModel entry = (CalcifiedPiecesSamplingEditorRowModel)((Object)((Object)tableModel.getEntry(rowIndex)));
            Integer maxByLenghtStep = entry.getMaxByLenghtStep();
            return maxByLenghtStep == null || maxByLenghtStep == 0;
        };
        font = cpsTable.getFont().deriveFont(2);
        cpsTable.addHighlighter((Highlighter)new FontHighlighter(rowWithoutValuePredicate, font));
    }

    protected DefaultTableColumnModelExt initTableColumnModel() {
        NumberCellEditor numberCellEditor = JAXXWidgetUtil.newNumberTableCellEditor(Integer.class, (boolean)false);
        numberCellEditor.getNumberEditor().setSelectAllTextOnError(Boolean.valueOf(true));
        numberCellEditor.getNumberEditor().getTextField().setBorder(new LineBorder(Color.GRAY, 2));
        numberCellEditor.getNumberEditor().setNumberPattern("\\d{0,6}");
        TableCellRenderer infiniteRenderer = (table, value, isSelected, hasFocus, row, column) -> {
            Component result = table.getDefaultRenderer(Integer.class).getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (result instanceof JLabel) {
                JLabel jLabel = (JLabel)result;
                String decoratedValue = this.getDecorator(Integer.class, "nullInfinite").toString(value);
                jLabel.setText(decoratedValue);
                jLabel.setHorizontalTextPosition(4);
            }
            return result;
        };
        JXTable cpsTable = ((CalcifiedPiecesSamplingEditorUI)this.ui).getCpsTable();
        DefaultTableColumnModelExt columnModel = new DefaultTableColumnModelExt();
        TableCellRenderer speciesRenderer = (table, value, isSelected, hasFocus, row, column) -> {
            Component result = table.getDefaultRenderer(String.class).getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (result instanceof JLabel) {
                JLabel jLabel = (JLabel)result;
                EditProtocolSpeciesRowModel species = (EditProtocolSpeciesRowModel)((Object)((Object)value));
                jLabel.setText(this.decorate((Serializable)species.getSpecies(), "withSurveyCode"));
            }
            return result;
        };
        this.addColumnToModel((TableColumnModel)columnModel, null, speciesRenderer, CalcifiedPiecesSamplingEditorTableModel.SPECIES);
        this.addColumnToModel((TableColumnModel)columnModel, null, this.newTableCellRender(Boolean.class, "maturity"), CalcifiedPiecesSamplingEditorTableModel.MATURITY);
        TableColumnExt sexColumn = this.addBooleanColumnToModel((TableColumnModel)columnModel, CalcifiedPiecesSamplingEditorTableModel.SEX, (JTable)cpsTable);
        sexColumn.getCellEditor().addCellEditorListener(new CellEditorListener(){

            @Override
            public void editingStopped(ChangeEvent e) {
                int selectedRow = ((CalcifiedPiecesSamplingEditorUI)CalcifiedPiecesSamplingEditorUIHandler.this.getUI()).getCpsTable().getSelectedRow();
                List<CalcifiedPiecesSamplingEditorRowModel> cpsRows = ((EditProtocolUIModel)((Object)CalcifiedPiecesSamplingEditorUIHandler.this.getModel())).getCpsRows();
                CalcifiedPiecesSamplingEditorRowModel row = cpsRows.get(selectedRow);
                List<CalcifiedPiecesSamplingEditorRowModel> rowsToChangeSex = cpsRows.stream().filter(r -> ((Object)((Object)r.getProtocolSpecies())).equals((Object)row.getProtocolSpecies())).collect(Collectors.toList());
                rowsToChangeSex.forEach(r -> r.setSex(row.isSex()));
                TreeSet indexesToUpdate = new TreeSet(rowsToChangeSex.stream().map(cpsRows::indexOf).collect(Collectors.toSet()));
                CalcifiedPiecesSamplingEditorTableModel tableModel = (CalcifiedPiecesSamplingEditorTableModel)((Object)((CalcifiedPiecesSamplingEditorUI)CalcifiedPiecesSamplingEditorUIHandler.this.getUI()).getCpsTable().getModel());
                tableModel.fireTableRowsUpdated((Integer)indexesToUpdate.first(), (Integer)indexesToUpdate.last());
            }

            @Override
            public void editingCanceled(ChangeEvent e) {
            }
        });
        this.addIntegerColumnToModel((TableColumnModel)columnModel, CalcifiedPiecesSamplingEditorTableModel.MIN_SIZE, "\\d{0,6}", (JTable)cpsTable);
        this.addColumnToModel((TableColumnModel)columnModel, null, infiniteRenderer, CalcifiedPiecesSamplingEditorTableModel.MAX_SIZE);
        this.addColumnToModel((TableColumnModel)columnModel, (TableCellEditor)numberCellEditor, infiniteRenderer, CalcifiedPiecesSamplingEditorTableModel.MAX_BY_LENGHT_STEP);
        this.addIntegerColumnToModel((TableColumnModel)columnModel, CalcifiedPiecesSamplingEditorTableModel.SAMPLING_INTERVAL, "\\d{0,6}", (JTable)cpsTable);
        this.addColumnToModel((TableColumnModel)columnModel, (TableCellEditor)numberCellEditor, infiniteRenderer, CalcifiedPiecesSamplingEditorTableModel.OPERATION_LIMITATION);
        this.addColumnToModel((TableColumnModel)columnModel, (TableCellEditor)numberCellEditor, infiniteRenderer, CalcifiedPiecesSamplingEditorTableModel.ZONE_LIMITATION);
        return columnModel;
    }

    protected void beforeOpenPopup(int modelRowIndex, int modelColumnIndex) {
        boolean rowDeletable;
        boolean splitEnabled;
        boolean speciesDeletable;
        super.beforeOpenPopup(modelRowIndex, modelColumnIndex);
        JMenuItem deleteSpeciesMenu = ((CalcifiedPiecesSamplingEditorUI)this.getUI()).getDeleteSpeciesMenu();
        int selectedRowCount = ((CalcifiedPiecesSamplingEditorUI)this.getUI()).getCpsTable().getSelectedRowCount();
        if (selectedRowCount > 1) {
            speciesDeletable = true;
            splitEnabled = false;
            rowDeletable = false;
            deleteSpeciesMenu.setText(I18n.t((String)"tutti.editCps.deleteMoreThanOneSpecies", (Object[])new Object[0]));
            deleteSpeciesMenu.setToolTipText(I18n.t((String)"tutti.editCps.deleteMoreThanOneSpecies.tip", (Object[])new Object[0]));
        } else {
            splitEnabled = speciesDeletable = modelRowIndex >= 0 && modelRowIndex < ((EditProtocolUIModel)((Object)this.getModel())).getCpsRows().size();
            rowDeletable = speciesDeletable;
            if (speciesDeletable) {
                CalcifiedPiecesSamplingEditorRowModel selectedRow = ((EditProtocolUIModel)((Object)this.getModel())).getCpsRows().get(modelRowIndex);
                Integer minSize = selectedRow.getMinSize();
                splitEnabled = selectedRow.getMaxSize() == null || selectedRow.getMaxSize() - minSize > 1;
                rowDeletable = minSize > 0;
            }
            deleteSpeciesMenu.setText(I18n.t((String)"tutti.editCps.deleteOneSpecies", (Object[])new Object[0]));
            deleteSpeciesMenu.setToolTipText(I18n.t((String)"tutti.editCps.deleteOneSpecies.tip", (Object[])new Object[0]));
        }
        ((CalcifiedPiecesSamplingEditorUI)this.getUI()).getSplitCpsRowMenu().setEnabled(splitEnabled);
        ((CalcifiedPiecesSamplingEditorUI)this.getUI()).getDeleteCpsRowMenu().setEnabled(rowDeletable);
        deleteSpeciesMenu.setEnabled(speciesDeletable);
    }

    protected JComponent getComponentToFocus() {
        return null;
    }

    public void onCloseUI() {
    }

    public SwingValidator<EditProtocolUIModel> getValidator() {
        return null;
    }

    public CalcifiedPiecesSamplingEditorRowModel createNewRow(Species species, Boolean maturity) {
        Optional<EditProtocolSpeciesRowModel> speciesProtocolRow = this.getEditProtocolSpeciesRowModel(species);
        boolean sex = speciesProtocolRow.isPresent() && speciesProtocolRow.get().containsMandatorySampleCategoryId(this.sexCaracteristic.getIdAsInt());
        return this.createNewRow((EditProtocolSpeciesRowModel)speciesProtocolRow.orElse(null), maturity, sex, (Integer)0, (Integer)null);
    }

    public CalcifiedPiecesSamplingEditorRowModel createNewRow(Species species, Boolean maturity, boolean sex, Integer minSize, Integer maxSize) {
        Optional<EditProtocolSpeciesRowModel> speciesProtocolRow = this.getEditProtocolSpeciesRowModel(species);
        return this.createNewRow((EditProtocolSpeciesRowModel)speciesProtocolRow.orElse(null), maturity, sex, minSize, maxSize);
    }

    public CalcifiedPiecesSamplingEditorRowModel createNewRow(EditProtocolSpeciesRowModel species, Boolean maturity, boolean sex, Integer minSize, Integer maxSize) {
        JXTable cpsTable = ((CalcifiedPiecesSamplingEditorUI)this.getUI()).getCpsTable();
        CalcifiedPiecesSamplingEditorTableModel tableModel = (CalcifiedPiecesSamplingEditorTableModel)((Object)cpsTable.getModel());
        CalcifiedPiecesSamplingEditorRowModel newRow = tableModel.createNewRow(species, maturity, sex, minSize, maxSize);
        newRow.removePropertyChangeListener(this.rowChangeListener);
        newRow.addPropertyChangeListener(this.rowChangeListener);
        return newRow;
    }

    protected Optional<EditProtocolSpeciesRowModel> getEditProtocolSpeciesRowModel(Species species) {
        Optional<EditProtocolSpeciesRowModel> speciesProtocolRow = ((EditProtocolUIModel)((Object)this.getModel())).getSpeciesRow().stream().filter(sp -> species.equals(sp.getSpecies())).findFirst();
        if (!speciesProtocolRow.isPresent()) {
            speciesProtocolRow = ((EditProtocolUIModel)((Object)this.getModel())).getBenthosRow().stream().filter(sp -> species.equals(sp.getSpecies())).findFirst();
        }
        return speciesProtocolRow;
    }
}

