/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork2.util.finder;

import com.opensymphony.xwork2.ActionContext;
import com.opensymphony.xwork2.FileManager;
import com.opensymphony.xwork2.FileManagerFactory;
import com.opensymphony.xwork2.XWorkException;
import com.opensymphony.xwork2.util.finder.ClassFinder;
import com.opensymphony.xwork2.util.finder.ClassLoaderInterface;
import com.opensymphony.xwork2.util.finder.Test;
import com.opensymphony.xwork2.util.logging.Logger;
import com.opensymphony.xwork2.util.logging.LoggerFactory;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import org.apache.commons.lang3.StringUtils;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.commons.EmptyVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultClassFinder
implements ClassFinder {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultClassFinder.class);
    private final Map<String, List<ClassFinder.Info>> annotated = new HashMap<String, List<ClassFinder.Info>>();
    private final Map<String, ClassFinder.ClassInfo> classInfos = new LinkedHashMap<String, ClassFinder.ClassInfo>();
    private final List<String> classesNotLoaded = new ArrayList<String>();
    private boolean extractBaseInterfaces;
    private ClassLoaderInterface classLoaderInterface;
    private FileManager fileManager;

    public DefaultClassFinder(ClassLoaderInterface classLoaderInterface, Collection<URL> urls, boolean extractBaseInterfaces, Set<String> protocols, Test<String> classNameFilter) {
        this.classLoaderInterface = classLoaderInterface;
        this.extractBaseInterfaces = extractBaseInterfaces;
        this.fileManager = ActionContext.getContext().getInstance(FileManagerFactory.class).getFileManager();
        ArrayList<String> classNames = new ArrayList<String>();
        for (URL location : urls) {
            try {
                if (protocols.contains(location.getProtocol())) {
                    classNames.addAll(this.jar(location));
                    continue;
                }
                if (!"file".equals(location.getProtocol())) continue;
                try {
                    URL jarUrl = new URL("jar", "", location.toExternalForm() + "!/");
                    JarURLConnection juc = (JarURLConnection)jarUrl.openConnection();
                    juc.getJarFile();
                    classNames.addAll(this.jar(jarUrl));
                }
                catch (IOException e) {
                    classNames.addAll(this.file(location));
                }
            }
            catch (Exception e) {
                if (!LOG.isErrorEnabled()) continue;
                LOG.error("Unable to read URL [#0]", e, location.toExternalForm());
            }
        }
        for (String className : classNames) {
            try {
                if (!classNameFilter.test(className)) continue;
                this.readClassDef(className);
            }
            catch (Throwable e) {
                if (!LOG.isErrorEnabled()) continue;
                LOG.error("Unable to read class [#0]", e, className);
            }
        }
    }

    public DefaultClassFinder(Class ... classes) {
        this(Arrays.asList(classes));
    }

    public DefaultClassFinder(List<Class> classes) {
        this.classLoaderInterface = null;
        ArrayList<ClassFinder.Annotatable> infos = new ArrayList<ClassFinder.Annotatable>();
        ArrayList<Package> packages = new ArrayList<Package>();
        for (Class clazz : classes) {
            Package aPackage = clazz.getPackage();
            if (aPackage != null && !packages.contains(aPackage)) {
                infos.add(new PackageInfo(aPackage));
                packages.add(aPackage);
            }
            ClassFinder.ClassInfo classInfo = new ClassFinder.ClassInfo(clazz, this);
            infos.add(classInfo);
            this.classInfos.put(classInfo.getName(), classInfo);
            for (Method method : clazz.getDeclaredMethods()) {
                infos.add(new ClassFinder.MethodInfo(classInfo, method));
            }
            for (Executable executable : clazz.getConstructors()) {
                infos.add(new ClassFinder.MethodInfo(classInfo, (Constructor)executable));
            }
            for (AccessibleObject accessibleObject : clazz.getDeclaredFields()) {
                infos.add(new ClassFinder.FieldInfo(classInfo, (Field)accessibleObject));
            }
        }
        for (ClassFinder.Info info : infos) {
            for (ClassFinder.AnnotationInfo annotation : info.getAnnotations()) {
                List<ClassFinder.Info> annotationInfos = this.getAnnotationInfos(annotation.getName());
                annotationInfos.add(info);
            }
        }
    }

    @Override
    public ClassLoaderInterface getClassLoaderInterface() {
        return this.classLoaderInterface;
    }

    @Override
    public boolean isAnnotationPresent(Class<? extends Annotation> annotation) {
        List<ClassFinder.Info> infos = this.annotated.get(annotation.getName());
        return infos != null && !infos.isEmpty();
    }

    @Override
    public List<String> getClassesNotLoaded() {
        return Collections.unmodifiableList(this.classesNotLoaded);
    }

    @Override
    public List<Package> findAnnotatedPackages(Class<? extends Annotation> annotation) {
        this.classesNotLoaded.clear();
        ArrayList<Package> packages = new ArrayList<Package>();
        List<ClassFinder.Info> infos = this.getAnnotationInfos(annotation.getName());
        for (ClassFinder.Info info : infos) {
            if (!(info instanceof PackageInfo)) continue;
            PackageInfo packageInfo = (PackageInfo)info;
            try {
                Package pkg = packageInfo.get();
                if (!pkg.isAnnotationPresent(annotation)) continue;
                packages.add(pkg);
            }
            catch (ClassNotFoundException e) {
                this.classesNotLoaded.add(packageInfo.getName());
            }
        }
        return packages;
    }

    @Override
    public List<Class> findAnnotatedClasses(Class<? extends Annotation> annotation) {
        this.classesNotLoaded.clear();
        ArrayList<Class> classes = new ArrayList<Class>();
        List<ClassFinder.Info> infos = this.getAnnotationInfos(annotation.getName());
        for (ClassFinder.Info info : infos) {
            if (!(info instanceof ClassFinder.ClassInfo)) continue;
            ClassFinder.ClassInfo classInfo = (ClassFinder.ClassInfo)info;
            try {
                Class clazz = classInfo.get();
                if (!clazz.isAnnotationPresent(annotation)) continue;
                classes.add(clazz);
            }
            catch (Throwable e) {
                if (LOG.isErrorEnabled()) {
                    LOG.error("Error loading class [#0]", e, classInfo.getName());
                }
                this.classesNotLoaded.add(classInfo.getName());
            }
        }
        return classes;
    }

    @Override
    public List<Method> findAnnotatedMethods(Class<? extends Annotation> annotation) {
        this.classesNotLoaded.clear();
        ArrayList<ClassFinder.ClassInfo> seen = new ArrayList<ClassFinder.ClassInfo>();
        ArrayList<Method> methods = new ArrayList<Method>();
        List<ClassFinder.Info> infos = this.getAnnotationInfos(annotation.getName());
        for (ClassFinder.Info info : infos) {
            ClassFinder.MethodInfo methodInfo;
            ClassFinder.ClassInfo classInfo;
            if (!(info instanceof ClassFinder.MethodInfo) || "<init>".equals(info.getName()) || seen.contains(classInfo = (methodInfo = (ClassFinder.MethodInfo)info).getDeclaringClass())) continue;
            seen.add(classInfo);
            try {
                Class clazz = classInfo.get();
                for (Method method : clazz.getDeclaredMethods()) {
                    if (!method.isAnnotationPresent(annotation)) continue;
                    methods.add(method);
                }
            }
            catch (Throwable e) {
                if (LOG.isErrorEnabled()) {
                    LOG.error("Error loading class [#0]", e, classInfo.getName());
                }
                this.classesNotLoaded.add(classInfo.getName());
            }
        }
        return methods;
    }

    @Override
    public List<Constructor> findAnnotatedConstructors(Class<? extends Annotation> annotation) {
        this.classesNotLoaded.clear();
        ArrayList<ClassFinder.ClassInfo> seen = new ArrayList<ClassFinder.ClassInfo>();
        ArrayList<Constructor> constructors = new ArrayList<Constructor>();
        List<ClassFinder.Info> infos = this.getAnnotationInfos(annotation.getName());
        for (ClassFinder.Info info : infos) {
            ClassFinder.MethodInfo methodInfo;
            ClassFinder.ClassInfo classInfo;
            if (!(info instanceof ClassFinder.MethodInfo) || !"<init>".equals(info.getName()) || seen.contains(classInfo = (methodInfo = (ClassFinder.MethodInfo)info).getDeclaringClass())) continue;
            seen.add(classInfo);
            try {
                Class clazz = classInfo.get();
                for (Constructor<?> constructor : clazz.getConstructors()) {
                    if (!constructor.isAnnotationPresent(annotation)) continue;
                    constructors.add(constructor);
                }
            }
            catch (Throwable e) {
                if (LOG.isErrorEnabled()) {
                    LOG.error("Error loading class [#0]", e, classInfo.getName());
                }
                this.classesNotLoaded.add(classInfo.getName());
            }
        }
        return constructors;
    }

    @Override
    public List<Field> findAnnotatedFields(Class<? extends Annotation> annotation) {
        this.classesNotLoaded.clear();
        ArrayList<ClassFinder.ClassInfo> seen = new ArrayList<ClassFinder.ClassInfo>();
        ArrayList<Field> fields = new ArrayList<Field>();
        List<ClassFinder.Info> infos = this.getAnnotationInfos(annotation.getName());
        for (ClassFinder.Info info : infos) {
            ClassFinder.FieldInfo fieldInfo;
            ClassFinder.ClassInfo classInfo;
            if (!(info instanceof ClassFinder.FieldInfo) || seen.contains(classInfo = (fieldInfo = (ClassFinder.FieldInfo)info).getDeclaringClass())) continue;
            seen.add(classInfo);
            try {
                Class clazz = classInfo.get();
                for (Field field : clazz.getDeclaredFields()) {
                    if (!field.isAnnotationPresent(annotation)) continue;
                    fields.add(field);
                }
            }
            catch (Throwable e) {
                if (LOG.isErrorEnabled()) {
                    LOG.error("Error loading class [#0]", e, classInfo.getName());
                }
                this.classesNotLoaded.add(classInfo.getName());
            }
        }
        return fields;
    }

    @Override
    public List<Class> findClassesInPackage(String packageName, boolean recursive) {
        this.classesNotLoaded.clear();
        ArrayList<Class> classes = new ArrayList<Class>();
        for (ClassFinder.ClassInfo classInfo : this.classInfos.values()) {
            try {
                if (recursive && classInfo.getPackageName().startsWith(packageName)) {
                    classes.add(classInfo.get());
                    continue;
                }
                if (!classInfo.getPackageName().equals(packageName)) continue;
                classes.add(classInfo.get());
            }
            catch (Throwable e) {
                if (LOG.isErrorEnabled()) {
                    LOG.error("Error loading class [#0]", e, classInfo.getName());
                }
                this.classesNotLoaded.add(classInfo.getName());
            }
        }
        return classes;
    }

    @Override
    public List<Class> findClasses(Test<ClassFinder.ClassInfo> test) {
        this.classesNotLoaded.clear();
        ArrayList<Class> classes = new ArrayList<Class>();
        for (ClassFinder.ClassInfo classInfo : this.classInfos.values()) {
            try {
                if (!test.test(classInfo)) continue;
                classes.add(classInfo.get());
            }
            catch (Throwable e) {
                if (LOG.isErrorEnabled()) {
                    LOG.error("Error loading class [#0]", e, classInfo.getName());
                }
                this.classesNotLoaded.add(classInfo.getName());
            }
        }
        return classes;
    }

    @Override
    public List<Class> findClasses() {
        this.classesNotLoaded.clear();
        ArrayList<Class> classes = new ArrayList<Class>();
        for (ClassFinder.ClassInfo classInfo : this.classInfos.values()) {
            try {
                classes.add(classInfo.get());
            }
            catch (Throwable e) {
                if (LOG.isErrorEnabled()) {
                    LOG.error("Error loading class [#0]", e, classInfo.getName());
                }
                this.classesNotLoaded.add(classInfo.getName());
            }
        }
        return classes;
    }

    private static List<URL> getURLs(ClassLoaderInterface classLoader, String[] dirNames) {
        ArrayList<URL> urls = new ArrayList<URL>();
        for (String dirName : dirNames) {
            try {
                Enumeration<URL> classLoaderURLs = classLoader.getResources(dirName);
                while (classLoaderURLs.hasMoreElements()) {
                    URL url = classLoaderURLs.nextElement();
                    urls.add(url);
                }
            }
            catch (IOException ioe) {
                if (!LOG.isErrorEnabled()) continue;
                LOG.error("Could not read driectory [#0]", ioe, dirName);
            }
        }
        return urls;
    }

    private List<String> file(URL location) {
        ArrayList<String> classNames = new ArrayList<String>();
        File dir = new File(URLDecoder.decode(location.getPath()));
        if ("META-INF".equals(dir.getName())) {
            dir = dir.getParentFile();
        }
        if (dir.isDirectory()) {
            this.scanDir(dir, classNames, "");
        }
        return classNames;
    }

    private void scanDir(File dir, List<String> classNames, String packageName) {
        File[] files;
        for (File file : files = dir.listFiles()) {
            if (file.isDirectory()) {
                this.scanDir(file, classNames, packageName + file.getName() + ".");
                continue;
            }
            if (!file.getName().endsWith(".class")) continue;
            String name = file.getName();
            name = name.replaceFirst(".class$", "");
            classNames.add(StringUtils.removeStart((String)packageName, (String)"WEB-INF.classes.") + name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> jar(URL location) throws IOException {
        URL url = this.fileManager.normalizeToFileProtocol(location);
        if (url != null) {
            InputStream in = url.openStream();
            try {
                JarInputStream jarStream = new JarInputStream(in);
                List<String> list = this.jar(jarStream);
                return list;
            }
            finally {
                in.close();
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Unable to read [#0]", location.toExternalForm());
        }
        return Collections.emptyList();
    }

    private List<String> jar(JarInputStream jarStream) throws IOException {
        JarEntry entry;
        ArrayList<String> classNames = new ArrayList<String>();
        while ((entry = jarStream.getNextJarEntry()) != null) {
            if (entry.isDirectory() || !entry.getName().endsWith(".class")) continue;
            String className = entry.getName();
            className = className.replaceFirst(".class$", "");
            className = StringUtils.removeStart((String)className, (String)"WEB-INF/classes/");
            className = className.replace('/', '.');
            classNames.add(className);
        }
        return classNames;
    }

    private List<ClassFinder.Info> getAnnotationInfos(String name) {
        List<ClassFinder.Info> infos = this.annotated.get(name);
        if (infos == null) {
            infos = new ArrayList<ClassFinder.Info>();
            this.annotated.put(name, infos);
        }
        return infos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readClassDef(String className) {
        block7: {
            if (!className.endsWith(".class")) {
                className = className.replace('.', '/') + ".class";
            }
            try {
                URL resource = this.classLoaderInterface.getResource(className);
                if (resource != null) {
                    InputStream in = resource.openStream();
                    try {
                        ClassReader classReader = new ClassReader(in);
                        classReader.accept((ClassVisitor)new InfoBuildingVisitor(this), 2);
                        break block7;
                    }
                    finally {
                        in.close();
                    }
                }
                throw new XWorkException("Could not load " + className);
            }
            catch (IOException e) {
                throw new XWorkException("Could not load " + className, e);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class DefaultClassnameFilterImpl
    implements Test<String> {
        private DefaultClassnameFilterImpl() {
        }

        @Override
        public boolean test(String className) {
            return true;
        }
    }

    public class InfoBuildingVisitor
    extends EmptyVisitor {
        private ClassFinder.Info info;
        private ClassFinder classFinder;

        public InfoBuildingVisitor(ClassFinder classFinder) {
            this.classFinder = classFinder;
        }

        public InfoBuildingVisitor(ClassFinder.Info info, ClassFinder classFinder) {
            this.info = info;
            this.classFinder = classFinder;
        }

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            if (name.endsWith("package-info")) {
                this.info = new PackageInfo(this.javaName(name), this.classFinder);
            } else {
                ClassFinder.ClassInfo classInfo = new ClassFinder.ClassInfo(this.javaName(name), this.javaName(superName), this.classFinder);
                for (String interfce : interfaces) {
                    classInfo.getInterfaces().add(this.javaName(interfce));
                }
                this.info = classInfo;
                DefaultClassFinder.this.classInfos.put(classInfo.getName(), classInfo);
                if (DefaultClassFinder.this.extractBaseInterfaces) {
                    this.extractSuperInterfaces(classInfo);
                }
            }
        }

        private void extractSuperInterfaces(ClassFinder.ClassInfo classInfo) {
            String superType = classInfo.getSuperType();
            if (superType != null) {
                ClassFinder.ClassInfo base = (ClassFinder.ClassInfo)DefaultClassFinder.this.classInfos.get(superType);
                if (base == null) {
                    String resource = superType.replace('.', '/') + ".class";
                    DefaultClassFinder.this.readClassDef(resource);
                    base = (ClassFinder.ClassInfo)DefaultClassFinder.this.classInfos.get(superType);
                }
                if (base != null) {
                    List<String> interfaces = classInfo.getSuperInterfaces();
                    interfaces.addAll(base.getSuperInterfaces());
                    interfaces.addAll(base.getInterfaces());
                }
            }
        }

        private String javaName(String name) {
            return name == null ? null : name.replace('/', '.');
        }

        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            ClassFinder.AnnotationInfo annotationInfo = new ClassFinder.AnnotationInfo(desc);
            this.info.getAnnotations().add(annotationInfo);
            DefaultClassFinder.this.getAnnotationInfos(annotationInfo.getName()).add(this.info);
            return new InfoBuildingVisitor(annotationInfo, this.classFinder);
        }

        public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
            ClassFinder.ClassInfo classInfo = (ClassFinder.ClassInfo)this.info;
            ClassFinder.FieldInfo fieldInfo = new ClassFinder.FieldInfo(classInfo, name, desc);
            classInfo.getFields().add(fieldInfo);
            return new InfoBuildingVisitor(fieldInfo, this.classFinder);
        }

        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            ClassFinder.ClassInfo classInfo = (ClassFinder.ClassInfo)this.info;
            ClassFinder.MethodInfo methodInfo = new ClassFinder.MethodInfo(classInfo, name, desc);
            classInfo.getMethods().add(methodInfo);
            return new InfoBuildingVisitor(methodInfo, this.classFinder);
        }

        public AnnotationVisitor visitParameterAnnotation(int param, String desc, boolean visible) {
            ClassFinder.MethodInfo methodInfo = (ClassFinder.MethodInfo)this.info;
            List<ClassFinder.AnnotationInfo> annotationInfos = methodInfo.getParameterAnnotations(param);
            ClassFinder.AnnotationInfo annotationInfo = new ClassFinder.AnnotationInfo(desc);
            annotationInfos.add(annotationInfo);
            return new InfoBuildingVisitor(annotationInfo, this.classFinder);
        }
    }

    public class PackageInfo
    extends ClassFinder.Annotatable
    implements ClassFinder.Info {
        private final String name;
        private final ClassFinder.ClassInfo info;
        private final Package pkg;

        public PackageInfo(Package pkg) {
            super(pkg);
            this.pkg = pkg;
            this.name = pkg.getName();
            this.info = null;
        }

        public PackageInfo(String name, ClassFinder classFinder) {
            this.info = new ClassFinder.ClassInfo(name, null, classFinder);
            this.name = name;
            this.pkg = null;
        }

        public String getName() {
            return this.name;
        }

        public Package get() throws ClassNotFoundException {
            return this.pkg != null ? this.pkg : this.info.get().getPackage();
        }
    }
}

