/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service.genericformat.importactions;

import fr.ifremer.tutti.persistence.entities.CaracteristicMap;
import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.service.genericformat.GenericFormatCsvFileResult;
import fr.ifremer.tutti.service.genericformat.GenericFormatImportContext;
import fr.ifremer.tutti.service.genericformat.GenericFormatImportOperationContext;
import fr.ifremer.tutti.service.genericformat.GenericformatImportPersistenceHelper;
import fr.ifremer.tutti.service.genericformat.consumer.CsvConsumerForParameter;
import fr.ifremer.tutti.service.genericformat.importactions.ImportActionSupport;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.csv.ImportRow;
import org.nuiton.csv.ImportRuntimeException;
import org.nuiton.i18n.I18n;
import org.nuiton.jaxx.application.ApplicationTechnicalException;

public class ImportParameterAction
extends ImportActionSupport {
    private static final Log log = LogFactory.getLog(ImportParameterAction.class);
    private final GenericformatImportPersistenceHelper persistenceHelper;

    public ImportParameterAction(GenericFormatImportContext importContext, GenericformatImportPersistenceHelper persistenceHelper) {
        super(importContext);
        this.persistenceHelper = persistenceHelper;
    }

    @Override
    protected boolean canExecute() {
        return this.importContext.isTechnicalFilesValid() && this.importContext.getSurveyFileResult().isValid() && this.importContext.getOperationFileResult().isValid();
    }

    @Override
    protected void skipExecute() {
        this.importContext.increments(I18n.t((String)"tutti.service.genericFormat.skip.import.parameters", (Object[])new Object[0]));
    }

    @Override
    protected void doExecute() {
        if (log.isInfoEnabled()) {
            log.info((Object)"Import parameter.csv file.");
        }
        this.importContext.increments(I18n.t((String)"tutti.service.genericFormat.import.parameters", (Object[])new Object[0]));
        GenericFormatCsvFileResult importFileResult = this.importContext.getParameterFileResult();
        try (CsvConsumerForParameter consumer = this.importContext.loadParameters(true);){
            for (ImportRow row : consumer) {
                GenericFormatImportOperationContext operationContext = consumer.validateRow(row, this.importContext);
                if (operationContext == null) continue;
                consumer.prepareRowForPersist(operationContext, row);
            }
        }
        catch (IOException e) {
            throw new ApplicationTechnicalException("Could not close parameter.csv file", (Throwable)e);
        }
        catch (ImportRuntimeException e) {
            importFileResult.addGlobalError(e.getMessage());
        }
        this.persistFishingOperationParameters();
    }

    public void persistFishingOperationParameters() {
        this.importContext.doActionOnCruiseContexts((cruiseContext, progressionModel) -> {
            boolean updateOperations = this.importContext.getImportRequest().isUpdateOperations();
            for (GenericFormatImportOperationContext fishingOperationContext : cruiseContext) {
                String cruiseStr = cruiseContext.getCruiseLabel();
                String operationStr = fishingOperationContext.getFishingOperationLabel();
                this.importContext.increments(I18n.t((String)"tutti.service.genericFormat.persist.operation.parameters", (Object[])new Object[]{cruiseStr, operationStr}));
                if (!updateOperations) continue;
                boolean persist = false;
                FishingOperation fishingOperation = fishingOperationContext.getFishingOperation();
                if (fishingOperationContext.withGearFeatures()) {
                    CaracteristicMap gearUseFeatures = fishingOperationContext.getGearUseFeatures();
                    fishingOperation.setGearUseFeatures(gearUseFeatures);
                    if (log.isInfoEnabled()) {
                        log.info((Object)("Persist " + gearUseFeatures.size() + " gear use features of " + operationStr + " for cruise: " + cruiseStr));
                    }
                    persist = true;
                }
                if (fishingOperationContext.withVesselFeatures()) {
                    CaracteristicMap vesselUseFeatures = fishingOperationContext.getVesselUseFeatures();
                    fishingOperation.setVesselUseFeatures(vesselUseFeatures);
                    if (log.isInfoEnabled()) {
                        log.info((Object)("Persist " + vesselUseFeatures.size() + " vessel use features of " + operationStr + " for cruise: " + cruiseStr));
                    }
                    persist = true;
                }
                if (!persist) continue;
                this.persistenceHelper.saveFishingOperation(fishingOperation);
            }
        });
    }
}

