/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.operation.catches.species.edit;

import fr.ifremer.tutti.persistence.entities.data.SpeciesBatch;
import fr.ifremer.tutti.service.TuttiDecorator;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.edit.SpeciesSortMode;
import java.util.List;
import org.nuiton.decorator.JXPathDecorator;

public class SpeciesBatchDecoratorComparator<R extends SpeciesBatch>
extends TuttiDecorator.TuttiDecoratorComparator<R> {
    private static final long serialVersionUID = 1L;
    SpeciesSortMode speciesSortMode;
    int sortSign;

    public void setSpeciesSortMode(SpeciesSortMode speciesSortMode) {
        this.speciesSortMode = speciesSortMode;
        this.sortSign = speciesSortMode == SpeciesSortMode.DESC ? -1 : 1;
    }

    public SpeciesBatchDecoratorComparator(String expression) {
        super(expression);
    }

    public void init(JXPathDecorator<R> decorator, List<R> datas) {
        this.clear();
        int index = 0;
        for (SpeciesBatch data : datas) {
            String speciesText = decorator.toString((Object)data);
            RowComparatorContext value = new RowComparatorContext(speciesText, index++);
            this.valueCache.put(data, value);
        }
    }

    class RowComparatorContext
    implements Comparable<RowComparatorContext> {
        private final String speciesText;
        private final int rowIndex;

        RowComparatorContext(String speciesText, int rowIndex) {
            this.speciesText = speciesText;
            this.rowIndex = rowIndex;
        }

        @Override
        public int compareTo(RowComparatorContext o) {
            int result = SpeciesBatchDecoratorComparator.this.sortSign * this.speciesText.compareTo(o.speciesText);
            if (result == 0) {
                result = this.rowIndex - o.rowIndex;
            }
            return result;
        }
    }
}

