/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.operation.catches.species.edit.actions;

import com.google.common.base.Preconditions;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.EditSpeciesBatchPanelUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.edit.SpeciesBatchRowModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.edit.SpeciesBatchTableModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.edit.SpeciesBatchUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.edit.SpeciesBatchUIHandler;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.split.SplitSpeciesBatchUI;
import fr.ifremer.tutti.ui.swing.util.actions.SimpleActionSupport;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import jaxx.runtime.SwingUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTable;
import org.nuiton.i18n.I18n;

public class OpenSplitSpeciesBatchUIAction
extends SimpleActionSupport<SpeciesBatchUI> {
    private static final Log log = LogFactory.getLog(OpenSplitSpeciesBatchUIAction.class);
    private static final long serialVersionUID = -6540241422935319461L;

    public OpenSplitSpeciesBatchUIAction(SpeciesBatchUI ui) {
        super(ui);
    }

    @Override
    protected void onActionPerformed(SpeciesBatchUI ui) {
        JXTable table = ui.getTable();
        int rowIndex = SwingUtil.getSelectedModelRow((JTable)table);
        Preconditions.checkState((rowIndex != -1 ? 1 : 0) != 0, (Object)"Cant split batch if no batch selected");
        SpeciesBatchUIHandler handler = ui.getHandler();
        SpeciesBatchTableModel tableModel = handler.getTableModel();
        SpeciesBatchRowModel parentBatch = (SpeciesBatchRowModel)tableModel.getEntry(rowIndex);
        boolean split = true;
        if (parentBatch.getWeight() != null) {
            String htmlMessage = String.format("<html>%s<hr/><br/>%s</html>", I18n.t((String)"tutti.editSpeciesBatch.split.weightNotNull.message", (Object[])new Object[0]), I18n.t((String)"tutti.editSpeciesBatch.split.weightNotNull.help", (Object[])new Object[0]));
            int i = JOptionPane.showConfirmDialog(handler.getTopestUI(), htmlMessage, I18n.t((String)"tutti.editSpeciesBatch.split.weightNotNull.title", (Object[])new Object[0]), 2);
            if (i == 0) {
                parentBatch.setWeight(null);
            } else {
                split = false;
            }
        }
        if (split) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Open split batch ui for row [" + rowIndex + ']'));
            }
            EditSpeciesBatchPanelUI parentUI = ui.getParentContainer(EditSpeciesBatchPanelUI.class);
            SplitSpeciesBatchUI splitBatchEditor = parentUI.getSplitBatchUI();
            splitBatchEditor.getHandler().editBatch(parentBatch);
            parentUI.switchToSplitBatch();
            String title = handler.buildReminderLabelTitle(parentBatch.getSpecies(), parentBatch, parentUI.getEditBatchesUIPanel().getTitle(), I18n.t((String)"tutti.splitSpeciesBatch.title", (Object[])new Object[0]));
            parentUI.getSplitBatchUIPanel().setTitle(title);
        }
    }
}

