/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.nLayout.area.impl;

import com.ibm.icu.text.ArabicShaping;
import com.ibm.icu.text.ArabicShapingException;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IStyle;
import org.eclipse.birt.report.engine.content.ITextContent;
import org.eclipse.birt.report.engine.layout.pdf.font.FontInfo;
import org.eclipse.birt.report.engine.layout.pdf.util.PropertyUtil;
import org.eclipse.birt.report.engine.nLayout.LayoutContext;
import org.eclipse.birt.report.engine.nLayout.area.ILayout;
import org.eclipse.birt.report.engine.nLayout.area.impl.AbstractArea;
import org.eclipse.birt.report.engine.nLayout.area.impl.ContainerArea;
import org.eclipse.birt.report.engine.nLayout.area.impl.ITextListener;
import org.eclipse.birt.report.engine.nLayout.area.impl.InlineStackingArea;
import org.eclipse.birt.report.engine.nLayout.area.impl.LineArea;
import org.eclipse.birt.report.engine.nLayout.area.impl.TextArea;
import org.eclipse.birt.report.engine.nLayout.area.impl.TextCompositor;
import org.eclipse.birt.report.engine.nLayout.area.style.TextStyle;
import org.w3c.dom.css.CSSValue;

public class TextAreaLayout
implements ILayout {
    protected static Logger logger = Logger.getLogger(TextAreaLayout.class.getName());
    private InlineStackingArea parentLM;
    private TextCompositor comp = null;
    private ITextContent textContent = null;
    private static HashSet splitChar = new HashSet();
    private ArrayList<ITextListener> listenerList = null;
    private boolean blankText = false;

    static {
        splitChar.add(Character.valueOf(' '));
        splitChar.add(Character.valueOf('\r'));
        splitChar.add(Character.valueOf('\n'));
    }

    public TextAreaLayout(ContainerArea parent, LayoutContext context, IContent content) {
        this.parentLM = (InlineStackingArea)parent;
        ITextContent textContent = (ITextContent)content;
        this.parentLM.setTextIndent(textContent);
        String text = textContent.getText();
        if (text != null && text.length() != 0) {
            this.transform(textContent);
        } else {
            textContent.setText(" ");
            this.blankText = true;
        }
        this.textContent = textContent;
        this.comp = new TextCompositor(textContent, context.getFontManager(), context, this.blankText);
        boolean isEmptyLine = this.isEmptyLine();
        this.comp.setNewLineStatus(isEmptyLine);
    }

    protected boolean isEmptyLine() {
        ContainerArea p = this.parentLM;
        while (!(p instanceof LineArea)) {
            if (p.getChildrenCount() > 0) {
                return false;
            }
            p = p.getParent();
        }
        return p.getChildrenCount() == 0;
    }

    protected LineArea getLineParent() {
        ContainerArea ancestor = this.parentLM;
        while (!(ancestor instanceof LineArea)) {
            ancestor = ancestor.getParent();
        }
        return (LineArea)ancestor;
    }

    public void addListener(ITextListener listener) {
        if (this.listenerList == null) {
            this.listenerList = new ArrayList();
        }
        this.listenerList.add(listener);
    }

    public static TextStyle buildTextStyle(IContent content, FontInfo fontInfo) {
        IStyle style = content.getComputedStyle();
        TextStyle textStyle = new TextStyle(fontInfo);
        CSSValue direction = style.getProperty(5);
        if (IStyle.RTL_VALUE.equals(direction)) {
            textStyle.setDirection(41);
        }
        textStyle.setFontSize(PropertyUtil.getDimensionValue(style.getProperty(39)));
        textStyle.setLetterSpacing(PropertyUtil.getDimensionValue(style.getProperty(44)));
        textStyle.setWordSpacing(PropertyUtil.getDimensionValue(style.getProperty(59)));
        textStyle.setLineThrough(style.getProperty(27) == IStyle.LINE_THROUGH_VALUE);
        textStyle.setOverLine(style.getProperty(34) == IStyle.OVERLINE_VALUE);
        CSSValue underLine = style.getProperty(58);
        if (underLine == IStyle.UNDERLINE_VALUE) {
            textStyle.setUnderLine(true);
        }
        textStyle.setAlign(style.getProperty(23));
        IStyle s = content.getStyle();
        Color color = PropertyUtil.getColor(s.getProperty(0));
        if (color != null) {
            textStyle.setColor(color);
        } else if (content.getHyperlinkAction() != null) {
            textStyle.setColor(Color.BLUE);
        } else {
            textStyle.setColor(PropertyUtil.getColor(style.getProperty(0)));
        }
        if (content.getHyperlinkAction() != null) {
            textStyle.setHasHyperlink(true);
        }
        return textStyle;
    }

    @Override
    public void layout() throws BirtException {
        this.layoutChildren();
    }

    /*
     * Unable to fully structure code
     */
    protected void layoutChildren() throws BirtException {
        if (this.textContent != null) ** GOTO lbl10
        return;
lbl-1000:
        // 1 sources

        {
            area = this.comp.getNextArea(this.getFreeSpace());
            if (area == null) continue;
            this.addTextArea(area);
            this.comp.setNewLineStatus(false);
            if (!area.isLineBreak()) continue;
            this.newLine(area.blankLine);
            this.comp.setNewLineStatus(true);
lbl10:
            // 4 sources

            ** while (this.comp.hasNextArea())
        }
lbl11:
        // 1 sources

    }

    protected boolean checkAvailableSpace() {
        return false;
    }

    public void addTextArea(AbstractArea textArea) throws BirtException {
        this.parentLM.add(textArea);
        textArea.setParent(this.parentLM);
        this.parentLM.update(textArea);
        if (this.listenerList != null) {
            for (ITextListener listener : this.listenerList) {
                listener.onAddEvent((TextArea)textArea);
            }
        }
    }

    public void newLine(boolean endParagraph) throws BirtException {
        this.parentLM.endLine(endParagraph);
        if (this.listenerList != null) {
            for (ITextListener listener : this.listenerList) {
                listener.onNewLineEvent();
            }
        }
    }

    public int getFreeSpace() {
        return this.parentLM.getCurrentMaxContentWidth();
    }

    public void transform(ITextContent textContent) {
        String transformType = textContent.getComputedStyle().getTextTransform();
        if (transformType.equalsIgnoreCase("uppercase")) {
            textContent.setText(textContent.getText().toUpperCase());
        } else if (transformType.equalsIgnoreCase("lowercase")) {
            textContent.setText(textContent.getText().toLowerCase());
        } else if (transformType.equalsIgnoreCase("capitalize")) {
            textContent.setText(this.capitalize(textContent.getText()));
        }
        ArabicShaping shaping = new ArabicShaping(8);
        try {
            String shapingText = shaping.shape(textContent.getText());
            textContent.setText(shapingText);
        }
        catch (ArabicShapingException e) {
            logger.log(Level.WARNING, e.getMessage(), e);
        }
    }

    private String capitalize(String text) {
        boolean capitalizeNextChar = true;
        char[] array = text.toCharArray();
        int i = 0;
        while (i < array.length) {
            Character c = Character.valueOf(text.charAt(i));
            if (splitChar.contains(c)) {
                capitalizeNextChar = true;
            } else if (capitalizeNextChar) {
                array[i] = Character.toUpperCase(array[i]);
                capitalizeNextChar = false;
            }
            ++i;
        }
        return new String(array);
    }

    public void close() {
        if (this.listenerList != null) {
            for (ITextListener listener : this.listenerList) {
                listener.onTextEndEvent();
            }
        }
    }

    public void initialize() {
    }
}

