/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.gvt.text;

import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.text.CharacterIterator;
import java.text.StringCharacterIterator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.batik.gvt.text.GVTAttributedCharacterIterator;

public class GVTACIImpl
implements GVTAttributedCharacterIterator {
    private String simpleString;
    private Set allAttributes;
    private ArrayList mapList;
    private static int START_RUN = 2;
    private static int END_RUN = 3;
    private static int MID_RUN = 1;
    private static int SINGLETON = 0;
    private int[] charInRun;
    private CharacterIterator iter = null;
    private int currentIndex = -1;

    public GVTACIImpl() {
        this.simpleString = "";
        this.buildAttributeTables();
    }

    public GVTACIImpl(AttributedCharacterIterator attributedCharacterIterator) {
        this.buildAttributeTables(attributedCharacterIterator);
    }

    public void setString(String string) {
        this.simpleString = string;
        this.iter = new StringCharacterIterator(this.simpleString);
        this.buildAttributeTables();
    }

    public void setString(AttributedString attributedString) {
        this.iter = attributedString.getIterator();
        this.buildAttributeTables((AttributedCharacterIterator)this.iter);
    }

    public void setAttributeArray(GVTAttributedCharacterIterator.TextAttribute textAttribute, Object[] objectArray, int n, int n2) {
        n = Math.max(n, 0);
        n2 = Math.min(n2, this.simpleString.length());
        if (this.charInRun[n] == END_RUN) {
            this.charInRun[n - 1] = this.charInRun[n - 1] == MID_RUN ? END_RUN : SINGLETON;
        }
        if (this.charInRun[n2 + 1] == END_RUN) {
            this.charInRun[n2 + 1] = SINGLETON;
        } else if (this.charInRun[n2 + 1] == MID_RUN) {
            this.charInRun[n2 + 1] = START_RUN;
        }
        int n3 = n;
        while (n3 <= n2) {
            this.charInRun[n3] = SINGLETON;
            int n4 = Math.min(n3, objectArray.length - 1);
            ((Map)this.mapList.get(n3)).put(textAttribute, objectArray[n4]);
            ++n3;
        }
    }

    public Set getAllAttributeKeys() {
        return this.allAttributes;
    }

    public Object getAttribute(AttributedCharacterIterator.Attribute attribute) {
        return this.getAttributes().get(attribute);
    }

    public Map getAttributes() {
        return (Map)this.mapList.get(this.currentIndex);
    }

    public int getRunLimit() {
        int n = this.currentIndex;
        while (this.charInRun[++n] == MID_RUN) {
        }
        return n;
    }

    public int getRunLimit(AttributedCharacterIterator.Attribute attribute) {
        int n = this.currentIndex;
        Object v = this.getAttributes().get(attribute);
        if (v == null) {
            while (((Map)this.mapList.get(++n)).get(attribute) == null) {
            }
        } else {
            while (v.equals(((Map)this.mapList.get(++n)).get(attribute))) {
            }
        }
        return n;
    }

    public int getRunLimit(Set set) {
        int n = this.currentIndex;
        while (set.equals(this.mapList.get(++n))) {
        }
        return n;
    }

    public int getRunStart() {
        int n = this.currentIndex;
        while (this.charInRun[n] == MID_RUN) {
            --n;
        }
        return n;
    }

    /*
     * Unable to fully structure code
     */
    public int getRunStart(AttributedCharacterIterator.Attribute var1_1) {
        block4: {
            var2_2 = this.currentIndex - 1;
            var3_3 = this.getAttributes().get(var1_1);
            try {
                if (var3_3 != null) ** GOTO lbl10
                while (((Map)this.mapList.get(var2_2 - 1)).get(var1_1) == null) {
                    --var2_2;
                }
                break block4;
lbl-1000:
                // 1 sources

                {
                    --var2_2;
lbl10:
                    // 2 sources

                    ** while (var3_3.equals(((Map)this.mapList.get((int)(var2_2 - 1))).get((Object)var1_1)))
                }
lbl11:
                // 1 sources

            }
            catch (IndexOutOfBoundsException var4_4) {
                // empty catch block
            }
        }
        return var2_2;
    }

    public int getRunStart(Set set) {
        int n = this.currentIndex;
        try {
            while (set.equals(this.mapList.get(n - 1))) {
                --n;
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        return n;
    }

    public Object clone() {
        GVTACIImpl gVTACIImpl = new GVTACIImpl(this);
        return gVTACIImpl;
    }

    public char current() {
        return this.iter.current();
    }

    public char first() {
        return this.iter.first();
    }

    public int getBeginIndex() {
        return this.iter.getBeginIndex();
    }

    public int getEndIndex() {
        return this.iter.getEndIndex();
    }

    public int getIndex() {
        return this.iter.getIndex();
    }

    public char last() {
        return this.iter.last();
    }

    public char next() {
        return this.iter.next();
    }

    public char previous() {
        return this.iter.previous();
    }

    public char setIndex(int n) {
        return this.iter.setIndex(n);
    }

    private void buildAttributeTables() {
        this.allAttributes = new HashSet();
        this.mapList = new ArrayList(this.simpleString.length());
        this.charInRun = new int[this.simpleString.length()];
        int n = 0;
        while (n < this.charInRun.length) {
            this.charInRun[n] = SINGLETON;
            this.mapList.set(n, new HashMap());
            ++n;
        }
    }

    private void buildAttributeTables(AttributedCharacterIterator attributedCharacterIterator) {
        this.allAttributes = attributedCharacterIterator.getAllAttributeKeys();
        int n = attributedCharacterIterator.getEndIndex() - attributedCharacterIterator.getBeginIndex();
        this.mapList = new ArrayList(n);
        this.charInRun = new int[n];
        char c = attributedCharacterIterator.first();
        char[] cArray = new char[n];
        int n2 = 0;
        while (n2 < n) {
            cArray[n2] = c;
            this.charInRun[n2] = SINGLETON;
            this.mapList.set(n2, new HashMap<AttributedCharacterIterator.Attribute, Object>(attributedCharacterIterator.getAttributes()));
            c = attributedCharacterIterator.next();
            ++n2;
        }
        this.simpleString = new String(cArray);
    }

    public class TransformAttributeFilter
    implements GVTAttributedCharacterIterator.AttributeFilter {
        public AttributedCharacterIterator mutateAttributes(AttributedCharacterIterator attributedCharacterIterator) {
            return attributedCharacterIterator;
        }
    }
}

