package fr.ifremer.tutti.ui.swing.content.operation.catches;

/*
 * #%L
 * Tutti :: UI
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2016 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.ui.swing.TuttiHelpBroker;
import fr.ifremer.tutti.ui.swing.content.operation.FishingOperationsUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.accidental.AccidentalBatchUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.accidental.create.CreateAccidentalBatchUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.benthos.BenthosBatchUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.benthos.create.CreateBenthosBatchUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.benthos.frequency.BenthosFrequencyUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.benthos.split.SplitBenthosBatchUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.individualobservation.IndividualObservationBatchUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.individualobservation.create.CreateIndividualObservationBatchUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.marinelitter.MarineLitterBatchUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.marinelitter.create.CreateMarineLitterBatchUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.SpeciesBatchUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.create.CreateSpeciesBatchUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.SpeciesFrequencyUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.split.SplitSpeciesBatchUI;
import fr.ifremer.tutti.ui.swing.util.TuttiUI;
import fr.ifremer.tutti.ui.swing.util.TuttiUIUtil;
import fr.ifremer.tutti.ui.swing.util.attachment.ButtonAttachment;
import fr.ifremer.tutti.ui.swing.util.caracteristics.CaracteristicMapEditorUI;
import fr.ifremer.tutti.ui.swing.util.computable.ComputableDataEditor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.JAXXValidator;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.CardLayout2Ext;
import jaxx.runtime.swing.TabInfo;
import jaxx.runtime.swing.TabInfoPropertyChangeListener;
import jaxx.runtime.swing.Table;
import jaxx.runtime.swing.help.JAXXHelpUI;
import jaxx.runtime.validator.swing.SwingValidator;
import jaxx.runtime.validator.swing.SwingValidatorUtil;
import jaxx.runtime.validator.swing.meta.Validator;
import jaxx.runtime.validator.swing.meta.ValidatorField;
import jaxx.runtime.validator.swing.ui.ImageValidationUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTitledPanel;
import static org.nuiton.i18n.I18n.t;

public class EditCatchesUI extends JPanel implements JAXXHelpUI<TuttiHelpBroker>, TuttiUI<EditCatchesUIModel, EditCatchesUIHandler>, JAXXObject, JAXXValidator {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_ACCIDENTAL_TAB_FISHING_OPERATION_REMINDER_LABEL_RIGHT_DECORATION = "accidentalTabFishingOperationReminderLabel.rightDecoration";
    public static final String BINDING_BENTHOS_TAB_FISHING_OPERATION_REMINDER_LABEL_RIGHT_DECORATION = "benthosTabFishingOperationReminderLabel.rightDecoration";
    public static final String BINDING_CATCHES_CARACTERISTICS_ATTACHMENTS_BUTTON_ENABLED = "catchesCaracteristicsAttachmentsButton.enabled";
    public static final String BINDING_INDIVIDUAL_OBSERVATION_TAB_FISHING_OPERATION_REMINDER_LABEL_RIGHT_DECORATION = "individualObservationTabFishingOperationReminderLabel.rightDecoration";
    public static final String BINDING_MARINE_LITTER_TAB_FISHING_OPERATION_REMINDER_LABEL_RIGHT_DECORATION = "marineLitterTabFishingOperationReminderLabel.rightDecoration";
    public static final String BINDING_SAVE_BUTTON_ENABLED = "saveButton.enabled";
    public static final String BINDING_SPECIES_TAB_FISHING_OPERATION_REMINDER_LABEL_RIGHT_DECORATION = "speciesTabFishingOperationReminderLabel.rightDecoration";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAANVazXPcSBVve+1x7CRr4tiJHZJa26ld7E2QE3ZDJZvsEtuxK+PYsSvjsK64ltAj9cwo0UiK1HLGNZWtvXDhwMeFC4eFAzcuUNw4AVVwhoILxb9AURy4UvSHpJY0ra+Z5ECqMplI7/3e7321up/ml/8Eo64DFp7BTkdxPBPrbaRsrR4c7NafIRXfQ67q6Da2HMD/DA2D4UNwUguvuxhcPtym6iu++sq61bYtE5kR7dvbYMLFxwZyWwhhDC7FNVTXXamFt293bM8JUENSMtSf/ftfwz/Svvj5MAAdm7C7T1yZz9MSnoxsg2Fdw2CKWDqCKwY0m4SGo5tNwvc0vbZuQNd9CNvoBfgcjG2Dig0dAobBYnGXGQbT79gYnEWajtchVlvI3bfsPWgiA4PVhqPoDQe1kaNgD2Nd8XTFfUmYKKplYgKsWDZyINYtU1G5trIhkB5XbZvZqGAw2rY0irk5MOYOBRLA40fQ0DVIfMPgSizK4Q0fv0Y/vx1cFAgzro1UnTgO68zxbXhsEWaJ8uMY69DR+P1vbHRwBKNOmLesBAa9OS2ELrQhSSPa1jFGTqbkLFRVXSOQ0MiUu6ybmn6kax40dusuco5Y3DJVKnXHeo5IsJbTM7FP/3ufRHmNyQrld/yMkDBAlTihu1hXqdP7lmWsQYI6TQu04+Ns+Zep9ngIMtJGppeU3CHXfMn5UHKCSq6q1CcMzvTIU6nLofAi6tikCDZ1t0UkdoMieoTo1TXiEQWZ6QGpYtSmCO+FQFezgDYtp+a1IXYgh6Q6V+L6M3qbSu54Btb3LBenC3JD+YLvScO+ijFUWyRE2A3c+yg9px7WDQWGKgpXERjxyI9hXkMYnI8nFNbrSKN34jm9mFYYHGTBcprKM7I+P8eWzbE6ytbBvo4NjmZQnBsh3NvuUXMdmkfQ9ZeiqRiLUONmqDGZaGJ6+eM46NeESG9u26STkLMN61z1I/rxSah6Rqiu81UKg61+VjIfR6nxf9fo5cdVauWuKOSIMQdBjJhUHsUZqRYGnw5CU2VICgfs5bwRWl8Q1mu2oeNClKdlShg8HoSxS4EUBtfLdys0/XVhelXTarBtk0ci8bFpOceFuM/nAVC5h/RjV7RxpAAd9MJDpnpMH22Wk2dtLlUTg4NBwtUI0IKKDOF5xGqiwRJPOFmDCZFiDXYgGkyoDtZgPo6yxv+NJP+JaLCIsbwGO5A94gdvsIBmrMF6OT8VDSas5zWYoDwtU+qzwQLGkQbr5auJBhOmyzSY4D6fB0Dl2IcuGixSgEUaTFibS9Xss8GCcIkG86OVaLC2SJZsdyjpsqsJuWKt5oT65xL6Yb/t9+MnBzMYmLITQY5UBRYrRNJ2XvsJ2snNc6wH4cDUY42Y4sdxSOZS5r5bkrQbaQrFsve52IGnAYVpbPQTC4FqCVSlKrMVCcgXIa1rqbTyMixcSz3MxFLtvj73YjnP8/V7Ic+bUp6xne8OtLPWHeHzlRJYmYdntr1XY7tvRQ7D3fl+SGGq96wpKeD3Y1LFqvaHYm2LaYelutdPLgWUshp+jSTqx6HVd+NW8ypR0J1NU8TgswEpx2pOyv8n4hkq9MpUl/BjPg+Ayv2AfvxULG2cYTLD/BTukthIpiIkSAY/EGJwss4OlqyOAsxTKjRVZASn1LOxw5w49X4p155w4RESUr/IED2vGgia0Y1/Mb051WrbXvyIU0xzNu3gS55Y8khVzYYlJioTYmdPr/w6ckdsSRJ3JhOPwsTt2bR1NCF3OlblwU0HfDXGW3XJaTWcgoox5dAhGHU8cpkYPOwdnD4it/jIdDYxMqWA7O5/z53922//8ZvNYE76DrE9IxWNjHm3wYTt0A7DOjU9yYekdPVbIVV9+xCMu8hAKp8BX5QQq/m3CTlijw2V+OJ5H7otAjE69vff/eHcd//8FhjeBBOGBbVNSOWrpLhbDomCZWgd+1t3GaNTL0+Qz6+Qv6MYjEMPW3uW7dkYrHRb0NQMskg0ESbrXUNvLi0rursaiDz02nXk8C5cWn5F0m2yK/vHNony6e4msYwVlU5pX9HpRst6yfSCHrqWYqBGBKPYXJ5ZGKcgj5BLR90j2PGInZE6aRcMxrpsOvuqQ9J1UZKuMGb18T/952ztV3eDlA2REM6liou0jT4BFd00aNHS4TattbGUYfZJ20WeZon5tGxiDUiIT0Xd9Kv69+zzj7LsnPFbXLsHMVy3DPo8lWeJfSf3132FT5HebGGXx/D/LccdNiX9C8sV/fZXGrpp7hpdtWk0CoVwCINKi0UCg+Eb1yS4ti1ZIjPgRp+2kEF0LnUX+ZM0fAnB1l+F3l181WtI/rrCzuH/Fol43XLI03IP6uRBrRECDWiQSIGKZcMXrB14V4w3aGJodAIZGYm8WXgeoWE6i2eEyJeu6RkGrZA6VJ83HcszCb9vdqMPysfVHWjCZlANpECXFv2puSK0FpelEWMz9zxGI6Sp9Os3zR0TtS1TVzHwE4OJR3VihoKQzQzb27RDoWT4RjDqkCKZS9UlZUKv7uv2PpO8lG4F67bMnciLgQJ5H0MmTaZGS40tdDSC/FViVVtanl/4eN4Pf5zXFWlZ+szEKN2lLEnoGpbquYnikpEvOM3Pc4x00KRD+/EeUi2+ScNgoZtTldLqyJze98VjpdszMadBj+6vBKclec0Wndf3SbBn4kgJRkda+QQLzjv7InirK5/TUJY984lcqqWGRn3xfdDNmUxQ4umH7FwP+pug9OXKja7suEr5Jw5suaRLnJoLMK0Y/pvp813pK2spheSLsXJ2pK+15XYSomXsXEzWep4x6ay0jMUL3d6pR4Y9yYykiLXg8b7bXWPf+Eni2B8C8Lef/M4SXpJvggzURKYWmSAsLstLbTJG0SiybIfReDe1d/MCkz0ILROjJwPHSEolLVwX0ojnR67Ss01azdooZP2aILKLmnoKbdvQ1ci0BYNGt79xE5vVKBsZlrmF8PAxwXWqFBRUOOVwJ3ezX/fEHn81ZY9fJEb8HJDcnN3pGy9lT1ng9yPlK+NBvyzF70zyauTZG6gRYb1MnawN7qyomAf9V0wkdvLa2XwNyClVVOrHQ+Xr6cMs5onfHeUVzncGKpxq3Bhjk1ksnF1YLJmHq4Qnoio+zK6KZATk6V8pA5GSZ/mPvF5zQhO/D3uzCd3olExoovszE5rwpHBCkxHoI6FJiLSESn+Ml5fQsZ6EfpDFhb7JiFzNyefBQPmsxWxlZXKE0grz+H5xB0QaP8hOY8JveRaVEghs4iLmOlP+XEd3dyxNbxynHMcib5LKd+qtLHr8BddG/N4bbdd1icXMduUUwzRfK+uOSPat7GRLYyFPeebqJ8VJ6d7YG8byub2eyYO+U/RfAuTl9HCwnFJLzLZvLiuho4xXmM+loi6IPF7PyWPUb3n+rhbWT8lb2gvb8inMXHf9dz8Fk/jZYEnktoqm8QQ5u1Koggtw3JPCC3AiAH0swAmElHymv0gvM494+44GMZyv0zO62fykx9AQ/ZzIRSSXh8foxwk5wh2C8D82cLJWazQAAA==";
    private static final Log log = LogFactory.getLog(EditCatchesUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected CaracteristicMapEditorUI accidentalCaracteristicMapEditor;
    protected JXTitledPanel accidentalCaracteristicMapEditorReminderLabel;
    protected TabInfo accidentalTab;
    protected AccidentalBatchUI accidentalTabContent;
    protected CreateAccidentalBatchUI accidentalTabCreateBatch;
    protected JXTitledPanel accidentalTabCreateBatchReminderLabel;
    protected JXTitledPanel accidentalTabFishingOperationReminderLabel;
    protected JPanel accidentalTabPanel;
    protected CardLayout2Ext accidentalTabPanelLayout;
    protected TabInfo benthosTab;
    protected SplitBenthosBatchUI benthosTabAddSampleCategoryBatch;
    protected JXTitledPanel benthosTabAddSampleCategoryBatchReminderLabel;
    protected BenthosBatchUI benthosTabContent;
    protected CreateBenthosBatchUI benthosTabCreateBatch;
    protected JXTitledPanel benthosTabCreateBatchReminderLabel;
    protected JXTitledPanel benthosTabFishingOperationReminderLabel;
    protected BenthosFrequencyUI benthosTabFrequencyEditor;
    protected JXTitledPanel benthosTabFrequencyEditorReminderLabel;
    protected JPanel benthosTabPanel;
    protected CardLayout2Ext benthosTabPanelLayout;
    protected SplitBenthosBatchUI benthosTabSplitBatch;
    protected JXTitledPanel benthosTabSplitBatchReminderLabel;
    protected TuttiHelpBroker broker;
    protected JButton cancelButton;
    protected ButtonAttachment catchesCaracteristicsAttachmentsButton;
    protected TabInfo catchesCaracteristicsTab;
    protected JXTitledPanel catchesCaracteristicsTabPane;
    protected JToolBar catchesCaracteristicsTabToolBar;
    protected JButton cleanSpeciesBatchButton;
    protected JButton computeSpeciesBatchButton;
    protected Table createFishingOperationActions;
    protected EditCatchesUI editCatchesTopPanel = this;
    protected JMenuItem exportFishingOperationReportButton;
    protected JMenuItem exportFishingOperationReportForSumatraButton;
    protected JMenuItem exportMultiPostButton;
    protected final EditCatchesUIHandler handler = createHandler();
    protected JMenuItem importMultiPostButton;
    protected CaracteristicMapEditorUI individualObservationCaracteristicMapEditor;
    protected JXTitledPanel individualObservationCaracteristicMapEditorReminderLabel;
    protected TabInfo individualObservationTab;
    protected IndividualObservationBatchUI individualObservationTabContent;
    protected CreateIndividualObservationBatchUI individualObservationTabCreateBatch;
    protected JXTitledPanel individualObservationTabCreateBatchReminderLabel;
    protected JXTitledPanel individualObservationTabFishingOperationReminderLabel;
    protected JPanel individualObservationTabPanel;
    protected CardLayout2Ext individualObservationTabPanelLayout;
    protected TabInfo marineLitterTab;
    protected MarineLitterBatchUI marineLitterTabContent;
    protected CreateMarineLitterBatchUI marineLitterTabCreateBatch;
    protected JXTitledPanel marineLitterTabCreateBatchReminderLabel;
    protected JXTitledPanel marineLitterTabFishingOperationReminderLabel;
    protected JPanel marineLitterTabPanel;
    protected CardLayout2Ext marineLitterTabPanelLayout;
    protected JMenuBar menu;
    protected JMenu menuAction;
    protected EditCatchesUIModel model;
    protected JButton saveButton;
    protected TabInfo speciesTab;
    protected SplitSpeciesBatchUI speciesTabAddSampleCategoryBatch;
    protected JXTitledPanel speciesTabAddSampleCategoryBatchReminderLabel;
    protected SpeciesBatchUI speciesTabContent;
    protected CreateSpeciesBatchUI speciesTabCreateBatch;
    protected JXTitledPanel speciesTabCreateBatchReminderLabel;
    protected JXTitledPanel speciesTabFishingOperationReminderLabel;
    protected SpeciesFrequencyUI speciesTabFrequencyEditor;
    protected JXTitledPanel speciesTabFrequencyEditorReminderLabel;
    protected JPanel speciesTabPanel;
    protected CardLayout2Ext speciesTabPanelLayout;
    protected SplitSpeciesBatchUI speciesTabSplitBatch;
    protected JXTitledPanel speciesTabSplitBatchReminderLabel;
    protected JPanel svgCanvasPanel;
    protected JTabbedPane tabPane;
    @Validator( validatorId = "validator")
    protected SwingValidator<EditCatchesUIModel> validator;
    protected List<String> validatorIds = new ArrayList<String>();

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public EditCatchesUI(FishingOperationsUI parentUI) {
        TuttiUIUtil.setParentUI(this, parentUI);
            $initialize();
    }

    public EditCatchesUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public EditCatchesUI(JAXXContext parentContext, LayoutManager param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public EditCatchesUI(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public EditCatchesUI(JAXXContext parentContext, LayoutManager param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public EditCatchesUI() {
        $initialize();
    }

    public EditCatchesUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public EditCatchesUI(boolean param0) {
        super(param0);
        $initialize();
    }

    public EditCatchesUI(JAXXContext parentContext, boolean param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*-------------------- JAXXValidator implementation  --------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public SwingValidator<?> getValidator(String validatorId) {
        return (SwingValidator<?>) (validatorIds.contains(validatorId) ? getObjectById(validatorId) : null);
    }

    @Override
    public List<String> getValidatorIds() {
        return validatorIds;
    }

    @Override
    public void registerValidatorFields() {
        SwingValidatorUtil.detectValidatorFields(this);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public CaracteristicMapEditorUI getAccidentalCaracteristicMapEditor() {
        return accidentalCaracteristicMapEditor;
    }

    public JXTitledPanel getAccidentalCaracteristicMapEditorReminderLabel() {
        return accidentalCaracteristicMapEditorReminderLabel;
    }

    public TabInfo getAccidentalTab() {
        return accidentalTab;
    }

    public AccidentalBatchUI getAccidentalTabContent() {
        return accidentalTabContent;
    }

    public CreateAccidentalBatchUI getAccidentalTabCreateBatch() {
        return accidentalTabCreateBatch;
    }

    public JXTitledPanel getAccidentalTabCreateBatchReminderLabel() {
        return accidentalTabCreateBatchReminderLabel;
    }

    public JXTitledPanel getAccidentalTabFishingOperationReminderLabel() {
        return accidentalTabFishingOperationReminderLabel;
    }

    public JPanel getAccidentalTabPanel() {
        return accidentalTabPanel;
    }

    public CardLayout2Ext getAccidentalTabPanelLayout() {
        return accidentalTabPanelLayout;
    }

    public TabInfo getBenthosTab() {
        return benthosTab;
    }

    public SplitBenthosBatchUI getBenthosTabAddSampleCategoryBatch() {
        return benthosTabAddSampleCategoryBatch;
    }

    public JXTitledPanel getBenthosTabAddSampleCategoryBatchReminderLabel() {
        return benthosTabAddSampleCategoryBatchReminderLabel;
    }

    public BenthosBatchUI getBenthosTabContent() {
        return benthosTabContent;
    }

    public CreateBenthosBatchUI getBenthosTabCreateBatch() {
        return benthosTabCreateBatch;
    }

    public JXTitledPanel getBenthosTabCreateBatchReminderLabel() {
        return benthosTabCreateBatchReminderLabel;
    }

    public JXTitledPanel getBenthosTabFishingOperationReminderLabel() {
        return benthosTabFishingOperationReminderLabel;
    }

    public BenthosFrequencyUI getBenthosTabFrequencyEditor() {
        return benthosTabFrequencyEditor;
    }

    public JXTitledPanel getBenthosTabFrequencyEditorReminderLabel() {
        return benthosTabFrequencyEditorReminderLabel;
    }

    public JPanel getBenthosTabPanel() {
        return benthosTabPanel;
    }

    public CardLayout2Ext getBenthosTabPanelLayout() {
        return benthosTabPanelLayout;
    }

    public SplitBenthosBatchUI getBenthosTabSplitBatch() {
        return benthosTabSplitBatch;
    }

    public JXTitledPanel getBenthosTabSplitBatchReminderLabel() {
        return benthosTabSplitBatchReminderLabel;
    }

    public TuttiHelpBroker getBroker() {
        return broker;
    }

    public JButton getCancelButton() {
        return cancelButton;
    }

    public ButtonAttachment getCatchesCaracteristicsAttachmentsButton() {
        return catchesCaracteristicsAttachmentsButton;
    }

    public TabInfo getCatchesCaracteristicsTab() {
        return catchesCaracteristicsTab;
    }

    public JXTitledPanel getCatchesCaracteristicsTabPane() {
        return catchesCaracteristicsTabPane;
    }

    public JToolBar getCatchesCaracteristicsTabToolBar() {
        return catchesCaracteristicsTabToolBar;
    }

    public JButton getCleanSpeciesBatchButton() {
        return cleanSpeciesBatchButton;
    }

    public JButton getComputeSpeciesBatchButton() {
        return computeSpeciesBatchButton;
    }

    public Table getCreateFishingOperationActions() {
        return createFishingOperationActions;
    }

    public JMenuItem getExportFishingOperationReportButton() {
        return exportFishingOperationReportButton;
    }

    public JMenuItem getExportFishingOperationReportForSumatraButton() {
        return exportFishingOperationReportForSumatraButton;
    }

    public JMenuItem getExportMultiPostButton() {
        return exportMultiPostButton;
    }

    public EditCatchesUIHandler getHandler() {
        return handler;
    }

    public JMenuItem getImportMultiPostButton() {
        return importMultiPostButton;
    }

    public CaracteristicMapEditorUI getIndividualObservationCaracteristicMapEditor() {
        return individualObservationCaracteristicMapEditor;
    }

    public JXTitledPanel getIndividualObservationCaracteristicMapEditorReminderLabel() {
        return individualObservationCaracteristicMapEditorReminderLabel;
    }

    public TabInfo getIndividualObservationTab() {
        return individualObservationTab;
    }

    public IndividualObservationBatchUI getIndividualObservationTabContent() {
        return individualObservationTabContent;
    }

    public CreateIndividualObservationBatchUI getIndividualObservationTabCreateBatch() {
        return individualObservationTabCreateBatch;
    }

    public JXTitledPanel getIndividualObservationTabCreateBatchReminderLabel() {
        return individualObservationTabCreateBatchReminderLabel;
    }

    public JXTitledPanel getIndividualObservationTabFishingOperationReminderLabel() {
        return individualObservationTabFishingOperationReminderLabel;
    }

    public JPanel getIndividualObservationTabPanel() {
        return individualObservationTabPanel;
    }

    public CardLayout2Ext getIndividualObservationTabPanelLayout() {
        return individualObservationTabPanelLayout;
    }

    public TabInfo getMarineLitterTab() {
        return marineLitterTab;
    }

    public MarineLitterBatchUI getMarineLitterTabContent() {
        return marineLitterTabContent;
    }

    public CreateMarineLitterBatchUI getMarineLitterTabCreateBatch() {
        return marineLitterTabCreateBatch;
    }

    public JXTitledPanel getMarineLitterTabCreateBatchReminderLabel() {
        return marineLitterTabCreateBatchReminderLabel;
    }

    public JXTitledPanel getMarineLitterTabFishingOperationReminderLabel() {
        return marineLitterTabFishingOperationReminderLabel;
    }

    public JPanel getMarineLitterTabPanel() {
        return marineLitterTabPanel;
    }

    public CardLayout2Ext getMarineLitterTabPanelLayout() {
        return marineLitterTabPanelLayout;
    }

    public JMenuBar getMenu() {
        return menu;
    }

    public JMenu getMenuAction() {
        return menuAction;
    }

    public EditCatchesUIModel getModel() {
        return model;
    }

    public JButton getSaveButton() {
        return saveButton;
    }

    public TabInfo getSpeciesTab() {
        return speciesTab;
    }

    public SplitSpeciesBatchUI getSpeciesTabAddSampleCategoryBatch() {
        return speciesTabAddSampleCategoryBatch;
    }

    public JXTitledPanel getSpeciesTabAddSampleCategoryBatchReminderLabel() {
        return speciesTabAddSampleCategoryBatchReminderLabel;
    }

    public SpeciesBatchUI getSpeciesTabContent() {
        return speciesTabContent;
    }

    public CreateSpeciesBatchUI getSpeciesTabCreateBatch() {
        return speciesTabCreateBatch;
    }

    public JXTitledPanel getSpeciesTabCreateBatchReminderLabel() {
        return speciesTabCreateBatchReminderLabel;
    }

    public JXTitledPanel getSpeciesTabFishingOperationReminderLabel() {
        return speciesTabFishingOperationReminderLabel;
    }

    public SpeciesFrequencyUI getSpeciesTabFrequencyEditor() {
        return speciesTabFrequencyEditor;
    }

    public JXTitledPanel getSpeciesTabFrequencyEditorReminderLabel() {
        return speciesTabFrequencyEditorReminderLabel;
    }

    public JPanel getSpeciesTabPanel() {
        return speciesTabPanel;
    }

    public CardLayout2Ext getSpeciesTabPanelLayout() {
        return speciesTabPanelLayout;
    }

    public SplitSpeciesBatchUI getSpeciesTabSplitBatch() {
        return speciesTabSplitBatch;
    }

    public JXTitledPanel getSpeciesTabSplitBatchReminderLabel() {
        return speciesTabSplitBatchReminderLabel;
    }

    public JPanel getSvgCanvasPanel() {
        return svgCanvasPanel;
    }

    public JTabbedPane getTabPane() {
        return tabPane;
    }

    public SwingValidator<EditCatchesUIModel> getValidator() {
        return validator;
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Other methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void registerHelpId(TuttiHelpBroker broker, Component component, String helpId) {
        broker.installUI(component, helpId);
    }

    @Override
    public void showHelp(String helpId) {
        getBroker().showHelp(this, helpId);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToAccidentalCaracteristicMapEditorReminderLabel() {
        if (!allComponentsCreated) {
            return;
        }
        accidentalCaracteristicMapEditorReminderLabel.add(accidentalCaracteristicMapEditor);
    }

    protected void addChildrenToAccidentalTabCreateBatchReminderLabel() {
        if (!allComponentsCreated) {
            return;
        }
        accidentalTabCreateBatchReminderLabel.add(accidentalTabCreateBatch);
    }

    protected void addChildrenToAccidentalTabFishingOperationReminderLabel() {
        if (!allComponentsCreated) {
            return;
        }
        accidentalTabFishingOperationReminderLabel.add(accidentalTabContent);
    }

    protected void addChildrenToAccidentalTabPanel() {
        if (!allComponentsCreated) {
            return;
        }
        accidentalTabPanel.add(accidentalTabFishingOperationReminderLabel, EditCatchesUIHandler.MAIN_CARD);
        accidentalTabPanel.add(accidentalTabCreateBatchReminderLabel, EditCatchesUIHandler.CREATE_BATCH_CARD);
        accidentalTabPanel.add(accidentalCaracteristicMapEditorReminderLabel, EditCatchesUIHandler.EDIT_CARACTERISTICS_CARD);
    }

    protected void addChildrenToBenthosTabAddSampleCategoryBatchReminderLabel() {
        if (!allComponentsCreated) {
            return;
        }
        benthosTabAddSampleCategoryBatchReminderLabel.add(benthosTabAddSampleCategoryBatch);
    }

    protected void addChildrenToBenthosTabCreateBatchReminderLabel() {
        if (!allComponentsCreated) {
            return;
        }
        benthosTabCreateBatchReminderLabel.add(benthosTabCreateBatch);
    }

    protected void addChildrenToBenthosTabFishingOperationReminderLabel() {
        if (!allComponentsCreated) {
            return;
        }
        benthosTabFishingOperationReminderLabel.add(benthosTabContent);
    }

    protected void addChildrenToBenthosTabFrequencyEditorReminderLabel() {
        if (!allComponentsCreated) {
            return;
        }
        benthosTabFrequencyEditorReminderLabel.add(benthosTabFrequencyEditor);
    }

    protected void addChildrenToBenthosTabPanel() {
        if (!allComponentsCreated) {
            return;
        }
        benthosTabPanel.add(benthosTabFishingOperationReminderLabel, EditCatchesUIHandler.MAIN_CARD);
        benthosTabPanel.add(benthosTabCreateBatchReminderLabel, EditCatchesUIHandler.CREATE_BATCH_CARD);
        benthosTabPanel.add(benthosTabSplitBatchReminderLabel, EditCatchesUIHandler.SPLIT_BATCH_CARD);
        benthosTabPanel.add(benthosTabAddSampleCategoryBatchReminderLabel, EditCatchesUIHandler.ADD_SAMPLE_CATEGORY_BATCH_CARD);
        benthosTabPanel.add(benthosTabFrequencyEditorReminderLabel, EditCatchesUIHandler.EDIT_FREQUENCY_CARD);
    }

    protected void addChildrenToBenthosTabSplitBatchReminderLabel() {
        if (!allComponentsCreated) {
            return;
        }
        benthosTabSplitBatchReminderLabel.add(benthosTabSplitBatch);
    }

    protected void addChildrenToCatchesCaracteristicsTabPane() {
        if (!allComponentsCreated) {
            return;
        }
        catchesCaracteristicsTabPane.add(svgCanvasPanel);
    }

    protected void addChildrenToCatchesCaracteristicsTabToolBar() {
        if (!allComponentsCreated) {
            return;
        }
        catchesCaracteristicsTabToolBar.add(menu);
        catchesCaracteristicsTabToolBar.add(catchesCaracteristicsAttachmentsButton);
    }

    protected void addChildrenToCreateFishingOperationActions() {
        if (!allComponentsCreated) {
            return;
        }
        createFishingOperationActions.add(cancelButton, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        createFishingOperationActions.add(saveButton, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        createFishingOperationActions.add(cleanSpeciesBatchButton, new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        createFishingOperationActions.add(computeSpeciesBatchButton, new GridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    protected void addChildrenToEditCatchesTopPanel() {
        if (!allComponentsCreated) {
            return;
        }
        add(catchesCaracteristicsTabToolBar);
        add(tabPane, BorderLayout.CENTER);
        add(createFishingOperationActions, BorderLayout.SOUTH);
    }

    protected void addChildrenToIndividualObservationCaracteristicMapEditorReminderLabel() {
        if (!allComponentsCreated) {
            return;
        }
        individualObservationCaracteristicMapEditorReminderLabel.add(individualObservationCaracteristicMapEditor);
    }

    protected void addChildrenToIndividualObservationTabCreateBatchReminderLabel() {
        if (!allComponentsCreated) {
            return;
        }
        individualObservationTabCreateBatchReminderLabel.add(individualObservationTabCreateBatch);
    }

    protected void addChildrenToIndividualObservationTabFishingOperationReminderLabel() {
        if (!allComponentsCreated) {
            return;
        }
        individualObservationTabFishingOperationReminderLabel.add(individualObservationTabContent);
    }

    protected void addChildrenToIndividualObservationTabPanel() {
        if (!allComponentsCreated) {
            return;
        }
        individualObservationTabPanel.add(individualObservationTabFishingOperationReminderLabel, EditCatchesUIHandler.MAIN_CARD);
        individualObservationTabPanel.add(individualObservationTabCreateBatchReminderLabel, EditCatchesUIHandler.CREATE_BATCH_CARD);
        individualObservationTabPanel.add(individualObservationCaracteristicMapEditorReminderLabel, EditCatchesUIHandler.EDIT_CARACTERISTICS_CARD);
    }

    protected void addChildrenToMarineLitterTabCreateBatchReminderLabel() {
        if (!allComponentsCreated) {
            return;
        }
        marineLitterTabCreateBatchReminderLabel.add(marineLitterTabCreateBatch);
    }

    protected void addChildrenToMarineLitterTabFishingOperationReminderLabel() {
        if (!allComponentsCreated) {
            return;
        }
        marineLitterTabFishingOperationReminderLabel.add(marineLitterTabContent);
    }

    protected void addChildrenToMarineLitterTabPanel() {
        if (!allComponentsCreated) {
            return;
        }
        marineLitterTabPanel.add(marineLitterTabFishingOperationReminderLabel, EditCatchesUIHandler.MAIN_CARD);
        marineLitterTabPanel.add(marineLitterTabCreateBatchReminderLabel, EditCatchesUIHandler.CREATE_BATCH_CARD);
    }

    protected void addChildrenToMenu() {
        if (!allComponentsCreated) {
            return;
        }
        menu.add(menuAction);
    }

    protected void addChildrenToMenuAction() {
        if (!allComponentsCreated) {
            return;
        }
        menuAction.add(exportFishingOperationReportButton);
        menuAction.add(exportFishingOperationReportForSumatraButton);
        menuAction.add(importMultiPostButton);
        menuAction.add(exportMultiPostButton);
    }

    protected void addChildrenToSpeciesTabAddSampleCategoryBatchReminderLabel() {
        if (!allComponentsCreated) {
            return;
        }
        speciesTabAddSampleCategoryBatchReminderLabel.add(speciesTabAddSampleCategoryBatch);
    }

    protected void addChildrenToSpeciesTabCreateBatchReminderLabel() {
        if (!allComponentsCreated) {
            return;
        }
        speciesTabCreateBatchReminderLabel.add(speciesTabCreateBatch);
    }

    protected void addChildrenToSpeciesTabFishingOperationReminderLabel() {
        if (!allComponentsCreated) {
            return;
        }
        speciesTabFishingOperationReminderLabel.add(speciesTabContent);
    }

    protected void addChildrenToSpeciesTabFrequencyEditorReminderLabel() {
        if (!allComponentsCreated) {
            return;
        }
        speciesTabFrequencyEditorReminderLabel.add(speciesTabFrequencyEditor);
    }

    protected void addChildrenToSpeciesTabPanel() {
        if (!allComponentsCreated) {
            return;
        }
        speciesTabPanel.add(speciesTabFishingOperationReminderLabel, EditCatchesUIHandler.MAIN_CARD);
        speciesTabPanel.add(speciesTabCreateBatchReminderLabel, EditCatchesUIHandler.CREATE_BATCH_CARD);
        speciesTabPanel.add(speciesTabSplitBatchReminderLabel, EditCatchesUIHandler.SPLIT_BATCH_CARD);
        speciesTabPanel.add(speciesTabAddSampleCategoryBatchReminderLabel, EditCatchesUIHandler.ADD_SAMPLE_CATEGORY_BATCH_CARD);
        speciesTabPanel.add(speciesTabFrequencyEditorReminderLabel, EditCatchesUIHandler.EDIT_FREQUENCY_CARD);
    }

    protected void addChildrenToSpeciesTabSplitBatchReminderLabel() {
        if (!allComponentsCreated) {
            return;
        }
        speciesTabSplitBatchReminderLabel.add(speciesTabSplitBatch);
    }

    protected void addChildrenToTabPane() {
        if (!allComponentsCreated) {
            return;
        }
        tabPane.add(catchesCaracteristicsTabPane);
        tabPane.add(speciesTabPanel);
        tabPane.add(benthosTabPanel);
        tabPane.add(marineLitterTabPanel);
        tabPane.add(individualObservationTabPanel);
        tabPane.add(accidentalTabPanel);
        catchesCaracteristicsTab.addPropertyChangeListener(new TabInfoPropertyChangeListener(tabPane, 0));
        speciesTab.addPropertyChangeListener(new TabInfoPropertyChangeListener(tabPane, 1));
        benthosTab.addPropertyChangeListener(new TabInfoPropertyChangeListener(tabPane, 2));
        marineLitterTab.addPropertyChangeListener(new TabInfoPropertyChangeListener(tabPane, 3));
        tabPane.setTitleAt(3, t("tutti.label.tab.marineLitter"));
        individualObservationTab.addPropertyChangeListener(new TabInfoPropertyChangeListener(tabPane, 4));
        accidentalTab.addPropertyChangeListener(new TabInfoPropertyChangeListener(tabPane, 5));
    }

    protected void addChildrenToValidator() {
        if (!allComponentsCreated) {
            return;
        }
        validator.setUiClass(ImageValidationUI.class);
        validator.setBean(model);
    }

    protected void createAccidentalCaracteristicMapEditor() {
        $objectMap.put("accidentalCaracteristicMapEditor", accidentalCaracteristicMapEditor = new CaracteristicMapEditorUI(accidentalTabContent));
        
        accidentalCaracteristicMapEditor.setName("accidentalCaracteristicMapEditor");
    }

    protected void createAccidentalCaracteristicMapEditorReminderLabel() {
        $objectMap.put("accidentalCaracteristicMapEditorReminderLabel", accidentalCaracteristicMapEditorReminderLabel = new JXTitledPanel());
        
        accidentalCaracteristicMapEditorReminderLabel.setName("accidentalCaracteristicMapEditorReminderLabel");
    }

    protected void createAccidentalTab() {
        $objectMap.put("accidentalTab", accidentalTab = new TabInfo());
    }

    protected void createAccidentalTabContent() {
        $objectMap.put("accidentalTabContent", accidentalTabContent = new AccidentalBatchUI(this));
        
        accidentalTabContent.setName("accidentalTabContent");
    }

    protected void createAccidentalTabCreateBatch() {
        $objectMap.put("accidentalTabCreateBatch", accidentalTabCreateBatch = new CreateAccidentalBatchUI(this));
        
        accidentalTabCreateBatch.setName("accidentalTabCreateBatch");
    }

    protected void createAccidentalTabCreateBatchReminderLabel() {
        $objectMap.put("accidentalTabCreateBatchReminderLabel", accidentalTabCreateBatchReminderLabel = new JXTitledPanel());
        
        accidentalTabCreateBatchReminderLabel.setName("accidentalTabCreateBatchReminderLabel");
    }

    protected void createAccidentalTabFishingOperationReminderLabel() {
        $objectMap.put("accidentalTabFishingOperationReminderLabel", accidentalTabFishingOperationReminderLabel = new JXTitledPanel());
        
        accidentalTabFishingOperationReminderLabel.setName("accidentalTabFishingOperationReminderLabel");
    }

    protected void createAccidentalTabPanel() {
        $objectMap.put("accidentalTabPanel", accidentalTabPanel = new JPanel());
        
        accidentalTabPanel.setName("accidentalTabPanel");
        accidentalTabPanel.setLayout(accidentalTabPanelLayout);
    }

    protected void createAccidentalTabPanelLayout() {
        $objectMap.put("accidentalTabPanelLayout", accidentalTabPanelLayout = new CardLayout2Ext(this, "accidentalTabPanel"));
    }

    protected void createBenthosTab() {
        $objectMap.put("benthosTab", benthosTab = new TabInfo());
    }

    protected void createBenthosTabAddSampleCategoryBatch() {
        $objectMap.put("benthosTabAddSampleCategoryBatch", benthosTabAddSampleCategoryBatch = new SplitBenthosBatchUI(this));
        
        benthosTabAddSampleCategoryBatch.setName("benthosTabAddSampleCategoryBatch");
    }

    protected void createBenthosTabAddSampleCategoryBatchReminderLabel() {
        $objectMap.put("benthosTabAddSampleCategoryBatchReminderLabel", benthosTabAddSampleCategoryBatchReminderLabel = new JXTitledPanel());
        
        benthosTabAddSampleCategoryBatchReminderLabel.setName("benthosTabAddSampleCategoryBatchReminderLabel");
    }

    protected void createBenthosTabContent() {
        $objectMap.put("benthosTabContent", benthosTabContent = new BenthosBatchUI(this));
        
        benthosTabContent.setName("benthosTabContent");
    }

    protected void createBenthosTabCreateBatch() {
        $objectMap.put("benthosTabCreateBatch", benthosTabCreateBatch = new CreateBenthosBatchUI(this));
        
        benthosTabCreateBatch.setName("benthosTabCreateBatch");
    }

    protected void createBenthosTabCreateBatchReminderLabel() {
        $objectMap.put("benthosTabCreateBatchReminderLabel", benthosTabCreateBatchReminderLabel = new JXTitledPanel());
        
        benthosTabCreateBatchReminderLabel.setName("benthosTabCreateBatchReminderLabel");
    }

    protected void createBenthosTabFishingOperationReminderLabel() {
        $objectMap.put("benthosTabFishingOperationReminderLabel", benthosTabFishingOperationReminderLabel = new JXTitledPanel());
        
        benthosTabFishingOperationReminderLabel.setName("benthosTabFishingOperationReminderLabel");
    }

    protected void createBenthosTabFrequencyEditor() {
        $objectMap.put("benthosTabFrequencyEditor", benthosTabFrequencyEditor = new BenthosFrequencyUI(benthosTabContent));
        
        benthosTabFrequencyEditor.setName("benthosTabFrequencyEditor");
    }

    protected void createBenthosTabFrequencyEditorReminderLabel() {
        $objectMap.put("benthosTabFrequencyEditorReminderLabel", benthosTabFrequencyEditorReminderLabel = new JXTitledPanel());
        
        benthosTabFrequencyEditorReminderLabel.setName("benthosTabFrequencyEditorReminderLabel");
    }

    protected void createBenthosTabPanel() {
        $objectMap.put("benthosTabPanel", benthosTabPanel = new JPanel());
        
        benthosTabPanel.setName("benthosTabPanel");
        benthosTabPanel.setLayout(benthosTabPanelLayout);
    }

    protected void createBenthosTabPanelLayout() {
        $objectMap.put("benthosTabPanelLayout", benthosTabPanelLayout = new CardLayout2Ext(this, "benthosTabPanel"));
    }

    protected void createBenthosTabSplitBatch() {
        $objectMap.put("benthosTabSplitBatch", benthosTabSplitBatch = new SplitBenthosBatchUI(this));
        
        benthosTabSplitBatch.setName("benthosTabSplitBatch");
    }

    protected void createBenthosTabSplitBatchReminderLabel() {
        $objectMap.put("benthosTabSplitBatchReminderLabel", benthosTabSplitBatchReminderLabel = new JXTitledPanel());
        
        benthosTabSplitBatchReminderLabel.setName("benthosTabSplitBatchReminderLabel");
    }

    protected void createBroker() {
        $objectMap.put("broker", broker = new TuttiHelpBroker("tutti.editCatchBatch.help"));
    }

    protected void createCancelButton() {
        $objectMap.put("cancelButton", cancelButton = new JButton());
        
        cancelButton.setName("cancelButton");
        cancelButton.setText(t("tutti.editCatchBatch.action.cancelEditCatchBatch"));
        cancelButton.setToolTipText(t("tutti.editCatchBatch.action.cancelEditCatchBatch.tip"));
        SwingUtil.setComponentHeight(cancelButton,50);
        cancelButton.putClientProperty("help", "tutti.editCatchBatch.action.cancelEditCatchBatch.help");
        cancelButton.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.content.operation.catches.actions.CancelEditCatchBatchAction.class);
    }

    protected void createCatchesCaracteristicsAttachmentsButton() {
        $objectMap.put("catchesCaracteristicsAttachmentsButton", catchesCaracteristicsAttachmentsButton = new ButtonAttachment(getHandler().getContext(), getModel()));
        
        catchesCaracteristicsAttachmentsButton.setName("catchesCaracteristicsAttachmentsButton");
        catchesCaracteristicsAttachmentsButton.setToolTipText(t("tutti.editCatchBatch.action.attachments.tip"));
        catchesCaracteristicsAttachmentsButton.setFocusPainted(false);
    }

    protected void createCatchesCaracteristicsTab() {
        $objectMap.put("catchesCaracteristicsTab", catchesCaracteristicsTab = new TabInfo());
    }

    protected void createCatchesCaracteristicsTabPane() {
        $objectMap.put("catchesCaracteristicsTabPane", catchesCaracteristicsTabPane = new JXTitledPanel());
        
        catchesCaracteristicsTabPane.setName("catchesCaracteristicsTabPane");
    }

    protected void createCatchesCaracteristicsTabToolBar() {
        $objectMap.put("catchesCaracteristicsTabToolBar", catchesCaracteristicsTabToolBar = new JToolBar());
        
        catchesCaracteristicsTabToolBar.setName("catchesCaracteristicsTabToolBar");
        catchesCaracteristicsTabToolBar.setBorderPainted(false);
        catchesCaracteristicsTabToolBar.setOpaque(true);
        catchesCaracteristicsTabToolBar.setFloatable(false);
    }

    protected void createCleanSpeciesBatchButton() {
        $objectMap.put("cleanSpeciesBatchButton", cleanSpeciesBatchButton = new JButton());
        
        cleanSpeciesBatchButton.setName("cleanSpeciesBatchButton");
        cleanSpeciesBatchButton.setText(t("tutti.editCatchBatch.action.cleanWeights"));
        cleanSpeciesBatchButton.setToolTipText(t("tutti.editCatchBatch.action.cleanWeights.tip"));
        SwingUtil.setComponentHeight(cleanSpeciesBatchButton,50);
        cleanSpeciesBatchButton.putClientProperty("help", "tutti.editCatchBatch.action.cleanWeights.help");
        cleanSpeciesBatchButton.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.content.operation.catches.actions.CleanBatchWeightsAction.class);
    }

    protected void createComputeSpeciesBatchButton() {
        $objectMap.put("computeSpeciesBatchButton", computeSpeciesBatchButton = new JButton());
        
        computeSpeciesBatchButton.setName("computeSpeciesBatchButton");
        computeSpeciesBatchButton.setText(t("tutti.editCatchBatch.action.computeWeights"));
        computeSpeciesBatchButton.setToolTipText(t("tutti.editCatchBatch.action.computeWeights.tip"));
        SwingUtil.setComponentHeight(computeSpeciesBatchButton,50);
        computeSpeciesBatchButton.putClientProperty("help", "tutti.editCatchBatch.action.computeWeights.help");
        computeSpeciesBatchButton.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.content.operation.catches.actions.ComputeBatchWeightsAction.class);
    }

    protected void createCreateFishingOperationActions() {
        $objectMap.put("createFishingOperationActions", createFishingOperationActions = new Table());
        
        createFishingOperationActions.setName("createFishingOperationActions");
        SwingUtil.setComponentHeight(createFishingOperationActions,50);
    }

    protected void createExportFishingOperationReportButton() {
        $objectMap.put("exportFishingOperationReportButton", exportFishingOperationReportButton = new JMenuItem());
        
        exportFishingOperationReportButton.setName("exportFishingOperationReportButton");
        exportFishingOperationReportButton.setText(t("tutti.editCatchBatch.action.exportFishingOperationReport"));
        exportFishingOperationReportButton.setToolTipText(t("tutti.editCatchBatch.action.exportFishingOperationReport.tip"));
        exportFishingOperationReportButton.putClientProperty("help", "tutti.editCatchBatch.action.exportFishingOperationReport.help");
        exportFishingOperationReportButton.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.content.operation.catches.actions.ExportFishingOperationReportAction.class);
    }

    protected void createExportFishingOperationReportForSumatraButton() {
        $objectMap.put("exportFishingOperationReportForSumatraButton", exportFishingOperationReportForSumatraButton = new JMenuItem());
        
        exportFishingOperationReportForSumatraButton.setName("exportFishingOperationReportForSumatraButton");
        exportFishingOperationReportForSumatraButton.setText(t("tutti.editCatchBatch.action.exportFishingOperationReportForSumatra"));
        exportFishingOperationReportForSumatraButton.setToolTipText(t("tutti.editCatchBatch.action.exportFishingOperationReportForSumatra.tip"));
        exportFishingOperationReportForSumatraButton.putClientProperty("help", "tutti.editCatchBatch.action.exportFishingOperationReportForSumatra.help");
        exportFishingOperationReportForSumatraButton.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.content.operation.catches.actions.ExportFishingOperationForSumatraAction.class);
    }

    protected void createExportMultiPostButton() {
        $objectMap.put("exportMultiPostButton", exportMultiPostButton = new JMenuItem());
        
        exportMultiPostButton.setName("exportMultiPostButton");
        exportMultiPostButton.setText(t("tutti.editCatchBatch.action.exportMultiPost"));
        exportMultiPostButton.setToolTipText(t("tutti.editCatchBatch.action.exportMultiPost.tip"));
        exportMultiPostButton.putClientProperty("help", "tutti.editCatchBatch.action.exportMultiPost.help");
        exportMultiPostButton.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.content.operation.catches.actions.ExportMultiPostCatchAction.class);
    }

    protected EditCatchesUIHandler createHandler() {
        return new EditCatchesUIHandler();
    }

    protected void createImportMultiPostButton() {
        $objectMap.put("importMultiPostButton", importMultiPostButton = new JMenuItem());
        
        importMultiPostButton.setName("importMultiPostButton");
        importMultiPostButton.setText(t("tutti.editCatchBatch.action.importMultiPost"));
        importMultiPostButton.setToolTipText(t("tutti.editCatchBatch.action.importMultiPost.tip"));
        importMultiPostButton.putClientProperty("help", "tutti.editCatchBatch.action.importMultiPost.help");
        importMultiPostButton.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.content.operation.catches.actions.ImportMultiPostCatchAction.class);
    }

    protected void createIndividualObservationCaracteristicMapEditor() {
        $objectMap.put("individualObservationCaracteristicMapEditor", individualObservationCaracteristicMapEditor = new CaracteristicMapEditorUI(individualObservationTabContent));
        
        individualObservationCaracteristicMapEditor.setName("individualObservationCaracteristicMapEditor");
    }

    protected void createIndividualObservationCaracteristicMapEditorReminderLabel() {
        $objectMap.put("individualObservationCaracteristicMapEditorReminderLabel", individualObservationCaracteristicMapEditorReminderLabel = new JXTitledPanel());
        
        individualObservationCaracteristicMapEditorReminderLabel.setName("individualObservationCaracteristicMapEditorReminderLabel");
    }

    protected void createIndividualObservationTab() {
        $objectMap.put("individualObservationTab", individualObservationTab = new TabInfo());
    }

    protected void createIndividualObservationTabContent() {
        $objectMap.put("individualObservationTabContent", individualObservationTabContent = new IndividualObservationBatchUI(this));
        
        individualObservationTabContent.setName("individualObservationTabContent");
    }

    protected void createIndividualObservationTabCreateBatch() {
        $objectMap.put("individualObservationTabCreateBatch", individualObservationTabCreateBatch = new CreateIndividualObservationBatchUI(this));
        
        individualObservationTabCreateBatch.setName("individualObservationTabCreateBatch");
    }

    protected void createIndividualObservationTabCreateBatchReminderLabel() {
        $objectMap.put("individualObservationTabCreateBatchReminderLabel", individualObservationTabCreateBatchReminderLabel = new JXTitledPanel());
        
        individualObservationTabCreateBatchReminderLabel.setName("individualObservationTabCreateBatchReminderLabel");
    }

    protected void createIndividualObservationTabFishingOperationReminderLabel() {
        $objectMap.put("individualObservationTabFishingOperationReminderLabel", individualObservationTabFishingOperationReminderLabel = new JXTitledPanel());
        
        individualObservationTabFishingOperationReminderLabel.setName("individualObservationTabFishingOperationReminderLabel");
    }

    protected void createIndividualObservationTabPanel() {
        $objectMap.put("individualObservationTabPanel", individualObservationTabPanel = new JPanel());
        
        individualObservationTabPanel.setName("individualObservationTabPanel");
        individualObservationTabPanel.setLayout(individualObservationTabPanelLayout);
    }

    protected void createIndividualObservationTabPanelLayout() {
        $objectMap.put("individualObservationTabPanelLayout", individualObservationTabPanelLayout = new CardLayout2Ext(this, "individualObservationTabPanel"));
    }

    protected void createMarineLitterTab() {
        $objectMap.put("marineLitterTab", marineLitterTab = new TabInfo());
        
        marineLitterTab.setTitle(t("tutti.label.tab.marineLitter"));
    }

    protected void createMarineLitterTabContent() {
        $objectMap.put("marineLitterTabContent", marineLitterTabContent = new MarineLitterBatchUI(this));
        
        marineLitterTabContent.setName("marineLitterTabContent");
    }

    protected void createMarineLitterTabCreateBatch() {
        $objectMap.put("marineLitterTabCreateBatch", marineLitterTabCreateBatch = new CreateMarineLitterBatchUI(this));
        
        marineLitterTabCreateBatch.setName("marineLitterTabCreateBatch");
    }

    protected void createMarineLitterTabCreateBatchReminderLabel() {
        $objectMap.put("marineLitterTabCreateBatchReminderLabel", marineLitterTabCreateBatchReminderLabel = new JXTitledPanel());
        
        marineLitterTabCreateBatchReminderLabel.setName("marineLitterTabCreateBatchReminderLabel");
    }

    protected void createMarineLitterTabFishingOperationReminderLabel() {
        $objectMap.put("marineLitterTabFishingOperationReminderLabel", marineLitterTabFishingOperationReminderLabel = new JXTitledPanel());
        
        marineLitterTabFishingOperationReminderLabel.setName("marineLitterTabFishingOperationReminderLabel");
    }

    protected void createMarineLitterTabPanel() {
        $objectMap.put("marineLitterTabPanel", marineLitterTabPanel = new JPanel());
        
        marineLitterTabPanel.setName("marineLitterTabPanel");
        marineLitterTabPanel.setLayout(marineLitterTabPanelLayout);
    }

    protected void createMarineLitterTabPanelLayout() {
        $objectMap.put("marineLitterTabPanelLayout", marineLitterTabPanelLayout = new CardLayout2Ext(this, "marineLitterTabPanel"));
    }

    protected void createMenu() {
        $objectMap.put("menu", menu = new JMenuBar());
        
        menu.setName("menu");
    }

    protected void createMenuAction() {
        $objectMap.put("menuAction", menuAction = new JMenu());
        
        menuAction.setName("menuAction");
        menuAction.setOpaque(true);
        menuAction.setText(t("tutti.toolbar.menu.action"));
        menuAction.setToolTipText(t("tutti.toolbar.menu.action.tip"));
    }

    protected void createModel() {
        $objectMap.put("model", model = getContextValue(EditCatchesUIModel.class));
    }

    protected void createSaveButton() {
        $objectMap.put("saveButton", saveButton = new JButton());
        
        saveButton.setName("saveButton");
        saveButton.setText(t("tutti.editCatchBatch.action.saveCatchBatch"));
        saveButton.setToolTipText(t("tutti.editCatchBatch.action.saveCatchBatch.tip"));
        SwingUtil.setComponentHeight(saveButton,50);
        saveButton.putClientProperty("help", "tutti.editCatchBatch.action.saveCatchBatch.help");
        saveButton.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.content.operation.catches.actions.SaveCatchBatchAction.class);
    }

    protected void createSpeciesTab() {
        $objectMap.put("speciesTab", speciesTab = new TabInfo());
    }

    protected void createSpeciesTabAddSampleCategoryBatch() {
        $objectMap.put("speciesTabAddSampleCategoryBatch", speciesTabAddSampleCategoryBatch = new SplitSpeciesBatchUI(this));
        
        speciesTabAddSampleCategoryBatch.setName("speciesTabAddSampleCategoryBatch");
    }

    protected void createSpeciesTabAddSampleCategoryBatchReminderLabel() {
        $objectMap.put("speciesTabAddSampleCategoryBatchReminderLabel", speciesTabAddSampleCategoryBatchReminderLabel = new JXTitledPanel());
        
        speciesTabAddSampleCategoryBatchReminderLabel.setName("speciesTabAddSampleCategoryBatchReminderLabel");
    }

    protected void createSpeciesTabContent() {
        $objectMap.put("speciesTabContent", speciesTabContent = new SpeciesBatchUI(this));
        
        speciesTabContent.setName("speciesTabContent");
    }

    protected void createSpeciesTabCreateBatch() {
        $objectMap.put("speciesTabCreateBatch", speciesTabCreateBatch = new CreateSpeciesBatchUI(this));
        
        speciesTabCreateBatch.setName("speciesTabCreateBatch");
    }

    protected void createSpeciesTabCreateBatchReminderLabel() {
        $objectMap.put("speciesTabCreateBatchReminderLabel", speciesTabCreateBatchReminderLabel = new JXTitledPanel());
        
        speciesTabCreateBatchReminderLabel.setName("speciesTabCreateBatchReminderLabel");
    }

    protected void createSpeciesTabFishingOperationReminderLabel() {
        $objectMap.put("speciesTabFishingOperationReminderLabel", speciesTabFishingOperationReminderLabel = new JXTitledPanel());
        
        speciesTabFishingOperationReminderLabel.setName("speciesTabFishingOperationReminderLabel");
    }

    protected void createSpeciesTabFrequencyEditor() {
        $objectMap.put("speciesTabFrequencyEditor", speciesTabFrequencyEditor = new SpeciesFrequencyUI(speciesTabContent));
        
        speciesTabFrequencyEditor.setName("speciesTabFrequencyEditor");
    }

    protected void createSpeciesTabFrequencyEditorReminderLabel() {
        $objectMap.put("speciesTabFrequencyEditorReminderLabel", speciesTabFrequencyEditorReminderLabel = new JXTitledPanel());
        
        speciesTabFrequencyEditorReminderLabel.setName("speciesTabFrequencyEditorReminderLabel");
    }

    protected void createSpeciesTabPanel() {
        $objectMap.put("speciesTabPanel", speciesTabPanel = new JPanel());
        
        speciesTabPanel.setName("speciesTabPanel");
        speciesTabPanel.setLayout(speciesTabPanelLayout);
    }

    protected void createSpeciesTabPanelLayout() {
        $objectMap.put("speciesTabPanelLayout", speciesTabPanelLayout = new CardLayout2Ext(this, "speciesTabPanel"));
    }

    protected void createSpeciesTabSplitBatch() {
        $objectMap.put("speciesTabSplitBatch", speciesTabSplitBatch = new SplitSpeciesBatchUI(this));
        
        speciesTabSplitBatch.setName("speciesTabSplitBatch");
    }

    protected void createSpeciesTabSplitBatchReminderLabel() {
        $objectMap.put("speciesTabSplitBatchReminderLabel", speciesTabSplitBatchReminderLabel = new JXTitledPanel());
        
        speciesTabSplitBatchReminderLabel.setName("speciesTabSplitBatchReminderLabel");
    }

    protected void createSvgCanvasPanel() {
        $objectMap.put("svgCanvasPanel", svgCanvasPanel = new JPanel());
        
        svgCanvasPanel.setName("svgCanvasPanel");
        svgCanvasPanel.setLayout(new BorderLayout());
    }

    protected void createTabPane() {
        $objectMap.put("tabPane", tabPane = new JTabbedPane());
        
        tabPane.setName("tabPane");
    }

    protected void createValidator() {
        $objectMap.put("validator", validator = SwingValidator.newValidator(EditCatchesUIModel.class, "validate"));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToEditCatchesTopPanel();
        addChildrenToValidator();
        addChildrenToCatchesCaracteristicsTabToolBar();
        addChildrenToMenu();
        addChildrenToMenuAction();
        addChildrenToTabPane();
        addChildrenToCatchesCaracteristicsTabPane();
        addChildrenToSpeciesTabPanel();
        addChildrenToSpeciesTabFishingOperationReminderLabel();
        addChildrenToSpeciesTabCreateBatchReminderLabel();
        addChildrenToSpeciesTabSplitBatchReminderLabel();
        addChildrenToSpeciesTabAddSampleCategoryBatchReminderLabel();
        addChildrenToSpeciesTabFrequencyEditorReminderLabel();
        addChildrenToBenthosTabPanel();
        addChildrenToBenthosTabFishingOperationReminderLabel();
        addChildrenToBenthosTabCreateBatchReminderLabel();
        addChildrenToBenthosTabSplitBatchReminderLabel();
        addChildrenToBenthosTabAddSampleCategoryBatchReminderLabel();
        addChildrenToBenthosTabFrequencyEditorReminderLabel();
        addChildrenToMarineLitterTabPanel();
        addChildrenToMarineLitterTabFishingOperationReminderLabel();
        addChildrenToMarineLitterTabCreateBatchReminderLabel();
        addChildrenToIndividualObservationTabPanel();
        addChildrenToIndividualObservationTabFishingOperationReminderLabel();
        addChildrenToIndividualObservationTabCreateBatchReminderLabel();
        addChildrenToIndividualObservationCaracteristicMapEditorReminderLabel();
        addChildrenToAccidentalTabPanel();
        addChildrenToAccidentalTabFishingOperationReminderLabel();
        addChildrenToAccidentalTabCreateBatchReminderLabel();
        addChildrenToAccidentalCaracteristicMapEditorReminderLabel();
        addChildrenToCreateFishingOperationActions();
        
        // apply 7 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 27 property setters
        menu.setBorder(null);
        menu.setBackground(javax.swing.UIManager.getColor("MenuBar.background"));
        menuAction.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.toolbar.menu.action.mnemonic"),'Z'));
        exportFishingOperationReportButton.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.editCatchBatch.action.exportFishingOperationReport.mnemonic"),'Z'));
        exportFishingOperationReportButton.setIcon(SwingUtil.createActionIcon("export"));
        exportFishingOperationReportForSumatraButton.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.editCatchBatch.action.exportFishingOperationReportForSumatra.mnemonic"),'Z'));
        exportFishingOperationReportForSumatraButton.setIcon(SwingUtil.createActionIcon("export"));
        importMultiPostButton.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.editCatchBatch.action.importMultiPost.mnemonic"),'Z'));
        importMultiPostButton.setIcon(SwingUtil.createActionIcon("import"));
        exportMultiPostButton.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.editCatchBatch.action.exportMultiPost.mnemonic"),'Z'));
        exportMultiPostButton.setIcon(SwingUtil.createActionIcon("export"));
        catchesCaracteristicsTabPane.setRightDecoration(catchesCaracteristicsTabToolBar);
        cancelButton.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.editCatchBatch.action.cancelEditCatchBatch.mnemonic"),'Z'));
        cancelButton.setIcon(SwingUtil.createActionIcon("cancel"));
        saveButton.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.editCatchBatch.action.saveCatchBatch.mnemonic"),'Z'));
        saveButton.setIcon(SwingUtil.createActionIcon("save"));
        cleanSpeciesBatchButton.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.editCatchBatch.action.cleanWeights.mnemonic"),'Z'));
        cleanSpeciesBatchButton.setIcon(SwingUtil.createActionIcon("clean"));
        computeSpeciesBatchButton.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.editCatchBatch.action.computeWeights.mnemonic"),'Z'));
        computeSpeciesBatchButton.setIcon(SwingUtil.createActionIcon("generate"));
        // late initializer
        // help broker setup
        TuttiHelpBroker _broker = getBroker();
        registerHelpId(_broker, editCatchesTopPanel, "tutti.editCatchBatch.help");
        registerHelpId(_broker, exportFishingOperationReportButton, "tutti.editCatchBatch.action.exportFishingOperationReport.help");
        registerHelpId(_broker, exportFishingOperationReportForSumatraButton, "tutti.editCatchBatch.action.exportFishingOperationReportForSumatra.help");
        registerHelpId(_broker, importMultiPostButton, "tutti.editCatchBatch.action.importMultiPost.help");
        registerHelpId(_broker, exportMultiPostButton, "tutti.editCatchBatch.action.exportMultiPost.help");
        registerHelpId(_broker, cancelButton, "tutti.editCatchBatch.action.cancelEditCatchBatch.help");
        registerHelpId(_broker, saveButton, "tutti.editCatchBatch.action.saveCatchBatch.help");
        registerHelpId(_broker, cleanSpeciesBatchButton, "tutti.editCatchBatch.action.cleanWeights.help");
        registerHelpId(_broker, computeSpeciesBatchButton, "tutti.editCatchBatch.action.computeWeights.help");
        _broker.prepareUI(this);
        // register 1 validator(s)
        validatorIds = SwingValidatorUtil.detectValidators(this);
        SwingValidatorUtil.installUI(this);
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        handler.beforeInit(this);
        $objectMap.put("editCatchesTopPanel", editCatchesTopPanel);
        createModel();
        createValidator();
        createSpeciesTabPanelLayout();
        createBenthosTabPanelLayout();
        createMarineLitterTabPanelLayout();
        createAccidentalTabPanelLayout();
        createIndividualObservationTabPanelLayout();
        createBroker();
        createCatchesCaracteristicsTabToolBar();
        createMenu();
        createMenuAction();
        createExportFishingOperationReportButton();
        createExportFishingOperationReportForSumatraButton();
        createImportMultiPostButton();
        createExportMultiPostButton();
        createCatchesCaracteristicsAttachmentsButton();
        createTabPane();
        createCatchesCaracteristicsTabPane();
        createSvgCanvasPanel();
        createSpeciesTabPanel();
        createSpeciesTabFishingOperationReminderLabel();
        createSpeciesTabContent();
        createSpeciesTabCreateBatchReminderLabel();
        createSpeciesTabCreateBatch();
        createSpeciesTabSplitBatchReminderLabel();
        createSpeciesTabSplitBatch();
        createSpeciesTabAddSampleCategoryBatchReminderLabel();
        createSpeciesTabAddSampleCategoryBatch();
        createSpeciesTabFrequencyEditorReminderLabel();
        createSpeciesTabFrequencyEditor();
        createBenthosTabPanel();
        createBenthosTabFishingOperationReminderLabel();
        createBenthosTabContent();
        createBenthosTabCreateBatchReminderLabel();
        createBenthosTabCreateBatch();
        createBenthosTabSplitBatchReminderLabel();
        createBenthosTabSplitBatch();
        createBenthosTabAddSampleCategoryBatchReminderLabel();
        createBenthosTabAddSampleCategoryBatch();
        createBenthosTabFrequencyEditorReminderLabel();
        createBenthosTabFrequencyEditor();
        createMarineLitterTabPanel();
        createMarineLitterTabFishingOperationReminderLabel();
        createMarineLitterTabContent();
        createMarineLitterTabCreateBatchReminderLabel();
        createMarineLitterTabCreateBatch();
        createIndividualObservationTabPanel();
        createIndividualObservationTabFishingOperationReminderLabel();
        createIndividualObservationTabContent();
        createIndividualObservationTabCreateBatchReminderLabel();
        createIndividualObservationTabCreateBatch();
        createIndividualObservationCaracteristicMapEditorReminderLabel();
        createIndividualObservationCaracteristicMapEditor();
        createAccidentalTabPanel();
        createAccidentalTabFishingOperationReminderLabel();
        createAccidentalTabContent();
        createAccidentalTabCreateBatchReminderLabel();
        createAccidentalTabCreateBatch();
        createAccidentalCaracteristicMapEditorReminderLabel();
        createAccidentalCaracteristicMapEditor();
        createCreateFishingOperationActions();
        createCancelButton();
        createSaveButton();
        createCleanSpeciesBatchButton();
        createComputeSpeciesBatchButton();
        createCatchesCaracteristicsTab();
        createSpeciesTab();
        createBenthosTab();
        createMarineLitterTab();
        createIndividualObservationTab();
        createAccidentalTab();
        // inline creation of editCatchesTopPanel
        setName("editCatchesTopPanel");
        setLayout(new BorderLayout());
        editCatchesTopPanel.putClientProperty("help", "tutti.editCatchBatch.help");
        
        // registers 7 data bindings
        $registerDefaultBindings();
        $completeSetup();
        handler.afterInit(this);
    }

    private void $registerDefaultBindings() {
        // register 7 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CATCHES_CARACTERISTICS_ATTACHMENTS_BUTTON_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("objectId", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    catchesCaracteristicsAttachmentsButton.setEnabled(model.getObjectId() != null);
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("objectId", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SPECIES_TAB_FISHING_OPERATION_REMINDER_LABEL_RIGHT_DECORATION, true) {
        
            @Override
            public void applyDataBinding() {
                if (speciesTabContent != null) {
                    speciesTabContent.addPropertyChangeListener("speciesBatchTabToolBar", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (speciesTabContent != null) {
                    speciesTabFishingOperationReminderLabel.setRightDecoration(speciesTabContent.getSpeciesBatchTabToolBar());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (speciesTabContent != null) {
                    speciesTabContent.removePropertyChangeListener("speciesBatchTabToolBar", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_BENTHOS_TAB_FISHING_OPERATION_REMINDER_LABEL_RIGHT_DECORATION, true) {
        
            @Override
            public void applyDataBinding() {
                if (benthosTabContent != null) {
                    benthosTabContent.addPropertyChangeListener("benthosBatchTabToolBar", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (benthosTabContent != null) {
                    benthosTabFishingOperationReminderLabel.setRightDecoration(benthosTabContent.getBenthosBatchTabToolBar());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (benthosTabContent != null) {
                    benthosTabContent.removePropertyChangeListener("benthosBatchTabToolBar", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_MARINE_LITTER_TAB_FISHING_OPERATION_REMINDER_LABEL_RIGHT_DECORATION, true) {
        
            @Override
            public void applyDataBinding() {
                if (marineLitterTabContent != null) {
                    marineLitterTabContent.addPropertyChangeListener("marineLitterBatchTabToolBar", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (marineLitterTabContent != null) {
                    marineLitterTabFishingOperationReminderLabel.setRightDecoration(marineLitterTabContent.getMarineLitterBatchTabToolBar());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (marineLitterTabContent != null) {
                    marineLitterTabContent.removePropertyChangeListener("marineLitterBatchTabToolBar", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_INDIVIDUAL_OBSERVATION_TAB_FISHING_OPERATION_REMINDER_LABEL_RIGHT_DECORATION, true) {
        
            @Override
            public void applyDataBinding() {
                if (individualObservationTabContent != null) {
                    individualObservationTabContent.addPropertyChangeListener("individualObservationBatchTabToolBar", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (individualObservationTabContent != null) {
                    individualObservationTabFishingOperationReminderLabel.setRightDecoration(individualObservationTabContent.getIndividualObservationBatchTabToolBar());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (individualObservationTabContent != null) {
                    individualObservationTabContent.removePropertyChangeListener("individualObservationBatchTabToolBar", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_ACCIDENTAL_TAB_FISHING_OPERATION_REMINDER_LABEL_RIGHT_DECORATION, true) {
        
            @Override
            public void applyDataBinding() {
                if (accidentalTabContent != null) {
                    accidentalTabContent.addPropertyChangeListener("accidentalBatchTabToolBar", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (accidentalTabContent != null) {
                    accidentalTabFishingOperationReminderLabel.setRightDecoration(accidentalTabContent.getAccidentalBatchTabToolBar());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (accidentalTabContent != null) {
                    accidentalTabContent.removePropertyChangeListener("accidentalBatchTabToolBar", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SAVE_BUTTON_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("modify", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    saveButton.setEnabled(model.isModify());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("modify", this);
                }
            }
        });
    }

}